/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.effects.JFXDepthManager;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccount;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.account.AccountListItem;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.BindingMapping;

public class AccountListItemSkin
extends SkinBase<AccountListItem> {
    public AccountListItemSkin(final AccountListItem skinnable) {
        super((Control)skinnable);
        BorderPane root = new BorderPane();
        JFXRadioButton chkSelected = new JFXRadioButton(){

            public void fire() {
                skinnable.fire();
            }
        };
        BorderPane.setAlignment((Node)chkSelected, (Pos)Pos.CENTER);
        chkSelected.selectedProperty().bind((ObservableValue)skinnable.selectedProperty());
        root.setLeft((Node)chkSelected);
        HBox center = new HBox();
        center.setSpacing(8.0);
        center.setAlignment(Pos.CENTER_LEFT);
        ImageView imageView = new ImageView();
        FXUtils.limitSize(imageView, 32.0, 32.0);
        imageView.imageProperty().bind(skinnable.imageProperty());
        Label title = new Label();
        title.getStyleClass().add((Object)"title");
        title.textProperty().bind((ObservableValue)skinnable.titleProperty());
        Label subtitle = new Label();
        subtitle.getStyleClass().add((Object)"subtitle");
        subtitle.textProperty().bind((ObservableValue)skinnable.subtitleProperty());
        if (skinnable.getAccount() instanceof AuthlibInjectorAccount) {
            Tooltip tooltip = new Tooltip();
            AuthlibInjectorServer server = ((AuthlibInjectorAccount)skinnable.getAccount()).getServer();
            tooltip.textProperty().bind(BindingMapping.of(server, AuthlibInjectorServer::toString));
            FXUtils.installSlowTooltip((Node)subtitle, tooltip);
        }
        VBox item = new VBox(new Node[]{title, subtitle});
        item.getStyleClass().add((Object)"two-line-list-item");
        BorderPane.setAlignment((Node)item, (Pos)Pos.CENTER);
        center.getChildren().setAll((Object[])new Node[]{imageView, item});
        root.setCenter((Node)center);
        HBox right = new HBox();
        right.setAlignment(Pos.CENTER_RIGHT);
        JFXButton btnRefresh = new JFXButton();
        btnRefresh.setOnMouseClicked(e -> skinnable.refresh());
        btnRefresh.getStyleClass().add((Object)"toggle-icon4");
        btnRefresh.setGraphic(SVG.refresh(Theme.blackFillBinding(), -1.0, -1.0));
        FXUtils.runInFX(() -> FXUtils.installFastTooltip((Node)btnRefresh, I18n.i18n("button.refresh")));
        right.getChildren().add((Object)btnRefresh);
        JFXButton btnUpload = new JFXButton();
        btnUpload.setOnMouseClicked(e -> skinnable.uploadSkin());
        btnUpload.getStyleClass().add((Object)"toggle-icon4");
        btnUpload.setGraphic(SVG.hanger(Theme.blackFillBinding(), -1.0, -1.0));
        FXUtils.runInFX(() -> FXUtils.installFastTooltip((Node)btnUpload, I18n.i18n("account.skin.upload")));
        btnUpload.managedProperty().bind((ObservableValue)btnUpload.visibleProperty());
        btnUpload.visibleProperty().bind((ObservableValue)skinnable.canUploadSkin());
        right.getChildren().add((Object)btnUpload);
        JFXButton btnRemove = new JFXButton();
        btnRemove.setOnMouseClicked(e -> skinnable.remove());
        btnRemove.getStyleClass().add((Object)"toggle-icon4");
        BorderPane.setAlignment((Node)btnRemove, (Pos)Pos.CENTER);
        btnRemove.setGraphic(SVG.delete(Theme.blackFillBinding(), -1.0, -1.0));
        FXUtils.runInFX(() -> FXUtils.installFastTooltip((Node)btnRemove, I18n.i18n("button.delete")));
        right.getChildren().add((Object)btnRemove);
        root.setRight((Node)right);
        root.getStyleClass().add((Object)"card");
        root.setStyle("-fx-padding: 8 8 8 0;");
        JFXDepthManager.setDepth((Node)root, 1);
        this.getChildren().setAll((Object[])new Node[]{root});
    }
}

