/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXProgressBar;
import java.util.function.Consumer;
import java.util.logging.Level;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.NoSelectedCharacterException;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.account.AddAccountPane;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.util.Logging;

public class AccountLoginPane
extends StackPane {
    private final Account oldAccount;
    private final Consumer<AuthInfo> success;
    private final Runnable failed;
    @FXML
    private Label lblUsername;
    @FXML
    private JFXPasswordField txtPassword;
    @FXML
    private Label lblCreationWarning;
    @FXML
    private JFXProgressBar progressBar;

    public AccountLoginPane(Account oldAccount, Consumer<AuthInfo> success, Runnable failed) {
        this.oldAccount = oldAccount;
        this.success = success;
        this.failed = failed;
        FXUtils.loadFXML((Node)this, "/assets/fxml/account-login.fxml");
        this.lblUsername.setText(oldAccount.getUsername());
        this.txtPassword.setOnAction(e -> this.onAccept());
    }

    @FXML
    private void onAccept() {
        String password = this.txtPassword.getText();
        this.progressBar.setVisible(true);
        this.lblCreationWarning.setText("");
        Task.supplyAsync(() -> this.oldAccount.logInWithPassword(password)).whenComplete(Schedulers.javafx(), authInfo -> {
            this.success.accept((AuthInfo)authInfo);
            this.fireEvent(new DialogCloseEvent());
            this.progressBar.setVisible(false);
        }, e -> {
            Logging.LOG.log(Level.INFO, "Failed to login with password: " + this.oldAccount, (Throwable)e);
            if (e instanceof NoSelectedCharacterException) {
                this.fireEvent(new DialogCloseEvent());
            } else {
                this.lblCreationWarning.setText(AddAccountPane.accountException(e));
            }
            this.progressBar.setVisible(false);
        }).start();
    }

    @FXML
    private void onCancel() {
        this.failed.run();
        this.fireEvent(new DialogCloseEvent());
    }
}

