/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXTextField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.auth.AccountFactory;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterDeletedException;
import org.jackhuang.hmcl.auth.CharacterSelector;
import org.jackhuang.hmcl.auth.NoCharacterException;
import org.jackhuang.hmcl.auth.NoSelectedCharacterException;
import org.jackhuang.hmcl.auth.ServerDisconnectException;
import org.jackhuang.hmcl.auth.ServerResponseMalformedException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDownloadException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.auth.yggdrasil.GameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.RemoteAuthenticationException;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilService;
import org.jackhuang.hmcl.game.TexturesLoader;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.account.AddAuthlibInjectorServerPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.IconedItem;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.BindingMapping;

public class AddAccountPane
extends StackPane {
    @FXML
    private JFXTextField txtUsername;
    @FXML
    private JFXPasswordField txtPassword;
    @FXML
    private Label lblCreationWarning;
    @FXML
    private Label lblPassword;
    @FXML
    private Label lblUsername;
    @FXML
    private JFXComboBox<AccountFactory<?>> cboType;
    @FXML
    private JFXComboBox<AuthlibInjectorServer> cboServers;
    @FXML
    private Label lblInjectorServer;
    @FXML
    private JFXButton btnAccept;
    @FXML
    private JFXButton btnAddServer;
    @FXML
    private JFXButton btnManageServer;
    @FXML
    private SpinnerPane acceptPane;
    @FXML
    private HBox linksContainer;
    private ListProperty<Hyperlink> links = new SimpleListProperty();
    private static final String[] ALLOWED_LINKS = new String[]{"register"};

    public AddAccountPane() {
        FXUtils.loadFXML((Node)this, "/assets/fxml/account-add.fxml");
        this.cboServers.setCellFactory(FXUtils.jfxListCellFactory(server -> new TwoLineListItem(server.getName(), server.getUrl())));
        this.cboServers.setConverter(FXUtils.stringConverter(AuthlibInjectorServer::getName));
        Bindings.bindContent((List)this.cboServers.getItems(), ConfigHolder.config().getAuthlibInjectorServers());
        this.cboServers.getItems().addListener(FXUtils.onInvalidating(this::selectDefaultServer));
        this.selectDefaultServer();
        this.cboType.getItems().setAll(Accounts.FACTORIES);
        this.cboType.setConverter(FXUtils.stringConverter(Accounts::getLocalizedLoginTypeName));
        this.cboType.getSelectionModel().select((Object)this.cboType.getItems().stream().filter(type -> Accounts.getLoginType(type).equals(ConfigHolder.config().getPreferredLoginType())).findFirst().orElse(Accounts.FACTORY_OFFLINE));
        this.btnAddServer.visibleProperty().bind((ObservableValue)this.cboServers.visibleProperty());
        this.btnManageServer.visibleProperty().bind((ObservableValue)this.cboServers.visibleProperty());
        this.cboServers.getItems().addListener(FXUtils.onInvalidating(this::checkIfNoServer));
        this.checkIfNoServer();
        ReadOnlyObjectProperty loginType = this.cboType.getSelectionModel().selectedItemProperty();
        loginType.addListener((observable, oldValue, newValue) -> ConfigHolder.config().setPreferredLoginType(Accounts.getLoginType(newValue)));
        this.txtUsername.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> ((AccountFactory)loginType.get()).getLoginType().requiresUsername, (Observable[])new Observable[]{loginType}));
        this.lblUsername.visibleProperty().bind((ObservableValue)this.txtUsername.visibleProperty());
        this.txtPassword.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> ((AccountFactory)loginType.get()).getLoginType().requiresPassword, (Observable[])new Observable[]{loginType}));
        this.lblPassword.visibleProperty().bind((ObservableValue)this.txtPassword.visibleProperty());
        this.cboServers.visibleProperty().bind((ObservableValue)loginType.isEqualTo((Object)Accounts.FACTORY_AUTHLIB_INJECTOR));
        this.lblInjectorServer.visibleProperty().bind((ObservableValue)this.cboServers.visibleProperty());
        this.txtUsername.getValidators().add((Object)new Validator(I18n.i18n("input.email"), this::validateUsername));
        this.btnAccept.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.txtUsername.isVisible() && !this.txtUsername.validate() || this.txtPassword.isVisible() && !this.txtPassword.validate() || this.cboServers.isVisible() && this.cboServers.getSelectionModel().getSelectedItem() == null, (Observable[])new Observable[]{this.txtUsername.textProperty(), this.txtPassword.textProperty(), loginType, this.cboServers.getSelectionModel().selectedItemProperty(), this.txtPassword.visibleProperty(), this.cboServers.visibleProperty()}));
        this.links.bind(BindingMapping.of(this.cboServers.getSelectionModel().selectedItemProperty()).map(AddAccountPane::createHyperlinks).map(FXCollections::observableList));
        Bindings.bindContent((List)this.linksContainer.getChildren(), this.links);
        this.linksContainer.visibleProperty().bind((ObservableValue)this.cboServers.visibleProperty());
    }

    private boolean validateUsername(String username) {
        AuthlibInjectorServer server;
        AccountFactory loginType = (AccountFactory)this.cboType.getSelectionModel().getSelectedItem();
        if (loginType == Accounts.FACTORY_OFFLINE) {
            return true;
        }
        if (loginType == Accounts.FACTORY_AUTHLIB_INJECTOR && (server = (AuthlibInjectorServer)this.cboServers.getSelectionModel().getSelectedItem()) != null && server.isNonEmailLogin()) {
            return true;
        }
        return username.contains("@");
    }

    public static List<Hyperlink> createHyperlinks(AuthlibInjectorServer server) {
        if (server == null) {
            return Collections.emptyList();
        }
        Map<String, String> links = server.getLinks();
        ArrayList<Hyperlink> result = new ArrayList<Hyperlink>();
        for (String key : ALLOWED_LINKS) {
            String value = links.get(key);
            if (value == null) continue;
            Hyperlink link = new Hyperlink(I18n.i18n("account.injector.link." + key));
            FXUtils.installSlowTooltip((Node)link, value);
            link.setOnAction(e -> FXUtils.openLink(value));
            result.add(link);
        }
        return Collections.unmodifiableList(result);
    }

    private void selectDefaultServer() {
        if (!this.cboServers.getItems().isEmpty() && this.cboServers.getSelectionModel().isEmpty()) {
            this.cboServers.getSelectionModel().select(0);
        }
    }

    private void checkIfNoServer() {
        if (this.cboServers.getItems().isEmpty()) {
            this.cboServers.getStyleClass().setAll((Object[])new String[]{"jfx-combo-box-warning"});
        } else {
            this.cboServers.getStyleClass().setAll((Object[])new String[]{"jfx-combo-box"});
        }
    }

    private Object getAuthAdditionalData() {
        AccountFactory factory = (AccountFactory)this.cboType.getSelectionModel().getSelectedItem();
        if (factory == Accounts.FACTORY_AUTHLIB_INJECTOR) {
            return Objects.requireNonNull(this.cboServers.getSelectionModel().getSelectedItem(), "selected server cannot be null");
        }
        return null;
    }

    @FXML
    private void onCreationAccept() {
        if (this.btnAccept.isDisabled()) {
            return;
        }
        this.acceptPane.showSpinner();
        this.lblCreationWarning.setText("");
        this.setDisable(true);
        String username = this.txtUsername.getText();
        String password = this.txtPassword.getText();
        AccountFactory factory = (AccountFactory)this.cboType.getSelectionModel().getSelectedItem();
        Object additionalData = this.getAuthAdditionalData();
        Task.supplyAsync(() -> factory.create(new Selector(), username, password, additionalData)).whenComplete(Schedulers.javafx(), account -> {
            int oldIndex = Accounts.getAccounts().indexOf(account);
            if (oldIndex == -1) {
                Accounts.getAccounts().add(account);
            } else {
                Accounts.getAccounts().remove(oldIndex);
                Accounts.getAccounts().add(oldIndex, account);
            }
            Accounts.setSelectedAccount(account);
            this.acceptPane.hideSpinner();
            this.fireEvent(new DialogCloseEvent());
        }, exception -> {
            if (exception instanceof NoSelectedCharacterException) {
                this.fireEvent(new DialogCloseEvent());
            } else {
                this.lblCreationWarning.setText(AddAccountPane.accountException(exception));
            }
            this.setDisable(false);
            this.acceptPane.hideSpinner();
        }).start();
    }

    @FXML
    private void onCreationCancel() {
        this.fireEvent(new DialogCloseEvent());
    }

    @FXML
    private void onManageInjecterServers() {
        this.fireEvent(new DialogCloseEvent());
        Controllers.navigate((Node)Controllers.getServersPage());
    }

    @FXML
    private void onAddInjecterServer() {
        Controllers.dialog((Region)new AddAuthlibInjectorServerPane());
    }

    public static String accountException(Exception exception) {
        if (exception instanceof NoCharacterException) {
            return I18n.i18n("account.failed.no_character");
        }
        if (exception instanceof ServerDisconnectException) {
            return I18n.i18n("account.failed.connect_authentication_server");
        }
        if (exception instanceof ServerResponseMalformedException) {
            return I18n.i18n("account.failed.server_response_malformed");
        }
        if (exception instanceof RemoteAuthenticationException) {
            RemoteAuthenticationException remoteException = (RemoteAuthenticationException)exception;
            String remoteMessage = remoteException.getRemoteMessage();
            if ("ForbiddenOperationException".equals(remoteException.getRemoteName()) && remoteMessage != null) {
                if (remoteMessage.contains("Invalid credentials")) {
                    return I18n.i18n("account.failed.invalid_credentials");
                }
                if (remoteMessage.contains("Invalid token")) {
                    return I18n.i18n("account.failed.invalid_token");
                }
                if (remoteMessage.contains("Invalid username or password")) {
                    return I18n.i18n("account.failed.invalid_password");
                }
                return remoteMessage;
            }
            return exception.getMessage();
        }
        if (exception instanceof AuthlibInjectorDownloadException) {
            return I18n.i18n("account.failed.injector_download_failure");
        }
        if (exception instanceof CharacterDeletedException) {
            return I18n.i18n("account.failed.character_deleted");
        }
        if (exception.getClass() == AuthenticationException.class) {
            return exception.getLocalizedMessage();
        }
        return exception.getClass().getName() + ": " + exception.getLocalizedMessage();
    }

    private static class Selector
    extends BorderPane
    implements CharacterSelector {
        private final AdvancedListBox listBox = new AdvancedListBox();
        private final JFXButton cancel = new JFXButton();
        private final CountDownLatch latch = new CountDownLatch(1);
        private GameProfile selectedProfile = null;

        public Selector() {
            this.setStyle("-fx-padding: 8px;");
            this.cancel.setText(I18n.i18n("button.cancel"));
            StackPane.setAlignment((Node)this.cancel, (Pos)Pos.BOTTOM_RIGHT);
            this.cancel.setOnMouseClicked(e -> this.latch.countDown());
            this.listBox.startCategory(I18n.i18n("account.choose"));
            this.setCenter((Node)this.listBox);
            HBox hbox = new HBox();
            hbox.setAlignment(Pos.CENTER_RIGHT);
            hbox.getChildren().add((Object)this.cancel);
            this.setBottom((Node)hbox);
        }

        @Override
        public GameProfile select(YggdrasilService service, List<GameProfile> profiles) throws NoSelectedCharacterException {
            Platform.runLater(() -> {
                for (GameProfile profile : profiles) {
                    ImageView portraitView = new ImageView();
                    portraitView.setSmooth(false);
                    portraitView.imageProperty().bind(TexturesLoader.fxAvatarBinding(service, profile.getId(), 32));
                    FXUtils.limitSize(portraitView, 32.0, 32.0);
                    IconedItem accountItem = new IconedItem((Node)portraitView, profile.getName());
                    accountItem.setOnMouseClicked(e -> {
                        this.selectedProfile = profile;
                        this.latch.countDown();
                    });
                    this.listBox.add((Node)accountItem);
                }
                Controllers.dialog((Region)this);
            });
            try {
                this.latch.await();
                if (this.selectedProfile == null) {
                    throw new NoSelectedCharacterException();
                }
                GameProfile gameProfile = this.selectedProfile;
                return gameProfile;
            }
            catch (InterruptedException ignore) {
                throw new NoSelectedCharacterException();
            }
            finally {
                FXUtils.runInFX(() -> this.fireEvent(new DialogCloseEvent()));
            }
        }
    }
}

