/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.effects.JFXDepthManager;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.SVG;

public final class AuthlibInjectorServerItem
extends BorderPane {
    private final AuthlibInjectorServer server;
    private final Label lblServerName = new Label();
    private final Label lblServerUrl = new Label();

    public AuthlibInjectorServerItem(AuthlibInjectorServer server, Consumer<AuthlibInjectorServerItem> deleteCallback) {
        this.server = server;
        this.lblServerName.setStyle("-fx-font-size: 15;");
        this.lblServerUrl.setStyle("-fx-font-size: 10;");
        VBox center = new VBox();
        BorderPane.setAlignment((Node)center, (Pos)Pos.CENTER);
        center.getChildren().addAll((Object[])new Node[]{this.lblServerName, this.lblServerUrl});
        this.setCenter((Node)center);
        JFXButton right = new JFXButton();
        right.setOnMouseClicked(e -> deleteCallback.accept(this));
        right.getStyleClass().add((Object)"toggle-icon4");
        BorderPane.setAlignment((Node)right, (Pos)Pos.CENTER);
        right.setGraphic(SVG.close(Theme.blackFillBinding(), 15.0, 15.0));
        this.setRight((Node)right);
        this.setStyle("-fx-background-radius: 2; -fx-background-color: white; -fx-padding: 8;");
        JFXDepthManager.setDepth((Node)this, 1);
        this.lblServerName.textProperty().bind((ObservableValue)Bindings.createStringBinding(server::getName, (Observable[])new Observable[]{server}));
        this.lblServerUrl.setText(server.getUrl());
    }

    public AuthlibInjectorServer getServer() {
        return this.server;
    }
}

