/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.animation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.value.WritableValue;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.AnimationHandler;
import org.jackhuang.hmcl.ui.animation.AnimationProducer;
import org.jetbrains.annotations.Nullable;

public enum ContainerAnimations {
    NONE(c -> {
        c.getPreviousNode().setTranslateX(0.0);
        c.getPreviousNode().setTranslateY(0.0);
        c.getPreviousNode().setScaleX(1.0);
        c.getPreviousNode().setScaleY(1.0);
        c.getPreviousNode().setOpacity(1.0);
        c.getCurrentNode().setTranslateX(0.0);
        c.getCurrentNode().setTranslateY(0.0);
        c.getCurrentNode().setScaleX(1.0);
        c.getCurrentNode().setScaleY(1.0);
        c.getCurrentNode().setOpacity(1.0);
    }, c -> Collections.emptyList()),
    FADE(c -> {
        c.getPreviousNode().setTranslateX(0.0);
        c.getPreviousNode().setTranslateY(0.0);
        c.getPreviousNode().setScaleX(1.0);
        c.getPreviousNode().setScaleY(1.0);
        c.getPreviousNode().setOpacity(1.0);
        c.getCurrentNode().setTranslateX(0.0);
        c.getCurrentNode().setTranslateY(0.0);
        c.getCurrentNode().setScaleX(1.0);
        c.getCurrentNode().setScaleY(1.0);
        c.getCurrentNode().setOpacity(0.0);
    }, c -> Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}))),
    FADE_IN(c -> {
        c.getCurrentNode().setTranslateX(0.0);
        c.getCurrentNode().setTranslateY(0.0);
        c.getCurrentNode().setScaleX(1.0);
        c.getCurrentNode().setScaleY(1.0);
        c.getCurrentNode().setOpacity(0.0);
    }, c -> Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)0, FXUtils.SINE)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)1, FXUtils.SINE)}))),
    FADE_OUT(c -> {
        c.getCurrentNode().setTranslateX(0.0);
        c.getCurrentNode().setTranslateY(0.0);
        c.getCurrentNode().setScaleX(1.0);
        c.getCurrentNode().setScaleY(1.0);
        c.getCurrentNode().setOpacity(1.0);
    }, c -> Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)1, FXUtils.SINE)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().opacityProperty(), (Object)0, FXUtils.SINE)}))),
    ZOOM_IN(c -> {
        c.getPreviousNode().setTranslateX(0.0);
        c.getPreviousNode().setTranslateY(0.0);
        c.getPreviousNode().setScaleX(1.0);
        c.getPreviousNode().setScaleY(1.0);
        c.getPreviousNode().setOpacity(1.0);
        c.getCurrentNode().setTranslateX(0.0);
        c.getCurrentNode().setTranslateY(0.0);
    }, c -> Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getPreviousNode().scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getPreviousNode().scaleXProperty(), (Object)4, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().scaleYProperty(), (Object)4, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}))),
    ZOOM_OUT(c -> {
        c.getPreviousNode().setTranslateX(0.0);
        c.getPreviousNode().setTranslateY(0.0);
        c.getPreviousNode().setScaleX(1.0);
        c.getPreviousNode().setScaleY(1.0);
        c.getPreviousNode().setOpacity(1.0);
        c.getCurrentNode().setTranslateX(0.0);
        c.getCurrentNode().setTranslateY(0.0);
    }, c -> Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getPreviousNode().scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getPreviousNode().scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}))),
    SWIPE_LEFT(c -> {
        c.getPreviousNode().setScaleX(1.0);
        c.getPreviousNode().setScaleY(1.0);
        c.getPreviousNode().setOpacity(0.0);
        c.getPreviousNode().setTranslateX(0.0);
        c.getCurrentNode().setScaleX(1.0);
        c.getCurrentNode().setScaleY(1.0);
        c.getCurrentNode().setOpacity(1.0);
        c.getCurrentNode().setTranslateX(c.getCurrentRoot().getWidth());
    }, c -> Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().translateXProperty(), (Object)c.getCurrentRoot().getWidth(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().translateXProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().translateXProperty(), (Object)(-c.getCurrentRoot().getWidth()), Interpolator.EASE_BOTH)}))),
    SWIPE_RIGHT(c -> {
        c.getPreviousNode().setScaleX(1.0);
        c.getPreviousNode().setScaleY(1.0);
        c.getPreviousNode().setOpacity(0.0);
        c.getPreviousNode().setTranslateX(0.0);
        c.getCurrentNode().setScaleX(1.0);
        c.getCurrentNode().setScaleY(1.0);
        c.getCurrentNode().setOpacity(1.0);
        c.getCurrentNode().setTranslateX(-c.getCurrentRoot().getWidth());
    }, c -> Arrays.asList(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().translateXProperty(), (Object)(-c.getCurrentRoot().getWidth()), Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().translateXProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(c.getDuration(), new KeyValue[]{new KeyValue((WritableValue)c.getCurrentNode().translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)c.getPreviousNode().translateXProperty(), (Object)c.getCurrentRoot().getWidth(), Interpolator.EASE_BOTH)})));

    private final AnimationProducer animationProducer;
    private ContainerAnimations opposite;

    private ContainerAnimations(final Consumer<AnimationHandler> init, final Function<AnimationHandler, List<KeyFrame>> animationProducer) {
        this.animationProducer = new AnimationProducer(){

            @Override
            public void init(AnimationHandler handler) {
                init.accept(handler);
            }

            @Override
            public List<KeyFrame> animate(AnimationHandler handler) {
                return (List)animationProducer.apply(handler);
            }

            @Override
            @Nullable
            public AnimationProducer opposite() {
                return ContainerAnimations.this.opposite != null ? ContainerAnimations.this.opposite.getAnimationProducer() : null;
            }
        };
    }

    public AnimationProducer getAnimationProducer() {
        return this.animationProducer;
    }

    public ContainerAnimations getOpposite() {
        return this.opposite;
    }

    static {
        ContainerAnimations.NONE.opposite = NONE;
        ContainerAnimations.FADE.opposite = FADE;
        ContainerAnimations.SWIPE_LEFT.opposite = SWIPE_RIGHT;
        ContainerAnimations.SWIPE_RIGHT.opposite = SWIPE_LEFT;
        ContainerAnimations.FADE_IN.opposite = FADE_OUT;
        ContainerAnimations.FADE_OUT.opposite = FADE_IN;
        ContainerAnimations.ZOOM_IN.opposite = ZOOM_OUT;
        ContainerAnimations.ZOOM_OUT.opposite = ZOOM_IN;
    }
}

