/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;

public class AdvancedListItemSkin
extends SkinBase<AdvancedListItem> {
    private final PseudoClass SELECTED = PseudoClass.getPseudoClass((String)"selected");

    public AdvancedListItemSkin(AdvancedListItem skinnable) {
        super((Control)skinnable);
        StackPane stackPane = new StackPane();
        stackPane.getStyleClass().add((Object)"container");
        RipplerContainer container = new RipplerContainer((Node)stackPane);
        FXUtils.onChangeAndOperate(skinnable.activeProperty(), active -> skinnable.pseudoClassStateChanged(this.SELECTED, (boolean)active));
        BorderPane root = new BorderPane();
        root.setPickOnBounds(false);
        HBox left = new HBox();
        left.setAlignment(Pos.CENTER);
        left.setMouseTransparent(true);
        StackPane imageViewContainer = new StackPane();
        FXUtils.setLimitWidth((Region)imageViewContainer, 32.0);
        FXUtils.setLimitHeight((Region)imageViewContainer, 32.0);
        ImageView imageView = new ImageView();
        FXUtils.limitSize(imageView, 32.0, 32.0);
        imageView.setPreserveRatio(true);
        imageView.imageProperty().bind(skinnable.imageProperty());
        imageViewContainer.getChildren().setAll((Object[])new Node[]{imageView});
        VBox vbox = new VBox();
        vbox.setAlignment(Pos.CENTER_LEFT);
        vbox.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        Label title = new Label();
        title.textProperty().bind((ObservableValue)skinnable.titleProperty());
        title.setMaxWidth(90.0);
        title.setStyle("-fx-font-size: 15;");
        title.setTextAlignment(TextAlignment.JUSTIFY);
        vbox.getChildren().add((Object)title);
        Label subtitle = new Label();
        subtitle.textProperty().bind((ObservableValue)skinnable.subtitleProperty());
        subtitle.setMaxWidth(90.0);
        subtitle.setStyle("-fx-font-size: 10;");
        subtitle.setTextAlignment(TextAlignment.JUSTIFY);
        vbox.getChildren().add((Object)subtitle);
        FXUtils.onChangeAndOperate(skinnable.subtitleProperty(), subtitleString -> {
            if (subtitleString == null) {
                vbox.getChildren().setAll((Object[])new Node[]{title});
            } else {
                vbox.getChildren().setAll((Object[])new Node[]{title, subtitle});
            }
        });
        left.getChildren().setAll((Object[])new Node[]{imageViewContainer, vbox});
        root.setLeft((Node)left);
        HBox right = new HBox();
        right.setAlignment(Pos.CENTER);
        right.setMouseTransparent(true);
        right.getStyleClass().add((Object)"toggle-icon4");
        FXUtils.setLimitWidth((Region)right, 40.0);
        FXUtils.onChangeAndOperate(skinnable.rightGraphicProperty(), newGraphic -> {
            if (newGraphic == null) {
                right.getChildren().clear();
            } else {
                right.getChildren().setAll((Object[])new Node[]{newGraphic});
            }
        });
        root.setRight((Node)right);
        FXUtils.onChangeAndOperate(skinnable.actionButtonVisibleProperty(), visible -> root.setRight((Node)(visible != false ? right : null)));
        stackPane.setStyle("-fx-padding: 10 16 10 16;");
        stackPane.getStyleClass().add((Object)"transparent");
        stackPane.setPickOnBounds(false);
        stackPane.getChildren().setAll((Object[])new Node[]{root});
        this.getChildren().setAll((Object[])new Node[]{container});
    }
}

