/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import java.util.concurrent.CompletableFuture;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.util.FutureCallback;

public class InputDialogPane
extends StackPane {
    private final CompletableFuture<String> future = new CompletableFuture();
    @FXML
    private JFXButton acceptButton;
    @FXML
    private JFXButton cancelButton;
    @FXML
    private Label title;
    @FXML
    private VBox vbox;
    @FXML
    private Label lblCreationWarning;
    @FXML
    private SpinnerPane acceptPane;

    public InputDialogPane(String text, String initialValue, FutureCallback<String> onResult) {
        FXUtils.loadFXML((Node)this, "/assets/fxml/input-dialog.fxml");
        this.title.setText(text);
        JFXTextField textField = new JFXTextField();
        textField.setText(initialValue);
        this.vbox.getChildren().setAll((Object[])new Node[]{textField});
        this.cancelButton.setOnMouseClicked(e -> this.fireEvent(new DialogCloseEvent()));
        this.acceptButton.setOnMouseClicked(e -> {
            this.acceptPane.showSpinner();
            onResult.call(textField.getText(), () -> {
                this.acceptPane.hideSpinner();
                this.future.complete(textField.getText());
                this.fireEvent(new DialogCloseEvent());
            }, msg -> {
                this.acceptPane.hideSpinner();
                this.lblCreationWarning.setText(msg);
            });
        });
    }

    public CompletableFuture<String> getCompletableFuture() {
        return this.future;
    }
}

