/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXRippler;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;

public class TabHeader
extends Control
implements TabControl {
    private ObservableList<TabControl.Tab> tabs = FXCollections.observableArrayList();
    private final ObjectProperty<SingleSelectionModel<TabControl.Tab>> selectionModel = new SimpleObjectProperty((Object)this, "selectionModel", (Object)new TabControl.TabControlSelectionModel(this));

    public TabHeader(TabControl.Tab ... tabs) {
        this.getStyleClass().setAll((Object[])new String[]{"tab-header"});
        if (tabs != null) {
            this.getTabs().addAll((Object[])tabs);
        }
    }

    @Override
    public ObservableList<TabControl.Tab> getTabs() {
        return this.tabs;
    }

    public SingleSelectionModel<TabControl.Tab> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public ObjectProperty<SingleSelectionModel<TabControl.Tab>> selectionModelProperty() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel<TabControl.Tab> selectionModel) {
        this.selectionModel.set(selectionModel);
    }

    protected Skin<?> createDefaultSkin() {
        return new TabHeaderSkin(this);
    }

    public static class TabHeaderSkin
    extends SkinBase<TabHeader> {
        private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
        private final Color ripplerColor = Color.valueOf((String)"#FFFF8D");
        private final HeaderContainer header = new HeaderContainer();
        private boolean isSelectingTab = false;
        private TabControl.Tab selectedTab;

        protected TabHeaderSkin(TabHeader control) {
            super((Control)control);
            this.getChildren().setAll((Object[])new Node[]{this.header});
            FXUtils.onChangeAndOperate(control.getSelectionModel().selectedItemProperty(), item -> {
                this.isSelectingTab = true;
                this.selectedTab = item;
                Platform.runLater(() -> {
                    this.header.setNeedsLayout2(true);
                    this.header.layout();
                });
            });
            this.selectedTab = (TabControl.Tab)control.getSelectionModel().getSelectedItem();
            if (this.selectedTab == null && control.getSelectionModel().getSelectedIndex() != -1) {
                control.getSelectionModel().select(control.getSelectionModel().getSelectedIndex());
                this.selectedTab = (TabControl.Tab)control.getSelectionModel().getSelectedItem();
            }
            if (this.selectedTab == null) {
                control.getSelectionModel().selectFirst();
            }
            this.selectedTab = (TabControl.Tab)control.getSelectionModel().getSelectedItem();
        }

        protected class HeaderContainer
        extends StackPane {
            private Timeline timeline;
            private StackPane selectedTabLine;
            private StackPane headersRegion;
            private Scale scale = new Scale(1.0, 1.0, 0.0, 0.0);
            private Rotate rotate = new Rotate(0.0, 0.0, 1.0);
            private double selectedTabLineOffset;
            private ObservableList<Node> binding;

            public HeaderContainer() {
                this.getStyleClass().add((Object)"tab-header-area");
                this.setPickOnBounds(false);
                this.headersRegion = new StackPane(){

                    protected double computePrefWidth(double height) {
                        double width = 0.0;
                        for (Node child : this.getChildren()) {
                            if (!(child instanceof TabHeaderContainer) || !child.isVisible()) continue;
                            width += child.prefWidth(height);
                        }
                        return this.snapSize(width) + this.snappedLeftInset() + this.snappedRightInset();
                    }

                    protected double computePrefHeight(double width) {
                        double height = 0.0;
                        for (Node child : this.getChildren()) {
                            if (!(child instanceof TabHeaderContainer) || !child.isVisible()) continue;
                            height = Math.max(height, child.prefHeight(width));
                        }
                        return this.snapSize(height) + this.snappedTopInset() + this.snappedBottomInset();
                    }

                    protected void layoutChildren() {
                        if (TabHeaderSkin.this.isSelectingTab) {
                            HeaderContainer.this.animateSelectionLine();
                            TabHeaderSkin.this.isSelectingTab = false;
                        }
                        double headerHeight = this.snapSize(this.prefHeight(-1.0));
                        double tabStartX = 0.0;
                        for (Node node : this.getChildren()) {
                            if (!(node instanceof TabHeaderContainer)) continue;
                            TabHeaderContainer child = (TabHeaderContainer)node;
                            double w = this.snapSize(child.prefWidth(-1.0));
                            double h = this.snapSize(child.prefHeight(-1.0));
                            child.resize(w, h);
                            child.relocate(tabStartX, headerHeight - h - this.snappedBottomInset());
                            tabStartX += w;
                        }
                        HeaderContainer.this.selectedTabLine.resizeRelocate(0.0, headerHeight - HeaderContainer.this.selectedTabLine.prefHeight(-1.0), this.snapSize(HeaderContainer.this.selectedTabLine.prefWidth(-1.0)), this.snapSize(HeaderContainer.this.selectedTabLine.prefHeight(-1.0)));
                    }
                };
                this.selectedTabLine = new StackPane();
                this.selectedTabLine.setManaged(false);
                this.selectedTabLine.getTransforms().addAll((Object[])new Transform[]{this.scale, this.rotate});
                this.selectedTabLine.setCache(true);
                this.selectedTabLine.getStyleClass().addAll((Object[])new String[]{"tab-selected-line"});
                this.selectedTabLine.setPrefHeight(2.0);
                this.selectedTabLine.setPrefWidth(1.0);
                this.selectedTabLine.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)TabHeaderSkin.this.ripplerColor, CornerRadii.EMPTY, Insets.EMPTY)}));
                this.getChildren().setAll((Object[])new Node[]{this.headersRegion, this.selectedTabLine});
                this.headersRegion.setPickOnBounds(false);
                this.headersRegion.prefHeightProperty().bind((ObservableValue)this.heightProperty());
                this.prefWidthProperty().bind((ObservableValue)this.headersRegion.widthProperty());
                this.binding = MappedObservableList.create(((TabHeader)TabHeaderSkin.this.getSkinnable()).getTabs(), tab -> {
                    TabHeaderContainer container = new TabHeaderContainer((TabControl.Tab)tab);
                    container.setVisible(true);
                    return container;
                });
                Bindings.bindContent((List)this.headersRegion.getChildren(), this.binding);
            }

            public void setNeedsLayout2(boolean value) {
                this.setNeedsLayout(value);
            }

            private void runTimeline(double newTransX, double newWidth) {
                double midScaleX;
                double tempScaleX = 0.0;
                double tempWidth = 0.0;
                double lineWidth = this.selectedTabLine.prefWidth(-1.0);
                if (this.isAnimating()) {
                    this.timeline.stop();
                    tempScaleX = this.scale.getX();
                    if (this.rotate.getAngle() != 0.0) {
                        this.rotate.setAngle(0.0);
                        tempWidth = tempScaleX * lineWidth;
                        this.selectedTabLine.setTranslateX(this.selectedTabLine.getTranslateX() - tempWidth);
                    }
                }
                double oldScaleX = this.scale.getX();
                double oldWidth = lineWidth * oldScaleX;
                double oldTransX = this.selectedTabLine.getTranslateX();
                double newScaleX = newWidth * oldScaleX / oldWidth;
                this.selectedTabLineOffset = newTransX;
                double transDiff = newTransX - oldTransX;
                double d = midScaleX = tempScaleX != 0.0 ? tempScaleX : (Math.abs(transDiff) / 1.3 + oldWidth) * oldScaleX / oldWidth;
                if (transDiff < 0.0) {
                    this.selectedTabLine.setTranslateX(this.selectedTabLine.getTranslateX() + oldWidth);
                    newTransX += newWidth;
                    this.rotate.setAngle(180.0);
                }
                this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)this.selectedTabLine.getTranslateX(), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.12), new KeyValue[]{new KeyValue((WritableValue)this.scale.xProperty(), (Object)midScaleX, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)this.selectedTabLine.getTranslateX(), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.24), new KeyValue[]{new KeyValue((WritableValue)this.scale.xProperty(), (Object)newScaleX, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)newTransX, Interpolator.EASE_BOTH)})});
                this.timeline.setOnFinished(finish -> {
                    if (this.rotate.getAngle() != 0.0) {
                        this.rotate.setAngle(0.0);
                        this.selectedTabLine.setTranslateX(this.selectedTabLine.getTranslateX() - newWidth);
                    }
                });
                this.timeline.play();
            }

            private boolean isAnimating() {
                return this.timeline != null && this.timeline.getStatus() == Animation.Status.RUNNING;
            }

            protected void layoutChildren() {
                super.layoutChildren();
                if (TabHeaderSkin.this.isSelectingTab) {
                    this.animateSelectionLine();
                    TabHeaderSkin.this.isSelectingTab = false;
                }
            }

            private void animateSelectionLine() {
                double offset = 0.0;
                double selectedTabOffset = 0.0;
                double selectedTabWidth = 0.0;
                Side side = Side.TOP;
                for (Node node : this.headersRegion.getChildren()) {
                    if (!(node instanceof TabHeaderContainer)) continue;
                    TabHeaderContainer tabHeader = (TabHeaderContainer)node;
                    double tabHeaderPrefWidth = this.snapSize(tabHeader.prefWidth(-1.0));
                    if (TabHeaderSkin.this.selectedTab != null && TabHeaderSkin.this.selectedTab.equals(tabHeader.tab)) {
                        selectedTabOffset = side != Side.LEFT && side != Side.BOTTOM ? offset : -offset - tabHeaderPrefWidth;
                        selectedTabWidth = tabHeaderPrefWidth;
                        break;
                    }
                    offset += tabHeaderPrefWidth;
                }
                this.runTimeline(selectedTabOffset, selectedTabWidth);
            }
        }

        protected class TabHeaderContainer
        extends StackPane {
            private final TabControl.Tab tab;
            private final Label tabText;
            private final BorderPane inner;
            private final JFXRippler rippler;

            public TabHeaderContainer(TabControl.Tab tab) {
                this.tab = tab;
                this.tabText = new Label();
                this.tabText.textProperty().bind((ObservableValue)tab.textProperty());
                this.tabText.getStyleClass().add((Object)"tab-label");
                this.inner = new BorderPane();
                this.inner.setCenter((Node)this.tabText);
                this.inner.getStyleClass().add((Object)"tab-container");
                this.rippler = new JFXRippler((Node)this.inner, JFXRippler.RipplerPos.FRONT);
                this.rippler.setRipplerFill((Paint)TabHeaderSkin.this.ripplerColor);
                this.getChildren().setAll((Object[])new Node[]{this.rippler});
                FXUtils.onChangeAndOperate(tab.selectedProperty(), selected -> this.inner.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, selected.booleanValue()));
                this.setOnMouseClicked(event -> {
                    if (event.getButton() == MouseButton.PRIMARY) {
                        this.setOpacity(1.0);
                        ((TabHeader)TabHeaderSkin.this.getSkinnable()).getSelectionModel().select((Object)tab);
                    }
                });
            }
        }
    }
}

