/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.decorator;

import com.jfoenix.controls.JFXDialog;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDnD;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.EnumBackgroundImage;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.account.AddAuthlibInjectorServerPane;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.construct.DialogAware;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.construct.StackContainerPane;
import org.jackhuang.hmcl.ui.decorator.Decorator;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorWizardDisplayer;
import org.jackhuang.hmcl.ui.wizard.Refreshable;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.Logging;

public class DecoratorController {
    private static final String PROPERTY_DIALOG_CLOSE_HANDLER = DecoratorController.class.getName() + ".dialog.closeListener";
    private final Decorator decorator;
    private final ImageView welcomeView;
    private final Navigator navigator;
    private JFXDialog dialog;
    private StackContainerPane dialogPane;
    private Image defaultBackground = FXUtils.newImage("/assets/img/background.jpg");

    public DecoratorController(Stage stage, Node mainPage) {
        this.decorator = new Decorator(stage);
        this.decorator.setOnCloseButtonAction(Launcher::stopApplication);
        this.navigator = new Navigator();
        this.navigator.setOnNavigated((EventHandler<Navigator.NavigationEvent>)((EventHandler)this::onNavigated));
        this.navigator.init(mainPage);
        this.decorator.getContent().setAll((Object[])new Node[]{this.navigator});
        this.decorator.onCloseNavButtonActionProperty().set(e -> this.close());
        this.decorator.onBackNavButtonActionProperty().set(e -> this.back());
        this.decorator.onRefreshNavButtonActionProperty().set(e -> this.refresh());
        this.welcomeView = new ImageView();
        this.welcomeView.setImage(FXUtils.newImage("/assets/img/welcome.png"));
        this.welcomeView.setCursor(Cursor.HAND);
        FXUtils.limitSize(this.welcomeView, 796.0, 517.0);
        this.welcomeView.setOnMouseClicked(e -> {
            Timeline nowAnimation = new Timeline();
            nowAnimation.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.welcomeView.opacityProperty(), (Object)1.0, Interpolator.EASE_BOTH)}), new KeyFrame(new Duration(300.0), new KeyValue[]{new KeyValue((WritableValue)this.welcomeView.opacityProperty(), (Object)0.0, Interpolator.EASE_BOTH)}), new KeyFrame(new Duration(300.0), e2 -> this.decorator.getContainer().remove((Object)this.welcomeView), new KeyValue[0])});
            nowAnimation.play();
        });
        if (this.switchedToNewUI() && ConfigHolder.config().getLocalization().getLocale() == Locale.CHINA) {
            this.decorator.getContainer().setAll((Object[])new Node[]{this.welcomeView});
        }
        this.setupBackground();
        this.setupAuthlibInjectorDnD();
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    private boolean switchedToNewUI() {
        if (ConfigHolder.config().getUiVersion() < 0) {
            ConfigHolder.config().setUiVersion(0);
            return true;
        }
        return false;
    }

    private void setupBackground() {
        this.decorator.contentBackgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            Image image = null;
            if (ConfigHolder.config().getBackgroundImageType() == EnumBackgroundImage.CUSTOM && ConfigHolder.config().getBackgroundImage() != null) {
                image = this.tryLoadImage(Paths.get(ConfigHolder.config().getBackgroundImage(), new String[0])).orElse(null);
            }
            if (image == null) {
                image = this.loadDefaultBackgroundImage();
            }
            return new Background(new BackgroundImage[]{new BackgroundImage(image, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.DEFAULT, new BackgroundSize(800.0, 480.0, false, false, true, true))});
        }, (Observable[])new Observable[]{ConfigHolder.config().backgroundImageTypeProperty(), ConfigHolder.config().backgroundImageProperty()}));
    }

    private Image loadDefaultBackgroundImage() {
        Optional<Image> image = this.randomImageIn(Paths.get("bg", new String[0]));
        if (!image.isPresent()) {
            image = this.tryLoadImage(Paths.get("background.png", new String[0]));
        }
        if (!image.isPresent()) {
            image = this.tryLoadImage(Paths.get("background.jpg", new String[0]));
        }
        return image.orElse(this.defaultBackground);
    }

    private Optional<Image> randomImageIn(Path imageDir) {
        List candidates;
        if (!Files.isDirectory(imageDir, new LinkOption[0])) {
            return Optional.empty();
        }
        try (Stream<Path> stream = Files.list(imageDir);){
            candidates = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(it -> {
                String filename = it.getFileName().toString();
                return filename.endsWith(".png") || filename.endsWith(".jpg");
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Failed to list files in ./bg", e);
            return Optional.empty();
        }
        Random rnd = new Random();
        while (candidates.size() > 0) {
            int selected = rnd.nextInt(candidates.size());
            Optional<Image> loaded = this.tryLoadImage((Path)candidates.get(selected));
            if (loaded.isPresent()) {
                return loaded;
            }
            candidates.remove(selected);
        }
        return Optional.empty();
    }

    private Optional<Image> tryLoadImage(Path path) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try {
                return Optional.of(new Image(path.toAbsolutePath().toUri().toString()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public Navigator getNavigator() {
        return this.navigator;
    }

    private void close() {
        DecoratorPage page;
        if (this.navigator.getCurrentPage() instanceof DecoratorPage && (page = (DecoratorPage)this.navigator.getCurrentPage()).isPageCloseable()) {
            page.closePage();
            return;
        }
        this.navigator.clear();
    }

    private void back() {
        if (this.navigator.getCurrentPage() instanceof DecoratorPage) {
            DecoratorPage page = (DecoratorPage)this.navigator.getCurrentPage();
            if (page.back()) {
                this.navigator.close();
            }
        } else {
            this.navigator.close();
        }
    }

    private void refresh() {
        Refreshable refreshable;
        if (this.navigator.getCurrentPage() instanceof Refreshable && (refreshable = (Refreshable)this.navigator.getCurrentPage()).refreshableProperty().get()) {
            refreshable.refresh();
        }
    }

    private void onNavigating(Navigator.NavigationEvent event) {
        if (event.getSource() != this.navigator) {
            return;
        }
        Node from = event.getNode();
        if (from instanceof DecoratorPage) {
            ((DecoratorPage)from).back();
        }
    }

    private void onNavigated(Navigator.NavigationEvent event) {
        if (event.getSource() != this.navigator) {
            return;
        }
        Node to = event.getNode();
        if (to instanceof Refreshable) {
            this.decorator.canRefreshProperty().bind((ObservableValue)((Refreshable)to).refreshableProperty());
        } else {
            this.decorator.canRefreshProperty().unbind();
            this.decorator.canRefreshProperty().set(false);
        }
        this.decorator.canCloseProperty().set(this.navigator.size() > 2);
        if (to instanceof DecoratorPage) {
            this.decorator.showCloseAsHomeProperty().set(!((DecoratorPage)to).isPageCloseable());
        } else {
            this.decorator.showCloseAsHomeProperty().set(true);
        }
        if (to instanceof DecoratorPage) {
            this.decorator.stateProperty().bind(((DecoratorPage)to).stateProperty());
        } else {
            this.decorator.stateProperty().unbind();
            this.decorator.stateProperty().set((Object)new DecoratorPage.State("", null, this.navigator.canGoBack(), false, true));
        }
        if (to instanceof Region) {
            Region region = (Region)to;
            StackPane parent = (StackPane)region.getParent();
            region.prefWidthProperty().bind((ObservableValue)parent.widthProperty());
            region.prefHeightProperty().bind((ObservableValue)parent.heightProperty());
        }
    }

    public void showDialog(Node node) {
        FXUtils.checkFxUserThread();
        if (this.dialog == null) {
            if (this.decorator.getDrawerWrapper() == null) {
                Platform.runLater(() -> this.showDialog(node));
                return;
            }
            this.dialog = new JFXDialog();
            this.dialogPane = new StackContainerPane();
            this.dialog.setContent((Region)this.dialogPane);
            this.decorator.capableDraggingWindow((Node)this.dialog);
            this.decorator.forbidDraggingWindow((Node)this.dialogPane);
            this.dialog.setDialogContainer(this.decorator.getDrawerWrapper());
            this.dialog.setOverlayClose(false);
            this.dialog.show();
        }
        this.dialogPane.push(node);
        EventHandler handler = event -> this.closeDialog(node);
        node.getProperties().put((Object)PROPERTY_DIALOG_CLOSE_HANDLER, (Object)handler);
        node.addEventHandler(DialogCloseEvent.CLOSE, handler);
        if (node instanceof DialogAware) {
            final DialogAware dialogAware = (DialogAware)node;
            if (this.dialog.isVisible()) {
                dialogAware.onDialogShown();
            } else {
                this.dialog.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        if (newValue.booleanValue()) {
                            dialogAware.onDialogShown();
                            observable.removeListener((ChangeListener)this);
                        }
                    }
                });
            }
        }
    }

    private void closeDialog(Node node) {
        FXUtils.checkFxUserThread();
        Optional.ofNullable(node.getProperties().get((Object)PROPERTY_DIALOG_CLOSE_HANDLER)).ifPresent(handler -> node.removeEventHandler(DialogCloseEvent.CLOSE, (EventHandler)handler));
        if (this.dialog != null) {
            this.dialogPane.pop(node);
            if (this.dialogPane.getChildren().isEmpty()) {
                this.dialog.close();
                this.dialog = null;
                this.dialogPane = null;
            }
        }
    }

    public void startWizard(WizardProvider wizardProvider) {
        this.startWizard(wizardProvider, null);
    }

    public void startWizard(WizardProvider wizardProvider, String category) {
        FXUtils.checkFxUserThread();
        this.getNavigator().navigate((Node)new DecoratorWizardDisplayer(wizardProvider, category), ContainerAnimations.FADE.getAnimationProducer());
    }

    private void setupAuthlibInjectorDnD() {
        this.decorator.addEventFilter(DragEvent.DRAG_OVER, AuthlibInjectorDnD.dragOverHandler());
        this.decorator.addEventFilter(DragEvent.DRAG_DROPPED, AuthlibInjectorDnD.dragDroppedHandler(url -> Controllers.dialog((Region)new AddAuthlibInjectorServerPane((String)url))));
    }
}

