/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.decorator;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.control.SingleSelectionModel;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.decorator.DecoratorTransitionPage;

public abstract class DecoratorTabPage
extends DecoratorTransitionPage
implements TabControl {
    private ObservableList<TabControl.Tab> tabs = FXCollections.observableArrayList();
    private final ObjectProperty<SingleSelectionModel<TabControl.Tab>> selectionModel = new SimpleObjectProperty((Object)this, "selectionModel", (Object)new TabControl.TabControlSelectionModel(this));

    public DecoratorTabPage() {
        this.getSelectionModel().selectedItemProperty().addListener((a, b, newValue) -> {
            if (newValue.getNode() == null && newValue.getNodeSupplier() != null) {
                newValue.setNode(newValue.getNodeSupplier().get());
            }
            if (newValue.getNode() != null) {
                this.onNavigating(this.getCurrentPage());
                if (this.getCurrentPage() != null) {
                    this.getCurrentPage().fireEvent((Event)new Navigator.NavigationEvent(null, this.getCurrentPage(), Navigator.NavigationEvent.NAVIGATING));
                }
                this.navigate(newValue.getNode(), ContainerAnimations.FADE.getAnimationProducer());
                this.onNavigated(this.getCurrentPage());
                if (this.getCurrentPage() != null) {
                    this.getCurrentPage().fireEvent((Event)new Navigator.NavigationEvent(null, this.getCurrentPage(), Navigator.NavigationEvent.NAVIGATED));
                }
            }
        });
    }

    public DecoratorTabPage(TabControl.Tab ... tabs) {
        this();
        if (tabs != null) {
            this.getTabs().addAll((Object[])tabs);
        }
    }

    @Override
    public ObservableList<TabControl.Tab> getTabs() {
        return this.tabs;
    }

    public SingleSelectionModel<TabControl.Tab> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public ObjectProperty<SingleSelectionModel<TabControl.Tab>> selectionModelProperty() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel<TabControl.Tab> selectionModel) {
        this.selectionModel.set(selectionModel);
    }
}

