/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.decorator;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.ui.animation.AnimationProducer;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.wizard.Refreshable;

public abstract class DecoratorTransitionPage
extends Control
implements DecoratorPage {
    protected final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(""));
    private final DoubleProperty leftPaneWidth = new SimpleDoubleProperty();
    private final BooleanProperty titleBarTransparent = new SimpleBooleanProperty(false);
    private final BooleanProperty backable = new SimpleBooleanProperty(false);
    private final BooleanProperty refreshable = new SimpleBooleanProperty(false);
    private Node currentPage;
    protected final TransitionPane transitionPane = new TransitionPane();

    protected void navigate(Node page, AnimationProducer animation) {
        this.currentPage = page;
        this.transitionPane.setContent(this.currentPage, animation);
    }

    protected void onNavigating(Node from) {
        if (from instanceof DecoratorPage) {
            ((DecoratorPage)from).back();
        }
    }

    protected void onNavigated(Node to) {
        if (to instanceof Refreshable) {
            this.refreshableProperty().bind((ObservableValue)((Refreshable)to).refreshableProperty());
        } else {
            this.refreshableProperty().unbind();
            this.refreshableProperty().set(false);
        }
        if (to instanceof DecoratorPage) {
            this.state.bind((ObservableValue)Bindings.createObjectBinding(() -> {
                DecoratorPage.State state = (DecoratorPage.State)((DecoratorPage)to).stateProperty().get();
                return new DecoratorPage.State(state.getTitle(), state.getTitleNode(), this.backable.get(), state.isRefreshable(), true, this.titleBarTransparent.get(), this.leftPaneWidth.get());
            }, (Observable[])new Observable[]{((DecoratorPage)to).stateProperty()}));
        } else {
            this.state.unbind();
            this.state.set((Object)new DecoratorPage.State("", null, this.backable.get(), false, true, this.titleBarTransparent.get(), this.leftPaneWidth.get()));
        }
        if (to instanceof Region) {
            Region region = (Region)to;
            StackPane parent = (StackPane)region.getParent();
            region.prefWidthProperty().bind((ObservableValue)parent.widthProperty());
            region.prefHeightProperty().bind((ObservableValue)parent.heightProperty());
        }
    }

    protected abstract Skin<?> createDefaultSkin();

    protected Node getCurrentPage() {
        return this.currentPage;
    }

    public boolean isBackable() {
        return this.backable.get();
    }

    public BooleanProperty backableProperty() {
        return this.backable;
    }

    public void setBackable(boolean backable) {
        this.backable.set(backable);
    }

    public boolean isRefreshable() {
        return this.refreshable.get();
    }

    @Override
    public BooleanProperty refreshableProperty() {
        return this.refreshable;
    }

    public void setRefreshable(boolean refreshable) {
        this.refreshable.set(refreshable);
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    public double getLeftPaneWidth() {
        return this.leftPaneWidth.get();
    }

    public DoubleProperty leftPaneWidthProperty() {
        return this.leftPaneWidth;
    }

    public void setLeftPaneWidth(double leftPaneWidth) {
        this.leftPaneWidth.set(leftPaneWidth);
    }

    public boolean isTitleBarTransparent() {
        return this.titleBarTransparent.get();
    }

    public BooleanProperty titleBarTransparentProperty() {
        return this.titleBarTransparent;
    }

    public void setTitleBarTransparent(boolean titleBarTransparent) {
        this.titleBarTransparent.set(titleBarTransparent);
    }
}

