/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.ui.InstallerItem;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.download.InstallerWizardDownloadProvider;
import org.jackhuang.hmcl.ui.download.VersionsPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public class InstallersPage
extends Control
implements WizardPage {
    protected final WizardController controller;
    protected InstallerItem.InstallerItemGroup group = new InstallerItem.InstallerItemGroup();
    protected JFXTextField txtName = new JFXTextField();
    protected BooleanProperty installable = new SimpleBooleanProperty();

    public InstallersPage(WizardController controller, GameRepository repository, String gameVersion, InstallerWizardDownloadProvider downloadProvider) {
        this.controller = controller;
        Validator hasVersion = new Validator(s -> !repository.hasVersion((String)s) && StringUtils.isNotBlank(s));
        hasVersion.setMessage(I18n.i18n("install.new_game.already_exists"));
        Validator nameValidator = new Validator(OperatingSystem::isNameValid);
        nameValidator.setMessage(I18n.i18n("install.new_game.malformed"));
        this.txtName.getValidators().addAll((Object[])new ValidatorBase[]{hasVersion, nameValidator});
        this.installable.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.txtName.validate(), (Observable[])new Observable[]{this.txtName.textProperty()}));
        this.txtName.setText(gameVersion);
        this.group.game.installable.setValue(Boolean.valueOf(false));
        for (InstallerItem library : this.group.getLibraries()) {
            String libraryId = library.getLibraryId();
            if (libraryId.equals("game")) continue;
            library.action.set(e -> {
                if (library.incompatibleLibraryName.get() == null) {
                    controller.onNext((Node)new VersionsPage(controller, I18n.i18n("install.installer.choose", I18n.i18n("install.installer." + libraryId)), gameVersion, downloadProvider, libraryId, () -> controller.onPrev(false)));
                }
            });
            library.removeAction.set(e -> {
                controller.getSettings().remove(libraryId);
                this.reload();
            });
        }
    }

    @Override
    public String getTitle() {
        return I18n.i18n("install.new_game");
    }

    private String getVersion(String id) {
        return ((RemoteVersion)this.controller.getSettings().get(id)).getSelfVersion();
    }

    protected void reload() {
        for (InstallerItem library : this.group.getLibraries()) {
            String libraryId = library.getLibraryId();
            if (this.controller.getSettings().containsKey(libraryId)) {
                library.libraryVersion.set((Object)this.getVersion(libraryId));
                library.removable.set(true);
                continue;
            }
            library.libraryVersion.set(null);
            library.removable.set(false);
        }
    }

    @Override
    public void onNavigate(Map<String, Object> settings) {
        this.reload();
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
    }

    @FXML
    protected void onInstall() {
        this.controller.getSettings().put("name", this.txtName.getText());
        this.controller.onFinish();
    }

    protected Skin<?> createDefaultSkin() {
        return new InstallersPageSkin(this);
    }

    protected static class InstallersPageSkin
    extends SkinBase<InstallersPage> {
        protected InstallersPageSkin(InstallersPage control) {
            super((Control)control);
            BorderPane root = new BorderPane();
            root.setPadding(new Insets(16.0));
            VBox list = new VBox(8.0);
            root.setCenter((Node)list);
            HBox versionNamePane = new HBox(8.0);
            versionNamePane.setAlignment(Pos.CENTER_LEFT);
            versionNamePane.getStyleClass().add((Object)"card");
            versionNamePane.setStyle("-fx-padding: 20 8 20 16");
            versionNamePane.getChildren().add((Object)new Label(I18n.i18n("archive.name")));
            control.txtName.setMaxWidth(300.0);
            versionNamePane.getChildren().add((Object)control.txtName);
            list.getChildren().add((Object)versionNamePane);
            list.getChildren().addAll((Object[])control.group.getLibraries());
            JFXButton installButton = new JFXButton(I18n.i18n("button.install"));
            installButton.disableProperty().bind((ObservableValue)control.installable.not());
            installButton.getStyleClass().add((Object)"jfx-button-raised");
            installButton.setButtonType(JFXButton.ButtonType.RAISED);
            installButton.setPrefWidth(100.0);
            installButton.setPrefHeight(40.0);
            installButton.setOnMouseClicked(e -> control.onInstall());
            BorderPane.setAlignment((Node)installButton, (Pos)Pos.CENTER_RIGHT);
            root.setBottom((Node)installButton);
            this.getChildren().setAll((Object[])new Node[]{root});
        }
    }
}

