/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WebStage;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.CompressingUtils;

public final class LocalModpackPage
extends StackPane
implements WizardPage {
    private final WizardController controller;
    private Modpack manifest = null;
    @FXML
    private Region borderPane;
    @FXML
    private Label lblName;
    @FXML
    private Label lblVersion;
    @FXML
    private Label lblAuthor;
    @FXML
    private Label lblModpackLocation;
    @FXML
    private JFXTextField txtModpackName;
    @FXML
    private JFXButton btnInstall;
    @FXML
    private SpinnerPane spinnerPane;
    public static final String MODPACK_FILE = "MODPACK_FILE";
    public static final String MODPACK_NAME = "MODPACK_NAME";
    public static final String MODPACK_MANIFEST = "MODPACK_MANIFEST";

    public LocalModpackPage(WizardController controller) {
        File selectedFile;
        this.controller = controller;
        FXUtils.loadFXML((Node)this, "/assets/fxml/download/modpack.fxml");
        Profile profile = (Profile)controller.getSettings().get("PROFILE");
        Optional<String> name = Lang.tryCast(controller.getSettings().get(MODPACK_NAME), String.class);
        if (name.isPresent()) {
            this.txtModpackName.setText(name.get());
            this.txtModpackName.setDisable(true);
        } else {
            this.txtModpackName.getValidators().addAll((Object[])new ValidatorBase[]{new Validator(I18n.i18n("install.new_game.already_exists"), str -> !profile.getRepository().hasVersion((String)str) && StringUtils.isNotBlank(str)), new Validator(I18n.i18n("version.forbidden_name"), str -> !profile.getRepository().forbidsVersion((String)str))});
        }
        this.btnInstall.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.txtModpackName.validate(), (Observable[])new Observable[]{this.txtModpackName.textProperty()}));
        Optional<File> filePath = Lang.tryCast(controller.getSettings().get(MODPACK_FILE), File.class);
        if (filePath.isPresent()) {
            selectedFile = filePath.get();
        } else {
            FileChooser chooser = new FileChooser();
            chooser.setTitle(I18n.i18n("modpack.choose"));
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("modpack"), new String[]{"*.zip"}));
            selectedFile = chooser.showOpenDialog((Window)Controllers.getStage());
            if (selectedFile == null) {
                controller.onEnd();
                return;
            }
            controller.getSettings().put(MODPACK_FILE, selectedFile);
        }
        this.spinnerPane.showSpinner();
        Task.supplyAsync(() -> CompressingUtils.findSuitableEncoding(selectedFile.toPath())).thenApplyAsync(encoding -> {
            this.manifest = ModpackHelper.readModpackManifest(selectedFile.toPath(), encoding);
            return this.manifest;
        }).whenComplete(Schedulers.javafx(), manifest -> {
            this.spinnerPane.hideSpinner();
            controller.getSettings().put(MODPACK_MANIFEST, manifest);
            this.lblName.setText(manifest.getName());
            this.lblVersion.setText(manifest.getVersion());
            this.lblAuthor.setText(manifest.getAuthor());
            this.lblModpackLocation.setText(selectedFile.getAbsolutePath());
            if (!name.isPresent()) {
                this.txtModpackName.setText(manifest.getName());
            }
        }, e -> {
            Controllers.dialog(I18n.i18n("modpack.task.install.error"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            Platform.runLater(controller::onEnd);
        }).start();
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        settings.remove(MODPACK_FILE);
    }

    @FXML
    private void onInstall() {
        if (!this.txtModpackName.validate()) {
            return;
        }
        this.controller.getSettings().put(MODPACK_NAME, this.txtModpackName.getText());
        this.controller.onFinish();
    }

    @FXML
    private void onDescribe() {
        if (this.manifest != null) {
            WebStage stage = new WebStage();
            stage.getWebView().getEngine().loadContent(this.manifest.getDescription());
            stage.setTitle(I18n.i18n("modpack.description"));
            stage.showAndWait();
        }
    }

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.task.install");
    }
}

