/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXSpinner;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.fabric.FabricRemoteVersion;
import org.jackhuang.hmcl.download.forge.ForgeRemoteVersion;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRemoteVersion;
import org.jackhuang.hmcl.download.optifine.OptiFineRemoteVersion;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.FloatListCell;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.download.InstallerWizardDownloadProvider;
import org.jackhuang.hmcl.ui.wizard.Refreshable;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class VersionsPage
extends BorderPane
implements WizardPage,
Refreshable {
    private final String gameVersion;
    private final String libraryId;
    private final String title;
    private final WizardController controller;
    @FXML
    private JFXListView<RemoteVersion> list;
    @FXML
    private JFXSpinner spinner;
    @FXML
    private StackPane failedPane;
    @FXML
    private StackPane emptyPane;
    @FXML
    private TransitionPane root;
    @FXML
    private JFXCheckBox chkRelease;
    @FXML
    private JFXCheckBox chkSnapshot;
    @FXML
    private JFXCheckBox chkOld;
    @FXML
    private HBox checkPane;
    @FXML
    private VBox centrePane;
    @FXML
    private JFXComboBox<String> downloadSourceComboBox;
    private VersionList<?> versionList;
    private TaskExecutor executor;

    public VersionsPage(WizardController controller, String title, String gameVersion, InstallerWizardDownloadProvider downloadProvider, String libraryId, Runnable callback) {
        this.title = title;
        this.gameVersion = gameVersion;
        this.libraryId = libraryId;
        this.controller = controller;
        FXUtils.loadFXML((Node)this, "/assets/fxml/download/versions.fxml");
        this.downloadSourceComboBox.getItems().setAll(DownloadProviders.providersById.keySet());
        this.downloadSourceComboBox.setConverter(FXUtils.stringConverter(key -> I18n.i18n("download.provider." + key)));
        this.downloadSourceComboBox.getSelectionModel().selectedItemProperty().addListener((a, b, newValue) -> {
            controller.getSettings().put("downloadProvider", newValue);
            downloadProvider.setDownloadProvider(DownloadProviders.getDownloadProviderByPrimaryId(newValue));
            this.versionList = downloadProvider.getVersionListById(libraryId);
            if (this.versionList.hasType()) {
                this.centrePane.getChildren().setAll((Object[])new Node[]{this.checkPane, this.list});
            } else {
                this.centrePane.getChildren().setAll((Object[])new Node[]{this.list});
            }
            this.refresh();
        });
        this.downloadSourceComboBox.getSelectionModel().select((Object)((String)controller.getSettings().getOrDefault("downloadProvider", DownloadProviders.getPrimaryDownloadProviderId())));
        InvalidationListener listener = o -> this.list.getItems().setAll(this.loadVersions());
        this.chkRelease.selectedProperty().addListener(listener);
        this.chkSnapshot.selectedProperty().addListener(listener);
        this.chkOld.selectedProperty().addListener(listener);
        this.list.setCellFactory(listView -> new FloatListCell<RemoteVersion>(){
            ImageView imageView = new ImageView();
            TwoLineListItem content = new TwoLineListItem();
            {
                HBox container = new HBox(12.0);
                container.setPadding(new Insets(0.0, 0.0, 0.0, 6.0));
                container.setAlignment(Pos.CENTER_LEFT);
                this.pane.getChildren().add((Object)container);
                container.getChildren().setAll((Object[])new Node[]{this.imageView, this.content});
            }

            @Override
            protected void updateControl(RemoteVersion remoteVersion, boolean empty) {
                if (empty) {
                    return;
                }
                this.content.setTitle(remoteVersion.getSelfVersion());
                this.content.setSubtitle(remoteVersion.getGameVersion());
                if (remoteVersion instanceof GameRemoteVersion) {
                    switch (remoteVersion.getVersionType()) {
                        case RELEASE: {
                            this.content.setSubtitle(I18n.i18n("version.game.release"));
                            this.imageView.setImage(new Image("/assets/img/grass.png", 32.0, 32.0, false, true));
                            break;
                        }
                        case SNAPSHOT: {
                            this.content.setSubtitle(I18n.i18n("version.game.snapshot"));
                            this.imageView.setImage(new Image("/assets/img/command.png", 32.0, 32.0, false, true));
                            break;
                        }
                        default: {
                            this.content.setSubtitle(I18n.i18n("version.game.old"));
                            this.imageView.setImage(new Image("/assets/img/craft_table.png", 32.0, 32.0, false, true));
                            break;
                        }
                    }
                } else if (remoteVersion instanceof LiteLoaderRemoteVersion) {
                    this.imageView.setImage(new Image("/assets/img/chicken.png", 32.0, 32.0, false, true));
                    this.content.setSubtitle(remoteVersion.getGameVersion());
                } else if (remoteVersion instanceof OptiFineRemoteVersion) {
                    this.imageView.setImage(new Image("/assets/img/command.png", 32.0, 32.0, false, true));
                    this.content.setSubtitle(remoteVersion.getGameVersion());
                } else if (remoteVersion instanceof ForgeRemoteVersion) {
                    this.imageView.setImage(new Image("/assets/img/forge.png", 32.0, 32.0, false, true));
                    this.content.setSubtitle(remoteVersion.getGameVersion());
                } else if (remoteVersion instanceof FabricRemoteVersion) {
                    this.imageView.setImage(new Image("/assets/img/fabric.png", 32.0, 32.0, false, true));
                    this.content.setSubtitle(remoteVersion.getGameVersion());
                }
            }
        });
        this.list.setOnMouseClicked(e -> {
            if (this.list.getSelectionModel().getSelectedIndex() < 0) {
                return;
            }
            controller.getSettings().put(libraryId, this.list.getSelectionModel().getSelectedItem());
            callback.run();
        });
        this.refresh();
    }

    private List<RemoteVersion> loadVersions() {
        return this.versionList.getVersions(this.gameVersion).stream().filter(it -> {
            switch (it.getVersionType()) {
                case RELEASE: {
                    return this.chkRelease.isSelected();
                }
                case SNAPSHOT: {
                    return this.chkSnapshot.isSelected();
                }
                case OLD: {
                    return this.chkOld.isSelected();
                }
            }
            return true;
        }).sorted().collect(Collectors.toList());
    }

    @Override
    public void refresh() {
        VersionList<?> currentVersionList = this.versionList;
        this.root.setContent((Node)this.spinner, ContainerAnimations.FADE.getAnimationProducer());
        this.executor = currentVersionList.refreshAsync(this.gameVersion).whenComplete(exception -> {
            if (exception == null) {
                List<RemoteVersion> items = this.loadVersions();
                Platform.runLater(() -> {
                    if (this.versionList != currentVersionList) {
                        return;
                    }
                    if (currentVersionList.getVersions(this.gameVersion).isEmpty()) {
                        this.root.setContent((Node)this.emptyPane, ContainerAnimations.FADE.getAnimationProducer());
                    } else {
                        if (items.isEmpty()) {
                            this.chkRelease.setSelected(true);
                            this.chkSnapshot.setSelected(true);
                            this.chkOld.setSelected(true);
                        } else {
                            this.list.getItems().setAll((Collection)items);
                        }
                        this.root.setContent((Node)this.centrePane, ContainerAnimations.FADE.getAnimationProducer());
                    }
                });
            } else {
                Logging.LOG.log(Level.WARNING, "Failed to fetch versions list", exception);
                Platform.runLater(() -> {
                    if (this.versionList != currentVersionList) {
                        return;
                    }
                    this.root.setContent((Node)this.failedPane, ContainerAnimations.FADE.getAnimationProducer());
                });
            }
        }).executor().start();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        settings.remove(this.libraryId);
        if (this.executor != null) {
            this.executor.cancel();
        }
    }

    @FXML
    private void onRefresh() {
        this.refresh();
    }

    @FXML
    private void onBack() {
        this.controller.onPrev(true);
    }

    @FXML
    private void onSponsor() {
        FXUtils.openLink("https://hmcl.huangyuhui.net/api/redirect/bmclapi_sponsor");
    }
}

