/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.export;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.mod.ModAdviser;
import org.jackhuang.hmcl.mod.ModpackExportInfo;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackExportTask;
import org.jackhuang.hmcl.mod.multimc.MultiMCInstanceConfiguration;
import org.jackhuang.hmcl.mod.multimc.MultiMCModpackExportTask;
import org.jackhuang.hmcl.mod.server.ServerModpackExportTask;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.export.ModpackFileSelectionPage;
import org.jackhuang.hmcl.ui.export.ModpackInfoPage;
import org.jackhuang.hmcl.ui.export.ModpackTypeSelectionPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.Lang;

public final class ExportWizardProvider
implements WizardProvider {
    private final Profile profile;
    private final String version;

    public ExportWizardProvider(Profile profile, String version) {
        this.profile = profile;
        this.version = version;
    }

    @Override
    public void start(Map<String, Object> settings) {
    }

    @Override
    public Object finish(Map<String, Object> settings) {
        String modpackType;
        List whitelist = (List)settings.get("modpack.accepted");
        ModpackExportInfo exportInfo = (ModpackExportInfo)settings.get("modpack.info");
        exportInfo.setWhitelist(whitelist);
        switch (modpackType = (String)settings.get("modpack.type")) {
            case "mcbbs": {
                return this.exportAsMcbbs(exportInfo);
            }
            case "multimc": {
                return this.exportAsMultiMC(exportInfo);
            }
            case "server": {
                return this.exportAsServer(exportInfo);
            }
        }
        throw new IllegalStateException("Unrecognized modpack type " + modpackType);
    }

    private Task<?> exportAsMcbbs(final ModpackExportInfo exportInfo) {
        List<File> launcherJar = Launcher.getCurrentJarFiles();
        return new Task<Void>(){
            Task<?> dependency = null;

            @Override
            public void execute() {
                this.dependency = new McbbsModpackExportTask(ExportWizardProvider.this.profile.getRepository(), ExportWizardProvider.this.version, exportInfo);
            }

            @Override
            public Collection<Task<?>> getDependencies() {
                return Collections.singleton(this.dependency);
            }
        };
    }

    private Task<?> exportAsMultiMC(final ModpackExportInfo exportInfo) {
        return new Task<Void>(){
            Task<?> dependency;

            @Override
            public void execute() {
                VersionSetting vs = ExportWizardProvider.this.profile.getVersionSetting(ExportWizardProvider.this.version);
                this.dependency = new MultiMCModpackExportTask(ExportWizardProvider.this.profile.getRepository(), ExportWizardProvider.this.version, exportInfo.getWhitelist(), new MultiMCInstanceConfiguration("OneSix", exportInfo.getName() + "-" + exportInfo.getVersion(), null, Lang.toIntOrNull(vs.getPermSize()), vs.getWrapper(), vs.getPreLaunchCommand(), null, exportInfo.getDescription(), null, exportInfo.getJavaArguments(), vs.isFullscreen(), vs.getWidth(), vs.getHeight(), vs.getMaxMemory(), exportInfo.getMinMemory(), vs.isShowLogs(), true, false, true, false, true, true, true, true), exportInfo.getOutput().toFile());
            }

            @Override
            public Collection<Task<?>> getDependencies() {
                return Collections.singleton(this.dependency);
            }
        };
    }

    private Task<?> exportAsServer(final ModpackExportInfo exportInfo) {
        return new Task<Void>(){
            Task<?> dependency;

            @Override
            public void execute() {
                this.dependency = new ServerModpackExportTask(ExportWizardProvider.this.profile.getRepository(), ExportWizardProvider.this.version, exportInfo);
            }

            @Override
            public Collection<Task<?>> getDependencies() {
                return Collections.singleton(this.dependency);
            }
        };
    }

    @Override
    public Node createPage(WizardController controller, int step, Map<String, Object> settings) {
        switch (step) {
            case 0: {
                return new ModpackTypeSelectionPage(controller);
            }
            case 1: {
                return new ModpackInfoPage(controller, this.profile.getRepository(), this.version);
            }
            case 2: {
                return new ModpackFileSelectionPage(controller, this.profile, this.version, ModAdviser::suggestMod);
            }
        }
        throw new IllegalArgumentException("step");
    }

    @Override
    public boolean cancel() {
        return true;
    }
}

