/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.export;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.JFXToggleButton;
import com.jfoenix.validation.RequiredFieldValidator;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.mod.ModpackExportInfo;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackManifest;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.NumberValidator;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class ModpackInfoPage
extends Control
implements WizardPage {
    private final WizardController controller;
    private final HMCLGameRepository gameRepository;
    private final ModpackExportInfo.Options options;
    private final String versionName;
    private final boolean canIncludeLauncher;
    private final ModpackExportInfo exportInfo = new ModpackExportInfo();
    private final SimpleStringProperty name = new SimpleStringProperty("");
    private final SimpleStringProperty author = new SimpleStringProperty("");
    private final SimpleStringProperty version = new SimpleStringProperty("1.0");
    private final SimpleStringProperty description = new SimpleStringProperty("");
    private final SimpleStringProperty url = new SimpleStringProperty("");
    private final SimpleBooleanProperty forceUpdate = new SimpleBooleanProperty();
    private final SimpleBooleanProperty packWithLauncher = new SimpleBooleanProperty();
    private final SimpleStringProperty fileApi = new SimpleStringProperty();
    private final SimpleIntegerProperty minMemory = new SimpleIntegerProperty(0);
    private final SimpleStringProperty authlibInjectorServer = new SimpleStringProperty();
    private final SimpleStringProperty launchArguments = new SimpleStringProperty("");
    private final SimpleStringProperty javaArguments = new SimpleStringProperty("");
    private final ObjectProperty<EventHandler<? super MouseEvent>> next = new SimpleObjectProperty();
    private final SimpleStringProperty mcbbsThreadId = new SimpleStringProperty();
    public static final String MODPACK_INFO = "modpack.info";
    public static final String MODPACK_INFO_OPTION = "modpack.info.option";

    public ModpackInfoPage(WizardController controller, HMCLGameRepository gameRepository, String version) {
        this.controller = controller;
        this.gameRepository = gameRepository;
        this.options = Lang.tryCast(controller.getSettings().get(MODPACK_INFO_OPTION), ModpackExportInfo.Options.class).orElseThrow(() -> new IllegalArgumentException("Settings.MODPACK_INFO_OPTION is required"));
        this.versionName = version;
        this.name.set(version);
        this.author.set(Optional.ofNullable(Accounts.getSelectedAccount()).map(Account::getUsername).orElse(""));
        VersionSetting versionSetting = gameRepository.getVersionSetting(this.versionName);
        this.minMemory.set(Optional.ofNullable(versionSetting.getMinMemory()).orElse(0).intValue());
        this.launchArguments.set(versionSetting.getMinecraftArgs());
        this.javaArguments.set(versionSetting.getJavaArgs());
        List<File> launcherJar = Launcher.getCurrentJarFiles();
        this.canIncludeLauncher = launcherJar != null;
        this.next.set(e -> this.onNext());
    }

    private void onNext() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("modpack.wizard.step.initialization.save"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("modpack"), new String[]{"*.zip"}));
        File file = fileChooser.showSaveDialog((Window)Controllers.getStage());
        if (file == null) {
            this.controller.onEnd();
            return;
        }
        this.exportInfo.setName(this.name.get());
        this.exportInfo.setFileApi(this.fileApi.get());
        this.exportInfo.setVersion(this.version.get());
        this.exportInfo.setAuthor(this.author.get());
        this.exportInfo.setOutput(file.toPath());
        this.exportInfo.setDescription(this.description.get());
        this.exportInfo.setPackWithLauncher(this.packWithLauncher.get());
        this.exportInfo.setUrl(this.url.get());
        this.exportInfo.setForceUpdate(this.forceUpdate.get());
        this.exportInfo.setPackWithLauncher(this.packWithLauncher.get());
        this.exportInfo.setMinMemory(this.minMemory.get());
        this.exportInfo.setLaunchArguments(this.launchArguments.get());
        this.exportInfo.setJavaArguments(this.javaArguments.get());
        this.exportInfo.setAuthlibInjectorServer(this.authlibInjectorServer.get());
        if (StringUtils.isNotBlank(this.mcbbsThreadId.get())) {
            this.exportInfo.setOrigins(Collections.singletonList(new McbbsModpackManifest.Origin("mcbbs", Integer.parseInt(this.mcbbsThreadId.get()))));
        }
        this.controller.getSettings().put(MODPACK_INFO, this.exportInfo);
        this.controller.onNext();
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        this.controller.getSettings().remove(MODPACK_INFO);
    }

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.wizard.step.1.title");
    }

    protected Skin<?> createDefaultSkin() {
        return new ModpackInfoPageSkin(this);
    }

    public static class ModpackInfoPageSkin
    extends SkinBase<ModpackInfoPage> {
        private ObservableList<Node> originList;

        public ModpackInfoPageSkin(ModpackInfoPage skinnable) {
            super((Control)skinnable);
            BorderPane pane;
            Insets insets = new Insets(5.0, 0.0, 12.0, 0.0);
            Insets componentListMargin = new Insets(16.0, 0.0, 16.0, 0.0);
            ScrollPane scroll = new ScrollPane();
            scroll.setFitToWidth(true);
            scroll.setFitToHeight(true);
            this.getChildren().setAll((Object[])new Node[]{scroll});
            ArrayList<JFXTextField> validatingFields = new ArrayList<JFXTextField>();
            BorderPane borderPane = new BorderPane();
            borderPane.setStyle("-fx-padding: 16;");
            scroll.setContent((Node)borderPane);
            if (skinnable.controller.getSettings().get("modpack.type") == "server") {
                Hyperlink hyperlink = new Hyperlink(I18n.i18n("modpack.wizard.step.initialization.server"));
                hyperlink.setOnMouseClicked(e -> FXUtils.openLink("https://hmcl.huangyuhui.net/api/redirect/server-modpack"));
                borderPane.setTop((Node)hyperlink);
            } else {
                Label label = new Label(I18n.i18n("modpack.wizard.step.initialization.warning"));
                label.setWrapText(true);
                label.setTextAlignment(TextAlignment.JUSTIFY);
                borderPane.setTop((Node)label);
            }
            ComponentList list = new ComponentList();
            BorderPane.setMargin((Node)list, (Insets)componentListMargin);
            borderPane.setCenter((Node)list);
            BorderPane borderPane1 = new BorderPane();
            borderPane1.setLeft((Node)new Label(I18n.i18n("modpack.wizard.step.initialization.exported_version")));
            Label versionNameLabel = new Label();
            versionNameLabel.setText(skinnable.versionName);
            borderPane1.setRight((Node)versionNameLabel);
            list.getContent().add((Object)borderPane1);
            JFXTextField txtModpackName = new JFXTextField();
            txtModpackName.textProperty().bindBidirectional((Property)skinnable.name);
            txtModpackName.setLabelFloat(true);
            txtModpackName.setPromptText(I18n.i18n("modpack.name"));
            RequiredFieldValidator validator = new RequiredFieldValidator();
            validator.setMessage(I18n.i18n("modpack.not_a_valid_name"));
            txtModpackName.getValidators().add((Object)validator);
            StackPane.setMargin((Node)txtModpackName, (Insets)insets);
            list.getContent().add((Object)txtModpackName);
            validatingFields.add(txtModpackName);
            if (skinnable.options.isRequireFileApi()) {
                JFXTextField txtModpackFileApi = new JFXTextField();
                txtModpackFileApi.textProperty().bindBidirectional((Property)skinnable.fileApi);
                txtModpackFileApi.setLabelFloat(true);
                txtModpackFileApi.setPromptText(I18n.i18n("modpack.file_api"));
                if (skinnable.options.isValidateFileApi()) {
                    validator = new RequiredFieldValidator();
                    txtModpackFileApi.getValidators().add((Object)validator);
                }
                txtModpackFileApi.getValidators().add((Object)new Validator(s -> {
                    if (s.isEmpty()) {
                        return true;
                    }
                    try {
                        new URL((String)s).toURI();
                        return true;
                    }
                    catch (IOException | URISyntaxException e) {
                        return false;
                    }
                }));
                StackPane.setMargin((Node)txtModpackFileApi, (Insets)insets);
                list.getContent().add((Object)txtModpackFileApi);
                validatingFields.add(txtModpackFileApi);
            }
            JFXTextField txtModpackAuthor = new JFXTextField();
            txtModpackAuthor.textProperty().bindBidirectional((Property)skinnable.author);
            txtModpackAuthor.setLabelFloat(true);
            txtModpackAuthor.setPromptText(I18n.i18n("archive.author"));
            validator = new RequiredFieldValidator();
            txtModpackAuthor.getValidators().add((Object)validator);
            StackPane.setMargin((Node)txtModpackAuthor, (Insets)insets);
            list.getContent().add((Object)txtModpackAuthor);
            validatingFields.add(txtModpackAuthor);
            JFXTextField txtModpackVersion = new JFXTextField();
            txtModpackVersion.textProperty().bindBidirectional((Property)skinnable.version);
            txtModpackVersion.setLabelFloat(true);
            txtModpackVersion.setPromptText(I18n.i18n("archive.version"));
            validator = new RequiredFieldValidator();
            txtModpackVersion.getValidators().add((Object)validator);
            StackPane.setMargin((Node)txtModpackVersion, (Insets)insets);
            list.getContent().add((Object)txtModpackVersion);
            validatingFields.add(txtModpackVersion);
            JFXTextArea area = new JFXTextArea();
            area.textProperty().bindBidirectional((Property)skinnable.description);
            area.setLabelFloat(true);
            area.setPromptText(I18n.i18n("modpack.desc"));
            area.setMinHeight(400.0);
            StackPane.setMargin((Node)area, (Insets)insets);
            list.getContent().add((Object)area);
            if (skinnable.options.isRequireForceUpdate()) {
                BorderPane pane2 = new BorderPane();
                pane2.setLeft((Node)new Label(I18n.i18n("modpack.wizard.step.initialization.force_update")));
                list.getContent().add((Object)pane2);
                JFXToggleButton button = new JFXToggleButton();
                button.setDisable(!skinnable.canIncludeLauncher);
                button.selectedProperty().bindBidirectional((Property)skinnable.packWithLauncher);
                button.setSize(8.0);
                button.setMinHeight(16.0);
                button.setMaxHeight(16.0);
                pane2.setRight((Node)button);
            }
            if (skinnable.options.isRequireAuthlibInjectorServer()) {
                JFXComboBox cboServers = new JFXComboBox();
                cboServers.setCellFactory(FXUtils.jfxListCellFactory(server -> new TwoLineListItem(server.getName(), server.getUrl())));
                cboServers.setConverter(FXUtils.stringConverter(AuthlibInjectorServer::getName));
                Bindings.bindContent((List)cboServers.getItems(), ConfigHolder.config().getAuthlibInjectorServers());
                skinnable.authlibInjectorServer.bind((ObservableValue)Bindings.createStringBinding(() -> Optional.ofNullable(cboServers.getSelectionModel().getSelectedItem()).map(AuthlibInjectorServer::getUrl).orElse(null), (Observable[])new Observable[0]));
                pane = new BorderPane();
                Label left = new Label(I18n.i18n("account.injector.server"));
                BorderPane.setAlignment((Node)left, (Pos)Pos.CENTER_LEFT);
                pane.setLeft((Node)left);
                pane.setRight(cboServers);
                list.getContent().add((Object)pane);
            }
            if (skinnable.options.isRequireMinMemory()) {
                JFXTextField txtMinMemory = new JFXTextField();
                FXUtils.bindInt(txtMinMemory, (Property<Number>)skinnable.minMemory);
                txtMinMemory.getValidators().add((Object)new NumberValidator(I18n.i18n("input.number"), false));
                FXUtils.setLimitWidth((Region)txtMinMemory, 300.0);
                validatingFields.add(txtMinMemory);
                pane = new BorderPane();
                Label label = new Label(I18n.i18n("settings.min_memory"));
                BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER_LEFT);
                pane.setLeft((Node)label);
                BorderPane.setAlignment((Node)txtMinMemory, (Pos)Pos.CENTER_RIGHT);
                pane.setRight((Node)txtMinMemory);
                list.getContent().add((Object)pane);
            }
            if (skinnable.options.isRequireLaunchArguments()) {
                JFXTextField txtLaunchArguments = new JFXTextField();
                txtLaunchArguments.textProperty().bindBidirectional((Property)skinnable.launchArguments);
                txtLaunchArguments.setLabelFloat(true);
                txtLaunchArguments.setPromptText(I18n.i18n("settings.advanced.minecraft_arguments"));
                StackPane.setMargin((Node)txtLaunchArguments, (Insets)insets);
                list.getContent().add((Object)txtLaunchArguments);
            }
            if (skinnable.options.isRequireJavaArguments()) {
                JFXTextField txtJavaArguments = new JFXTextField();
                txtJavaArguments.textProperty().bindBidirectional((Property)skinnable.javaArguments);
                txtJavaArguments.setLabelFloat(true);
                txtJavaArguments.setPromptText(I18n.i18n("settings.advanced.jvm_args"));
                StackPane.setMargin((Node)txtJavaArguments, (Insets)insets);
                list.getContent().add((Object)txtJavaArguments);
            }
            if (skinnable.options.isRequireOrigins() || skinnable.options.isRequireUrl()) {
                Label left;
                BorderPane pane3;
                BorderPane originPane = new BorderPane();
                Label title = new Label(I18n.i18n("modpack.origin"));
                originPane.setTop((Node)title);
                VBox container = new VBox();
                BorderPane.setMargin((Node)container, (Insets)new Insets(0.0, 0.0, 0.0, 16.0));
                originPane.setCenter((Node)container);
                list.getContent().add((Object)originPane);
                if (skinnable.options.isRequireUrl()) {
                    pane3 = new BorderPane();
                    pane3.setPadding(new Insets(8.0, 0.0, 8.0, 0.0));
                    left = new Label(I18n.i18n("modpack.origin.url"));
                    pane3.setLeft((Node)left);
                    JFXTextField txtModpackUrl = new JFXTextField();
                    txtModpackUrl.textProperty().bindBidirectional((Property)skinnable.url);
                    pane3.setRight((Node)txtModpackUrl);
                    container.getChildren().add((Object)pane3);
                }
                if (skinnable.options.isRequireOrigins()) {
                    pane3 = new BorderPane();
                    pane3.setPadding(new Insets(8.0, 0.0, 8.0, 0.0));
                    left = new Label(I18n.i18n("modpack.origin.mcbbs"));
                    pane3.setLeft((Node)left);
                    JFXTextField txtMcbbs = new JFXTextField();
                    FXUtils.setValidateWhileTextChanged((Node)txtMcbbs, true);
                    txtMcbbs.getValidators().add((Object)new NumberValidator(I18n.i18n("input.number"), true));
                    txtMcbbs.textProperty().bindBidirectional((Property)skinnable.mcbbsThreadId);
                    pane3.setRight((Node)txtMcbbs);
                    container.getChildren().add((Object)pane3);
                    validatingFields.add(txtMcbbs);
                }
            }
            HBox hbox = new HBox();
            hbox.setAlignment(Pos.CENTER_RIGHT);
            borderPane.setBottom((Node)hbox);
            JFXButton nextButton = new JFXButton();
            nextButton.onMouseClickedProperty().bind((ObservableValue)skinnable.next);
            nextButton.setPrefWidth(100.0);
            nextButton.setPrefHeight(40.0);
            nextButton.setButtonType(JFXButton.ButtonType.RAISED);
            nextButton.setText(I18n.i18n("wizard.next"));
            nextButton.getStyleClass().add((Object)"jfx-button-raised");
            nextButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> validatingFields.stream().map(field -> !field.validate()).reduce(false, (left, right) -> left != false || right != false), (Observable[])((Observable[])validatingFields.stream().map(TextInputControl::textProperty).toArray(StringProperty[]::new))));
            hbox.getChildren().add((Object)nextButton);
            FXUtils.smoothScrolling(scroll);
        }
    }
}

