/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.export;

import com.jfoenix.controls.JFXButton;
import java.util.Map;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.mod.ModpackExportInfo;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackExportTask;
import org.jackhuang.hmcl.mod.multimc.MultiMCModpackExportTask;
import org.jackhuang.hmcl.mod.server.ServerModpackExportTask;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class ModpackTypeSelectionPage
extends StackPane
implements WizardPage {
    private final WizardController controller;
    @FXML
    private JFXButton btnMCBBS;
    @FXML
    private JFXButton btnMultiMC;
    @FXML
    private JFXButton btnServer;
    public static final String MODPACK_TYPE = "modpack.type";
    public static final String MODPACK_TYPE_MCBBS = "mcbbs";
    public static final String MODPACK_TYPE_MULTIMC = "multimc";
    public static final String MODPACK_TYPE_SERVER = "server";

    public ModpackTypeSelectionPage(WizardController controller) {
        this.controller = controller;
        FXUtils.loadFXML((Node)this, "/assets/fxml/modpack/type.fxml");
        JFXButton[] buttons = new JFXButton[]{this.btnMCBBS, this.btnMultiMC, this.btnServer};
        String[] types = new String[]{MODPACK_TYPE_MCBBS, MODPACK_TYPE_MULTIMC, MODPACK_TYPE_SERVER};
        ModpackExportInfo.Options[] options = new ModpackExportInfo.Options[]{McbbsModpackExportTask.OPTION, MultiMCModpackExportTask.OPTION, ServerModpackExportTask.OPTION};
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            ModpackExportInfo.Options option = options[i];
            buttons[i].setOnMouseClicked(e -> {
                controller.getSettings().put(MODPACK_TYPE, type);
                controller.getSettings().put("modpack.info.option", option);
                controller.onNext();
            });
        }
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
    }

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.wizard.step.3.title");
    }
}

