/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXColorPicker;
import com.jfoenix.effects.JFXDepthManager;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Optional;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.When;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ToggleGroup;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.EnumBackgroundImage;
import org.jackhuang.hmcl.setting.EnumCommonDirectory;
import org.jackhuang.hmcl.setting.Settings;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.main.SettingsView;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.upgrade.UpdateChannel;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.upgrade.UpdateHandler;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.Locales;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.javafx.ExtendedProperties;
import org.jackhuang.hmcl.util.javafx.SafeStringConverter;

public final class SettingsPage
extends SettingsView
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("settings.launcher")));
    private InvalidationListener updateListener;

    public SettingsPage() {
        FXUtils.smoothScrolling(this.scroll);
        this.cboDownloadSource.getItems().setAll(DownloadProviders.providersById.keySet());
        ExtendedProperties.selectedItemPropertyFor(this.cboDownloadSource).bindBidirectional((Property)ConfigHolder.config().downloadTypeProperty());
        this.cboFont.valueProperty().bindBidirectional((Property)ConfigHolder.config().fontFamilyProperty());
        this.txtFontSize.textProperty().bindBidirectional((Property)ConfigHolder.config().fontSizeProperty(), SafeStringConverter.fromFiniteDouble().restrict(it -> it > 0.0).fallbackTo(12.0).asPredicate(Validator.addTo(this.txtFontSize)));
        this.lblDisplay.fontProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> Font.font((String)ConfigHolder.config().getFontFamily(), (double)ConfigHolder.config().getFontSize()), (Observable[])new Observable[]{ConfigHolder.config().fontFamilyProperty(), ConfigHolder.config().fontSizeProperty()}));
        this.cboLanguage.getItems().setAll(Locales.LOCALES);
        ExtendedProperties.selectedItemPropertyFor(this.cboLanguage).bindBidirectional(ConfigHolder.config().localizationProperty());
        this.txtProxyHost.textProperty().bindBidirectional((Property)ConfigHolder.config().proxyHostProperty());
        this.txtProxyPort.textProperty().bindBidirectional((Property)ConfigHolder.config().proxyPortProperty(), SafeStringConverter.fromInteger().restrict(it -> it >= 0 && it <= 65535).fallbackTo(0).asPredicate(Validator.addTo(this.txtProxyPort)));
        this.txtProxyUsername.textProperty().bindBidirectional((Property)ConfigHolder.config().proxyUserProperty());
        this.txtProxyPassword.textProperty().bindBidirectional((Property)ConfigHolder.config().proxyPassProperty());
        this.proxyPane.disableProperty().bind((ObservableValue)this.chkDisableProxy.selectedProperty());
        this.authPane.disableProperty().bind((ObservableValue)this.chkProxyAuthentication.selectedProperty().not());
        ExtendedProperties.reversedSelectedPropertyFor(this.chkDisableProxy).bindBidirectional((Property)ConfigHolder.config().hasProxyProperty());
        this.chkProxyAuthentication.selectedProperty().bindBidirectional((Property)ConfigHolder.config().hasProxyAuthProperty());
        ToggleGroup proxyConfigurationGroup = new ToggleGroup();
        this.chkProxyHttp.setUserData((Object)Proxy.Type.HTTP);
        this.chkProxyHttp.setToggleGroup(proxyConfigurationGroup);
        this.chkProxySocks.setUserData((Object)Proxy.Type.SOCKS);
        this.chkProxySocks.setToggleGroup(proxyConfigurationGroup);
        ExtendedProperties.selectedItemPropertyFor(proxyConfigurationGroup, Proxy.Type.class).bindBidirectional(ConfigHolder.config().proxyTypeProperty());
        this.fileCommonLocation.loadChildren(Collections.singletonList(this.fileCommonLocation.createChildren(I18n.i18n("launcher.cache_directory.default"), EnumCommonDirectory.DEFAULT)), EnumCommonDirectory.CUSTOM);
        this.fileCommonLocation.selectedDataProperty().bindBidirectional(ConfigHolder.config().commonDirTypeProperty());
        this.fileCommonLocation.customTextProperty().bindBidirectional((Property)ConfigHolder.config().commonDirectoryProperty());
        this.fileCommonLocation.subtitleProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> Optional.ofNullable(Settings.instance().getCommonDirectory()).orElse(I18n.i18n("launcher.cache_directory.disabled")), (Observable[])new Observable[]{ConfigHolder.config().commonDirectoryProperty(), ConfigHolder.config().commonDirTypeProperty()}));
        FXUtils.installFastTooltip((Node)this.btnUpdate, I18n.i18n("update.tooltip"));
        this.updateListener = any -> {
            this.btnUpdate.setVisible(UpdateChecker.isOutdated());
            if (UpdateChecker.isOutdated()) {
                this.lblUpdateSub.setText(I18n.i18n("update.newest_version", UpdateChecker.getLatestVersion().getVersion()));
                this.lblUpdateSub.getStyleClass().setAll((Object[])new String[]{"update-label"});
                this.lblUpdate.setText(I18n.i18n("update.found"));
                this.lblUpdate.getStyleClass().setAll((Object[])new String[]{"update-label"});
            } else if (UpdateChecker.isCheckingUpdate()) {
                this.lblUpdateSub.setText(I18n.i18n("update.checking"));
                this.lblUpdateSub.getStyleClass().setAll((Object[])new String[]{"subtitle-label"});
                this.lblUpdate.setText(I18n.i18n("update"));
                this.lblUpdate.getStyleClass().setAll((Object[])new String[0]);
            } else {
                this.lblUpdateSub.setText(I18n.i18n("update.latest"));
                this.lblUpdateSub.getStyleClass().setAll((Object[])new String[]{"subtitle-label"});
                this.lblUpdate.setText(I18n.i18n("update"));
                this.lblUpdate.getStyleClass().setAll((Object[])new String[0]);
            }
        };
        UpdateChecker.latestVersionProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateListener));
        UpdateChecker.outdatedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateListener));
        UpdateChecker.checkingUpdateProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateListener));
        this.updateListener.invalidated(null);
        this.lblUpdateNote.setWrappingWidth(470.0);
        ToggleGroup updateChannelGroup = new ToggleGroup();
        this.chkUpdateDev.setToggleGroup(updateChannelGroup);
        this.chkUpdateDev.setUserData((Object)UpdateChannel.DEVELOPMENT);
        this.chkUpdateStable.setToggleGroup(updateChannelGroup);
        this.chkUpdateStable.setUserData((Object)UpdateChannel.STABLE);
        ExtendedProperties.selectedItemPropertyFor(updateChannelGroup, UpdateChannel.class).bindBidirectional(ConfigHolder.config().updateChannelProperty());
        this.backgroundItem.loadChildren(Collections.singletonList(this.backgroundItem.createChildren(I18n.i18n("launcher.background.default"), EnumBackgroundImage.DEFAULT)), EnumBackgroundImage.CUSTOM);
        this.backgroundItem.customTextProperty().bindBidirectional((Property)ConfigHolder.config().backgroundImageProperty());
        this.backgroundItem.selectedDataProperty().bindBidirectional(ConfigHolder.config().backgroundImageTypeProperty());
        this.backgroundItem.subtitleProperty().bind((ObservableValue)new When((ObservableBooleanValue)this.backgroundItem.selectedDataProperty().isEqualTo((Object)EnumBackgroundImage.DEFAULT)).then(I18n.i18n("launcher.background.default")).otherwise((ObservableStringValue)ConfigHolder.config().backgroundImageProperty()));
        JFXColorPicker picker = new JFXColorPicker(Color.web((String)ConfigHolder.config().getTheme().getColor()), null);
        picker.setCustomColorText(I18n.i18n("color.custom"));
        picker.setRecentColorsText(I18n.i18n("color.recent"));
        picker.getCustomColors().setAll((Object[])Theme.SUGGESTED_COLORS);
        picker.setOnAction(e -> {
            Theme theme = Theme.custom(Theme.getColorDisplayName((Color)picker.getValue()));
            ConfigHolder.config().setTheme(theme);
            Controllers.getScene().getStylesheets().setAll((Object[])theme.getStylesheets());
        });
        this.themeColorPickerContainer.getChildren().setAll((Object[])new Node[]{picker});
        Platform.runLater(() -> JFXDepthManager.setDepth((Node)picker, 0));
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    @Override
    protected void onUpdate() {
        RemoteVersion target = UpdateChecker.getLatestVersion();
        if (target == null) {
            return;
        }
        UpdateHandler.updateFrom(target);
    }

    @Override
    protected void onExportLogs() {
        Lang.thread(() -> {
            Path logFile = Paths.get("hmcl-exported-logs-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss")) + ".log", new String[0]).toAbsolutePath();
            Logging.LOG.info("Exporting logs to " + logFile);
            try {
                Files.write(logFile, Logging.getRawLogs(), new OpenOption[0]);
            }
            catch (IOException e) {
                Platform.runLater(() -> Controllers.dialog(I18n.i18n("settings.launcher.launcher_log.export.failed") + "\n" + e, null, MessageDialogPane.MessageType.ERROR));
                Logging.LOG.log(Level.WARNING, "Failed to export logs", e);
                return;
            }
            Platform.runLater(() -> Controllers.dialog(I18n.i18n("settings.launcher.launcher_log.export.success", logFile)));
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().open(logFile.toFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    protected void onHelp() {
        FXUtils.openLink("https://hmcl.huangyuhui.net/help");
    }

    @Override
    protected void onSponsor() {
        FXUtils.openLink("https://hmcl.huangyuhui.net/api/redirect/sponsor");
    }

    @Override
    protected void clearCacheDirectory() {
        FileUtils.cleanDirectoryQuietly(new File(Settings.instance().getCommonDirectory(), "cache"));
    }
}

