/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.profile;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Skin;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.ui.profile.ProfileListItemSkin;

public class ProfileListItem
extends RadioButton {
    private final Profile profile;
    private final StringProperty title = new SimpleStringProperty();
    private final StringProperty subtitle = new SimpleStringProperty();

    public ProfileListItem(Profile profile) {
        this.profile = profile;
        this.getStyleClass().clear();
        this.setUserData(profile);
        this.title.set((Object)Profiles.getProfileDisplayName(profile));
        this.subtitle.set((Object)profile.getGameDir().toString());
    }

    protected Skin<?> createDefaultSkin() {
        return new ProfileListItemSkin(this);
    }

    public void remove() {
        Profiles.getProfiles().remove((Object)this.profile);
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public String getSubtitle() {
        return (String)this.subtitle.get();
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.set((Object)subtitle);
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }
}

