/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.util.i18n.I18n;

public class GameAdvancedListItem
extends AdvancedListItem {
    private final Tooltip tooltip = new Tooltip();

    public GameAdvancedListItem() {
        FXUtils.onChangeAndOperate(Profiles.selectedVersionProperty(), version -> {
            if (version != null && Profiles.getSelectedProfile() != null && Profiles.getSelectedProfile().getRepository().hasVersion((String)version)) {
                FXUtils.installFastTooltip((Node)this, this.tooltip);
                this.setTitle((String)version);
                this.setSubtitle(null);
                this.setImage(Profiles.getSelectedProfile().getRepository().getVersionIconImage((String)version));
                this.tooltip.setText(version);
            } else {
                Tooltip.uninstall((Node)this, (Tooltip)this.tooltip);
                this.setTitle(I18n.i18n("version.empty"));
                this.setSubtitle(I18n.i18n("version.empty.add"));
                this.setImage(FXUtils.newImage("/assets/img/grass.png"));
                this.tooltip.setText("");
            }
        });
        this.setRightGraphic(SVG.gear(Theme.blackFillBinding(), -1.0, -1.0));
    }
}

