/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.Node;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import org.jackhuang.hmcl.event.EventBus;
import org.jackhuang.hmcl.event.RefreshingVersionsEvent;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.download.ModpackInstallWizardProvider;
import org.jackhuang.hmcl.ui.download.VanillaInstallWizardProvider;
import org.jackhuang.hmcl.ui.versions.GameListItem;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public class GameList
extends ListPageBase<GameListItem>
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("version.manage")));
    private ToggleGroup toggleGroup;

    public GameList() {
        EventBus.EVENT_BUS.channel(RefreshingVersionsEvent.class).register(event -> {
            if (event.getSource() == Profiles.getSelectedProfile().getRepository()) {
                FXUtils.runInFX(() -> this.setLoading(true));
            }
        });
        Profiles.registerVersionsListener(this::loadVersions);
    }

    private void loadVersions(Profile profile) {
        HMCLGameRepository repository = profile.getRepository();
        this.toggleGroup = new ToggleGroup();
        WeakListenerHolder listenerHolder = new WeakListenerHolder();
        this.toggleGroup.getProperties().put((Object)"ReferenceHolder", (Object)listenerHolder);
        List children = repository.getVersions().parallelStream().filter(version -> !version.isHidden()).sorted(Comparator.comparing(version -> version.getReleaseTime() == null ? new Date(0L) : version.getReleaseTime()).thenComparing(a -> VersionNumber.asVersion(a.getId()))).map(version -> new GameListItem(this.toggleGroup, profile, version.getId())).collect(Collectors.toList());
        FXUtils.runInFX(() -> {
            if (profile == Profiles.getSelectedProfile()) {
                this.setLoading(false);
                this.itemsProperty().setAll((Collection)children);
                children.forEach(GameListItem::checkSelection);
                profile.selectedVersionProperty().addListener(listenerHolder.weak((a, b, newValue) -> {
                    FXUtils.checkFxUserThread();
                    children.forEach(it -> it.selectedProperty().set(false));
                    children.stream().filter(it -> it.getVersion().equals(newValue)).findFirst().ifPresent(it -> it.selectedProperty().set(true));
                }));
            }
            this.toggleGroup.selectedToggleProperty().addListener((o, a, toggle) -> {
                if (toggle == null) {
                    return;
                }
                GameListItem model = (GameListItem)((Object)((Object)((Object)toggle.getUserData())));
                model.getProfile().setSelectedVersion(model.getVersion());
            });
        });
    }

    protected GameListSkin createDefaultSkin() {
        return new GameListSkin();
    }

    public static void addNewGame() {
        Profile profile = Profiles.getSelectedProfile();
        if (profile.getRepository().isLoaded()) {
            Controllers.getDecorator().startWizard(new VanillaInstallWizardProvider(profile), I18n.i18n("install.new_game"));
        }
    }

    public static void importModpack() {
        Profile profile = Profiles.getSelectedProfile();
        if (profile.getRepository().isLoaded()) {
            Controllers.getDecorator().startWizard(new ModpackInstallWizardProvider(profile), I18n.i18n("install.modpack"));
        }
    }

    public static void refreshList() {
        Profiles.getSelectedProfile().getRepository().refreshVersionsAsync().start();
    }

    public void modifyGlobalGameSettings() {
        Versions.modifyGlobalSettings(Profiles.getSelectedProfile());
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    private class GameListSkin
    extends ToolbarListPageSkin<GameList> {
        public GameListSkin() {
            super(GameList.this);
            HBox hbox = new HBox(new Node[]{GameListSkin.createToolbarButton(I18n.i18n("install.new_game"), SVG::plus, GameList::addNewGame), GameListSkin.createToolbarButton(I18n.i18n("install.modpack"), SVG::importIcon, GameList::importModpack), GameListSkin.createToolbarButton(I18n.i18n("button.refresh"), SVG::refresh, GameList::refreshList), GameListSkin.createToolbarButton(I18n.i18n("settings.type.global.manage"), SVG::gear, GameList.this::modifyGlobalGameSettings)});
            hbox.setPickOnBounds(false);
            GameList.this.state.set((Object)new DecoratorPage.State(I18n.i18n("version.manage"), (Node)hbox, true, false, true));
        }

        @Override
        protected List<Node> initializeToolbar(GameList skinnable) {
            return Collections.emptyList();
        }
    }
}

