/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.mod.ModInfo;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.versions.ModListPageSkin;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class ModListPage
extends ListPageBase<ModListPageSkin.ModInfoObject> {
    private final BooleanProperty modded = new SimpleBooleanProperty((Object)this, "modded", false);
    private TabControl.Tab tab;
    private ModManager modManager;
    private LibraryAnalyzer libraryAnalyzer;

    public ModListPage(TabControl.Tab tab) {
        this.tab = tab;
        FXUtils.applyDragListener((Node)this, it -> Arrays.asList("jar", "zip", "litemod").contains(FileUtils.getExtension(it)), mods -> {
            mods.forEach(it -> {
                try {
                    this.modManager.addMod((File)it);
                }
                catch (IOException | IllegalArgumentException e) {
                    Logging.LOG.log(Level.WARNING, "Unable to parse mod file " + it, e);
                }
            });
            this.loadMods(this.modManager);
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new ModListPageSkin(this);
    }

    public void refresh() {
        this.loadMods(this.modManager);
    }

    public CompletableFuture<?> loadVersion(Profile profile, String id) {
        this.libraryAnalyzer = LibraryAnalyzer.analyze(profile.getRepository().getResolvedPreservingPatchesVersion(id));
        this.modded.set(this.libraryAnalyzer.hasModLoader());
        return this.loadMods(profile.getRepository().getModManager(id));
    }

    private CompletableFuture<?> loadMods(ModManager modManager) {
        this.modManager = modManager;
        return CompletableFuture.supplyAsync(() -> {
            try {
                ModListPage modListPage = this;
                synchronized (modListPage) {
                    FXUtils.runInFX(() -> this.loadingProperty().set(true));
                    modManager.refreshMods();
                    return new LinkedList<ModInfo>(modManager.getMods());
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).whenCompleteAsync((list, exception) -> {
            this.loadingProperty().set(false);
            if (exception == null) {
                this.getProperties().put(ModListPage.class, FXUtils.onWeakChangeAndOperate(this.tab.selectedProperty(), newValue -> {
                    if (newValue.booleanValue()) {
                        this.itemsProperty().setAll((Collection)list.stream().map(ModListPageSkin.ModInfoObject::new).sorted().collect(Collectors.toList()));
                    }
                }));
            } else {
                this.getProperties().remove(ModListPage.class);
            }
        }, Platform::runLater);
    }

    public void add() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(I18n.i18n("mods.choose_mod"));
        chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18n.i18n("extension.mod"), new String[]{"*.jar", "*.zip", "*.litemod"})});
        List res = chooser.showOpenMultipleDialog((Window)Controllers.getStage());
        LinkedList succeeded = new LinkedList();
        LinkedList failed = new LinkedList();
        if (res == null) {
            return;
        }
        Task.runAsync(() -> {
            for (File file : res) {
                try {
                    this.modManager.addMod(file);
                    succeeded.add(file.getName());
                }
                catch (Exception e) {
                    Logging.LOG.log(Level.WARNING, "Unable to add mod " + file, e);
                    failed.add(file.getName());
                }
            }
        }).withRunAsync(Schedulers.javafx(), () -> {
            LinkedList<String> prompt = new LinkedList<String>();
            if (!succeeded.isEmpty()) {
                prompt.add(I18n.i18n("mods.add.success", String.join((CharSequence)", ", succeeded)));
            }
            if (!failed.isEmpty()) {
                prompt.add(I18n.i18n("mods.add.failed", String.join((CharSequence)", ", failed)));
            }
            Controllers.dialog(String.join((CharSequence)"\n", prompt), I18n.i18n("mods.add"));
            this.loadMods(this.modManager);
        }).start();
    }

    public void removeSelected(ObservableList<ModListPageSkin.ModInfoObject> selectedItems) {
        try {
            this.modManager.removeMods((ModInfo[])selectedItems.stream().filter(Objects::nonNull).map(ModListPageSkin.ModInfoObject::getModInfo).toArray(ModInfo[]::new));
            this.loadMods(this.modManager);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void enableSelected(ObservableList<ModListPageSkin.ModInfoObject> selectedItems) {
        selectedItems.stream().filter(Objects::nonNull).map(ModListPageSkin.ModInfoObject::getModInfo).forEach(info -> info.setActive(true));
    }

    public void disableSelected(ObservableList<ModListPageSkin.ModInfoObject> selectedItems) {
        selectedItems.stream().filter(Objects::nonNull).map(ModListPageSkin.ModInfoObject::getModInfo).forEach(info -> info.setActive(false));
    }

    public boolean isModded() {
        return this.modded.get();
    }

    public BooleanProperty moddedProperty() {
        return this.modded;
    }

    public void setModded(boolean modded) {
        this.modded.set(modded);
    }
}

