/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import com.jfoenix.effects.JFXDepthManager;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.mod.ModInfo;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.construct.FloatListCell;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.ModListPage;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jetbrains.annotations.NotNull;

class ModListPageSkin
extends SkinBase<ModListPage> {
    ModListPageSkin(ModListPage skinnable) {
        super((Control)skinnable);
        StackPane pane = new StackPane();
        pane.getStyleClass().addAll((Object[])new String[]{"notice-pane"});
        BorderPane root = new BorderPane();
        final JFXListView listView = new JFXListView();
        HBox toolbar = new HBox();
        toolbar.getStyleClass().add((Object)"jfx-tool-bar-second");
        JFXDepthManager.setDepth((Node)toolbar, 1);
        toolbar.setPickOnBounds(false);
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton(I18n.i18n("button.refresh"), SVG::refresh, skinnable::refresh));
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton(I18n.i18n("mods.add"), SVG::plus, skinnable::add));
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton(I18n.i18n("button.remove"), SVG::delete, () -> Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("button.remove"), () -> skinnable.removeSelected((ObservableList<ModInfoObject>)listView.getSelectionModel().getSelectedItems()), null)));
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton(I18n.i18n("mods.enable"), SVG::check, () -> skinnable.enableSelected((ObservableList<ModInfoObject>)listView.getSelectionModel().getSelectedItems())));
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton(I18n.i18n("mods.disable"), SVG::close, () -> skinnable.disableSelected((ObservableList<ModInfoObject>)listView.getSelectionModel().getSelectedItems())));
        root.setTop((Node)toolbar);
        SpinnerPane center = new SpinnerPane();
        center.getStyleClass().add((Object)"large-spinner-pane");
        center.loadingProperty().bind((ObservableValue)skinnable.loadingProperty());
        listView.setCellFactory(x -> new FloatListCell<ModInfoObject>(){
            JFXCheckBox checkBox = new JFXCheckBox();
            TwoLineListItem content = new TwoLineListItem();
            BooleanProperty booleanProperty;
            {
                Region clippedContainer = (Region)listView.lookup(".clipped-container");
                this.setPrefWidth(0.0);
                HBox container = new HBox(8.0);
                container.setAlignment(Pos.CENTER_LEFT);
                this.pane.getChildren().add((Object)container);
                if (clippedContainer != null) {
                    this.maxWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
                    this.prefWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
                    this.minWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
                }
                container.getChildren().setAll((Object[])new Node[]{this.checkBox, this.content});
            }

            @Override
            protected void updateControl(ModInfoObject dataItem, boolean empty) {
                if (empty) {
                    return;
                }
                this.content.setTitle(dataItem.getTitle());
                this.content.setSubtitle(dataItem.getSubtitle());
                if (this.booleanProperty != null) {
                    this.checkBox.selectedProperty().unbindBidirectional((Property)this.booleanProperty);
                }
                this.booleanProperty = dataItem.active;
                this.checkBox.selectedProperty().bindBidirectional((Property)this.booleanProperty);
            }
        });
        listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Bindings.bindContent((List)listView.getItems(), skinnable.getItems());
        center.setContent((Node)listView);
        root.setCenter((Node)center);
        Label label = new Label(I18n.i18n("mods.not_modded"));
        label.prefWidthProperty().bind((ObservableValue)pane.widthProperty().add(-100));
        FXUtils.onChangeAndOperate(skinnable.moddedProperty(), modded -> {
            if (modded.booleanValue()) {
                pane.getChildren().setAll((Object[])new Node[]{root});
            } else {
                pane.getChildren().setAll((Object[])new Node[]{label});
            }
        });
        this.getChildren().setAll((Object[])new Node[]{pane});
    }

    static class ModInfoObject
    extends RecursiveTreeObject<ModInfoObject>
    implements Comparable<ModInfoObject> {
        private final BooleanProperty active;
        private final ModInfo modInfo;
        private final String message;

        ModInfoObject(ModInfo modInfo) {
            this.modInfo = modInfo;
            this.active = modInfo.activeProperty();
            StringBuilder message = new StringBuilder(modInfo.getName());
            if (StringUtils.isNotBlank(modInfo.getVersion())) {
                message.append(", ").append(I18n.i18n("archive.version")).append(": ").append(modInfo.getVersion());
            }
            if (StringUtils.isNotBlank(modInfo.getGameVersion())) {
                message.append(", ").append(I18n.i18n("archive.game_version")).append(": ").append(modInfo.getGameVersion());
            }
            if (StringUtils.isNotBlank(modInfo.getAuthors())) {
                message.append(", ").append(I18n.i18n("archive.author")).append(": ").append(modInfo.getAuthors());
            }
            this.message = message.toString();
        }

        String getTitle() {
            return this.modInfo.getFileName();
        }

        String getSubtitle() {
            return this.message;
        }

        ModInfo getModInfo() {
            return this.modInfo;
        }

        @Override
        public int compareTo(@NotNull ModInfoObject o) {
            return this.modInfo.getFileName().toLowerCase().compareTo(o.modInfo.getFileName().toLowerCase());
        }
    }
}

