/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXListCell;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXPopup;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.MenuSeparator;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.construct.TabHeader;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.GameList;
import org.jackhuang.hmcl.ui.versions.InstallerListPage;
import org.jackhuang.hmcl.ui.versions.ModListPage;
import org.jackhuang.hmcl.ui.versions.VersionSettingsPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.ui.versions.WorldListPage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public class VersionPage
extends Control
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper();
    private final BooleanProperty loading = new SimpleBooleanProperty();
    private final JFXListView<String> listView = new JFXListView();
    private final TabControl.Tab versionSettingsTab = new TabControl.Tab("versionSettingsTab");
    private final VersionSettingsPage versionSettingsPage = new VersionSettingsPage();
    private final TabControl.Tab modListTab = new TabControl.Tab("modListTab");
    private final ModListPage modListPage = new ModListPage(this.modListTab);
    private final TabControl.Tab installerListTab = new TabControl.Tab("installerListTab");
    private final InstallerListPage installerListPage = new InstallerListPage();
    private final TabControl.Tab worldListTab = new TabControl.Tab("worldList");
    private final WorldListPage worldListPage = new WorldListPage();
    private final TransitionPane transitionPane = new TransitionPane();
    private final ObjectProperty<TabControl.Tab> selectedTab = new SimpleObjectProperty();
    private final BooleanProperty currentVersionUpgradable = new SimpleBooleanProperty();
    private Profile profile;
    private String version;
    private String preferredVersionName = null;

    public VersionPage() {
        Profiles.registerVersionsListener(this::loadVersions);
        this.listView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && !Objects.equals(oldValue, newValue)) {
                this.loadVersion((String)newValue, this.profile);
            }
            if (newValue == null && !Objects.equals(oldValue, newValue)) {
                if (this.listView.getItems().contains((Object)this.preferredVersionName)) {
                    this.loadVersion(this.preferredVersionName, this.profile);
                } else if (!this.listView.getItems().isEmpty()) {
                    this.loadVersion((String)this.listView.getItems().get(0), this.profile);
                }
            }
        });
        this.versionSettingsTab.setNode((Node)this.versionSettingsPage);
        this.modListTab.setNode((Node)this.modListPage);
        this.installerListTab.setNode((Node)this.installerListPage);
        this.worldListTab.setNode((Node)this.worldListPage);
        this.addEventHandler(Navigator.NavigationEvent.NAVIGATED, this::onNavigated);
    }

    private void loadVersions(Profile profile) {
        HMCLGameRepository repository = profile.getRepository();
        List children = repository.getVersions().parallelStream().filter(version -> !version.isHidden()).sorted(Comparator.comparing(version -> version.getReleaseTime() == null ? new Date(0L) : version.getReleaseTime()).thenComparing(a -> VersionNumber.asVersion(a.getId()))).map(Version::getId).collect(Collectors.toList());
        FXUtils.runInFX(() -> {
            if (profile == Profiles.getSelectedProfile()) {
                this.profile = profile;
                this.loading.set(false);
                this.listView.getItems().setAll((Collection)children);
            }
        });
    }

    public void setVersion(String version, Profile profile) {
        this.version = version;
        this.profile = profile;
        profile.setSelectedVersion(version);
    }

    public void loadVersion(String version, Profile profile) {
        if (!this.profile.getRepository().isLoaded() || !this.profile.getRepository().hasVersion(version)) {
            Platform.runLater(() -> this.fireEvent(new PageCloseEvent()));
            return;
        }
        this.setVersion(version, profile);
        this.preferredVersionName = version;
        this.listView.getSelectionModel().select((Object)version);
        this.versionSettingsPage.loadVersion(profile, version);
        this.currentVersionUpgradable.set(profile.getRepository().isModpack(version));
        CompletableFuture.allOf(this.modListPage.loadVersion(profile, version), this.installerListPage.loadVersion(profile, version), this.worldListPage.loadVersion(profile, version));
    }

    private void onNavigated(Navigator.NavigationEvent event) {
        if (this.version == null || this.profile == null) {
            throw new IllegalStateException();
        }
        if (!this.profile.getRepository().isLoaded() || !this.profile.getRepository().hasVersion(this.version)) {
            Platform.runLater(() -> this.fireEvent(new PageCloseEvent()));
            return;
        }
        this.loadVersion(this.version, this.profile);
    }

    private void onBrowse(String sub) {
        FXUtils.openFolder(new File(this.profile.getRepository().getRunDirectory(this.version), sub));
    }

    private void redownloadAssetIndex() {
        Versions.updateGameAssets(this.profile, this.version);
    }

    private void clearLibraries() {
        FileUtils.deleteDirectoryQuietly(new File(this.profile.getRepository().getBaseDirectory(), "libraries"));
    }

    private void clearJunkFiles() {
        Versions.cleanVersion(this.profile, this.version);
    }

    private void testGame() {
        Versions.testGame(this.profile, this.version);
    }

    private void updateGame() {
        Versions.updateVersion(this.profile, this.version);
    }

    private void generateLaunchScript() {
        Versions.generateLaunchScript(this.profile, this.version);
    }

    private void export() {
        Versions.exportVersion(this.profile, this.version);
    }

    private void rename() {
        Versions.renameVersion(this.profile, this.version).thenApply(newVersionName -> {
            this.preferredVersionName = newVersionName;
            return this.preferredVersionName;
        });
    }

    private void remove() {
        Versions.deleteVersion(this.profile, this.version);
    }

    private void duplicate() {
        Versions.duplicateVersion(this.profile, this.version);
    }

    protected Skin createDefaultSkin() {
        return new Skin(this);
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    public static class Skin
    extends SkinBase<VersionPage> {
        String currentVersion;
        private JFXPopup listViewItemPopup;

        protected Skin(VersionPage control) {
            super((Control)control);
            PopupMenu menu = new PopupMenu();
            this.listViewItemPopup = new JFXPopup((Region)menu);
            menu.getContent().setAll((Object[])new Node[]{new IconedMenuItem(FXUtils.limitingSize(SVG.launch(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("version.launch.test"), FXUtils.withJFXPopupClosing(() -> Versions.testGame(((VersionPage)this.getSkinnable()).profile, this.currentVersion), this.listViewItemPopup)), new IconedMenuItem(FXUtils.limitingSize(SVG.script(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("version.launch_script"), FXUtils.withJFXPopupClosing(() -> Versions.generateLaunchScript(((VersionPage)this.getSkinnable()).profile, this.currentVersion), this.listViewItemPopup)), new MenuSeparator(), new IconedMenuItem(FXUtils.limitingSize(SVG.pencil(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("version.manage.rename"), FXUtils.withJFXPopupClosing(() -> Versions.renameVersion(((VersionPage)this.getSkinnable()).profile, this.currentVersion).thenApply(name -> ((VersionPage)this.getSkinnable()).preferredVersionName = name), this.listViewItemPopup)), new IconedMenuItem(FXUtils.limitingSize(SVG.copy(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("version.manage.duplicate"), FXUtils.withJFXPopupClosing(() -> Versions.duplicateVersion(((VersionPage)this.getSkinnable()).profile, this.currentVersion), this.listViewItemPopup)), new IconedMenuItem(FXUtils.limitingSize(SVG.delete(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("version.manage.remove"), FXUtils.withJFXPopupClosing(() -> Versions.deleteVersion(((VersionPage)this.getSkinnable()).profile, this.currentVersion), this.listViewItemPopup)), new IconedMenuItem(FXUtils.limitingSize(SVG.export(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("modpack.export"), FXUtils.withJFXPopupClosing(() -> Versions.exportVersion(((VersionPage)this.getSkinnable()).profile, this.currentVersion), this.listViewItemPopup)), new MenuSeparator(), new IconedMenuItem(FXUtils.limitingSize(SVG.folderOpen(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("folder.game"), FXUtils.withJFXPopupClosing(() -> Versions.openFolder(((VersionPage)this.getSkinnable()).profile, this.currentVersion), this.listViewItemPopup))});
            control.listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
            control.listView.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

                public ListCell<String> call(ListView<String> param) {
                    JFXListCell<String> cell = new JFXListCell<String>();
                    cell.setOnMouseClicked(e -> {
                        if (cell.getItem() == null) {
                            return;
                        }
                        currentVersion = (String)cell.getItem();
                        if (e.getButton() == MouseButton.SECONDARY) {
                            listViewItemPopup.show((Node)cell, JFXPopup.PopupVPosition.TOP, JFXPopup.PopupHPosition.LEFT, e.getX(), e.getY());
                        }
                    });
                    return cell;
                }
            });
            SpinnerPane spinnerPane = new SpinnerPane();
            spinnerPane.getStyleClass().add((Object)"large-spinner-pane");
            BorderPane root = new BorderPane();
            BorderPane left = new BorderPane();
            FXUtils.setLimitWidth((Region)left, 200.0);
            left.setCenter((Node)control.listView);
            root.setLeft((Node)left);
            JFXButton btnAddGame = ToolbarListPageSkin.createToolbarButton(null, SVG::plus, GameList::addNewGame);
            FXUtils.installFastTooltip((Node)btnAddGame, new Tooltip(I18n.i18n("install.new_game")));
            JFXButton btnImportModpack = ToolbarListPageSkin.createToolbarButton(null, SVG::importIcon, GameList::importModpack);
            FXUtils.installFastTooltip((Node)btnImportModpack, new Tooltip(I18n.i18n("install.modpack")));
            JFXButton btnRefresh = ToolbarListPageSkin.createToolbarButton(null, SVG::refresh, GameList::refreshList);
            FXUtils.installFastTooltip((Node)btnRefresh, new Tooltip(I18n.i18n("button.refresh")));
            HBox toolbar = new HBox();
            toolbar.setPickOnBounds(false);
            toolbar.getChildren().setAll((Object[])new Node[]{btnAddGame, btnImportModpack, btnRefresh});
            left.setTop((Node)toolbar);
            TabHeader tabPane = new TabHeader(new TabControl.Tab[0]);
            tabPane.setPickOnBounds(false);
            tabPane.getStyleClass().add((Object)"jfx-decorator-tab");
            control.versionSettingsTab.setText(I18n.i18n("settings"));
            control.modListTab.setText(I18n.i18n("mods"));
            control.installerListTab.setText(I18n.i18n("settings.tabs.installers"));
            control.worldListTab.setText(I18n.i18n("world"));
            tabPane.getTabs().setAll((Object[])new TabControl.Tab[]{control.versionSettingsTab, control.modListTab, control.installerListTab, control.worldListTab});
            control.selectedTab.bind((ObservableValue)tabPane.getSelectionModel().selectedItemProperty());
            FXUtils.onChangeAndOperate(tabPane.getSelectionModel().selectedItemProperty(), newValue -> control.transitionPane.setContent(newValue.getNode(), ContainerAnimations.FADE.getAnimationProducer()));
            HBox toolBar = new HBox();
            toolBar.setAlignment(Pos.TOP_RIGHT);
            toolBar.setPickOnBounds(false);
            PopupMenu browseList = new PopupMenu();
            JFXPopup browsePopup = new JFXPopup((Region)browseList);
            browseList.getContent().setAll((Object[])new Node[]{new IconedMenuItem(null, I18n.i18n("folder.game"), FXUtils.withJFXPopupClosing(() -> control.onBrowse(""), browsePopup)), new IconedMenuItem(null, I18n.i18n("folder.mod"), FXUtils.withJFXPopupClosing(() -> control.onBrowse("mods"), browsePopup)), new IconedMenuItem(null, I18n.i18n("folder.config"), FXUtils.withJFXPopupClosing(() -> control.onBrowse("config"), browsePopup)), new IconedMenuItem(null, I18n.i18n("folder.resourcepacks"), FXUtils.withJFXPopupClosing(() -> control.onBrowse("resourcepacks"), browsePopup)), new IconedMenuItem(null, I18n.i18n("folder.screenshots"), FXUtils.withJFXPopupClosing(() -> control.onBrowse("screenshots"), browsePopup)), new IconedMenuItem(null, I18n.i18n("folder.saves"), FXUtils.withJFXPopupClosing(() -> control.onBrowse("saves"), browsePopup))});
            PopupMenu managementList = new PopupMenu();
            JFXPopup managementPopup = new JFXPopup((Region)managementList);
            Object[] objectArray = new Node[11];
            objectArray[0] = new IconedMenuItem(FXUtils.limitingSize(SVG.launch(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("version.launch.test"), FXUtils.withJFXPopupClosing(() -> control.testGame(), managementPopup));
            objectArray[1] = new IconedMenuItem(FXUtils.limitingSize(SVG.script(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("version.launch_script"), FXUtils.withJFXPopupClosing(() -> control.generateLaunchScript(), managementPopup));
            objectArray[2] = new MenuSeparator();
            objectArray[3] = new IconedMenuItem(FXUtils.limitingSize(SVG.pencil(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("version.manage.rename"), FXUtils.withJFXPopupClosing(() -> control.rename(), managementPopup));
            objectArray[4] = new IconedMenuItem(FXUtils.limitingSize(SVG.copy(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("version.manage.duplicate"), FXUtils.withJFXPopupClosing(() -> control.duplicate(), managementPopup));
            objectArray[5] = new IconedMenuItem(FXUtils.limitingSize(SVG.delete(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("version.manage.remove"), FXUtils.withJFXPopupClosing(() -> control.remove(), managementPopup));
            objectArray[6] = new IconedMenuItem(FXUtils.limitingSize(SVG.export(Theme.blackFillBinding(), 14.0, 14.0), 14.0, 14.0), I18n.i18n("modpack.export"), FXUtils.withJFXPopupClosing(() -> control.export(), managementPopup));
            objectArray[7] = new MenuSeparator();
            objectArray[8] = new IconedMenuItem(null, I18n.i18n("version.manage.redownload_assets_index"), FXUtils.withJFXPopupClosing(() -> control.redownloadAssetIndex(), managementPopup));
            objectArray[9] = new IconedMenuItem(null, I18n.i18n("version.manage.remove_libraries"), FXUtils.withJFXPopupClosing(() -> control.clearLibraries(), managementPopup));
            objectArray[10] = new IconedMenuItem(null, I18n.i18n("version.manage.clean"), FXUtils.withJFXPopupClosing(() -> control.clearJunkFiles(), managementPopup)).addTooltip(I18n.i18n("version.manage.clean.tooltip"));
            managementList.getContent().setAll(objectArray);
            JFXButton upgradeButton = new JFXButton();
            upgradeButton.setGraphic(SVG.update(null, 20.0, 20.0));
            upgradeButton.getStyleClass().add((Object)"jfx-decorator-button");
            upgradeButton.ripplerFillProperty().bind(Theme.whiteFillBinding());
            upgradeButton.setOnAction(event -> control.updateGame());
            upgradeButton.visibleProperty().bind((ObservableValue)control.currentVersionUpgradable);
            FXUtils.installFastTooltip((Node)upgradeButton, I18n.i18n("version.update"));
            JFXButton testGameButton = new JFXButton();
            testGameButton.setGraphic(SVG.launch(null, 20.0, 20.0));
            testGameButton.getStyleClass().add((Object)"jfx-decorator-button");
            testGameButton.ripplerFillProperty().bind(Theme.whiteFillBinding());
            testGameButton.setOnAction(event -> control.testGame());
            FXUtils.installFastTooltip((Node)testGameButton, I18n.i18n("version.launch.test"));
            JFXButton browseMenuButton = new JFXButton();
            browseMenuButton.setGraphic(SVG.folderOpen(null, 20.0, 20.0));
            browseMenuButton.getStyleClass().add((Object)"jfx-decorator-button");
            browseMenuButton.ripplerFillProperty().bind(Theme.whiteFillBinding());
            browseMenuButton.setOnAction(event -> browsePopup.show((Node)browseMenuButton, JFXPopup.PopupVPosition.TOP, JFXPopup.PopupHPosition.RIGHT, 0.0, browseMenuButton.getHeight()));
            FXUtils.installFastTooltip((Node)browseMenuButton, I18n.i18n("settings.game.exploration"));
            JFXButton managementMenuButton = new JFXButton();
            FXUtils.setLimitWidth((Region)managementMenuButton, 40.0);
            FXUtils.setLimitHeight((Region)managementMenuButton, 40.0);
            managementMenuButton.setGraphic(SVG.wrench(null, 20.0, 20.0));
            managementMenuButton.getStyleClass().add((Object)"jfx-decorator-button");
            managementMenuButton.ripplerFillProperty().bind(Theme.whiteFillBinding());
            managementMenuButton.setOnAction(event -> managementPopup.show((Node)managementMenuButton, JFXPopup.PopupVPosition.TOP, JFXPopup.PopupHPosition.RIGHT, 0.0, managementMenuButton.getHeight()));
            FXUtils.installFastTooltip((Node)managementMenuButton, I18n.i18n("settings.game.management"));
            toolBar.getChildren().setAll((Object[])new Node[]{upgradeButton, testGameButton, browseMenuButton, managementMenuButton});
            BorderPane titleBar = new BorderPane();
            titleBar.setLeft((Node)tabPane);
            titleBar.setRight((Node)toolBar);
            control.state.set((Object)new DecoratorPage.State(I18n.i18n("version.manage.manage"), (Node)titleBar, true, false, true, false, 200.0));
            root.setCenter((Node)control.transitionPane);
            spinnerPane.loadingProperty().bind((ObservableValue)control.loading);
            spinnerPane.setContent((Node)root);
            this.getChildren().setAll((Object[])new Node[]{spinnerPane});
        }
    }
}

