/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.JFXToggleButton;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Toggle;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.GameDirectoryType;
import org.jackhuang.hmcl.setting.LauncherVisibility;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.ImagePickerItem;
import org.jackhuang.hmcl.ui.construct.MultiFileItem;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class VersionSettingsPage
extends StackPane
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)new DecoratorPage.State("", null, false, false, false));
    private VersionSetting lastVersionSetting = null;
    private Profile profile;
    private String versionId;
    private boolean javaItemsLoaded;
    @FXML
    private VBox rootPane;
    @FXML
    private ScrollPane scroll;
    @FXML
    private JFXTextField txtWidth;
    @FXML
    private JFXTextField txtHeight;
    @FXML
    private JFXTextField txtMaxMemory;
    @FXML
    private JFXTextField txtJVMArgs;
    @FXML
    private JFXTextField txtGameArgs;
    @FXML
    private JFXTextField txtMetaspace;
    @FXML
    private JFXTextField txtWrapper;
    @FXML
    private JFXTextField txtPrecallingCommand;
    @FXML
    private JFXTextField txtServerIP;
    @FXML
    private ComponentList advancedSettingsPane;
    @FXML
    private ComponentList componentList;
    @FXML
    private ComponentList iconPickerItemWrapper;
    @FXML
    private JFXComboBox<LauncherVisibility> cboLauncherVisibility;
    @FXML
    private JFXCheckBox chkFullscreen;
    @FXML
    private Label lblPhysicalMemory;
    @FXML
    private JFXToggleButton chkNoJVMArgs;
    @FXML
    private JFXToggleButton chkNoGameCheck;
    @FXML
    private JFXToggleButton chkNoJVMCheck;
    @FXML
    private MultiFileItem<JavaVersion> javaItem;
    @FXML
    private MultiFileItem<GameDirectoryType> gameDirItem;
    @FXML
    private JFXToggleButton chkShowLogs;
    @FXML
    private ImagePickerItem iconPickerItem;
    @FXML
    private JFXCheckBox chkEnableSpecificSettings;
    @FXML
    private BorderPane settingsTypePane;
    private InvalidationListener specificSettingsListener = any -> this.chkEnableSpecificSettings.setSelected(!this.lastVersionSetting.isUsesGlobal());
    private InvalidationListener javaListener = any -> this.initJavaSubtitle();

    public VersionSettingsPage() {
        FXUtils.loadFXML((Node)this, "/assets/fxml/version/version-settings.fxml");
        this.addEventHandler(Navigator.NavigationEvent.NAVIGATED, this::onDecoratorPageNavigating);
        this.cboLauncherVisibility.getItems().setAll((Object[])LauncherVisibility.values());
        this.cboLauncherVisibility.setConverter(FXUtils.stringConverter(e -> I18n.i18n("settings.advanced.launcher_visibility." + e.name().toLowerCase())));
    }

    @FXML
    private void initialize() {
        this.lblPhysicalMemory.setText(I18n.i18n("settings.physical_memory") + ": " + OperatingSystem.TOTAL_MEMORY + "MB");
        FXUtils.smoothScrolling(this.scroll);
        Task.supplyAsync(JavaVersion::getJavas).thenAcceptAsync(Schedulers.javafx(), list -> {
            this.javaItem.loadChildren(list.stream().map(javaVersion -> this.javaItem.createChildren(javaVersion.getVersion() + I18n.i18n("settings.game.java_directory.bit", javaVersion.getPlatform().getBit()), javaVersion.getBinary().toString(), (JavaVersion)javaVersion)).collect(Collectors.toList()));
            this.javaItemsLoaded = true;
            this.initializeSelectedJava();
        }).start();
        this.javaItem.setSelectedData(null);
        this.javaItem.setFallbackData(JavaVersion.fromCurrentEnvironment());
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            this.javaItem.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Java", new String[]{"java.exe", "javaw.exe"}));
        }
        this.gameDirItem.setCustomUserData(GameDirectoryType.CUSTOM);
        this.gameDirItem.loadChildren(Arrays.asList(this.gameDirItem.createChildren(I18n.i18n("settings.advanced.game_dir.default"), GameDirectoryType.ROOT_FOLDER), this.gameDirItem.createChildren(I18n.i18n("settings.advanced.game_dir.independent"), GameDirectoryType.VERSION_FOLDER)));
        this.chkEnableSpecificSettings.selectedProperty().addListener((a, b, newValue) -> {
            if (this.versionId == null) {
                return;
            }
            if (newValue.booleanValue()) {
                this.profile.getRepository().specializeVersionSetting(this.versionId);
            } else {
                this.profile.getRepository().globalizeVersionSetting(this.versionId);
            }
            Platform.runLater(() -> this.loadVersion(this.profile, this.versionId));
        });
        this.componentList.disableProperty().bind((ObservableValue)this.chkEnableSpecificSettings.selectedProperty().not());
        this.advancedSettingsPane.disableProperty().bind((ObservableValue)this.chkEnableSpecificSettings.selectedProperty().not());
    }

    public void loadVersion(Profile profile, String versionId) {
        this.profile = profile;
        this.versionId = versionId;
        if (versionId == null) {
            this.rootPane.getChildren().remove((Object)this.iconPickerItemWrapper);
            this.rootPane.getChildren().remove((Object)this.settingsTypePane);
            this.chkEnableSpecificSettings.setSelected(true);
            this.state.set((Object)DecoratorPage.State.fromTitle(Profiles.getProfileDisplayName(profile) + " - " + I18n.i18n("settings.type.global.manage")));
        }
        VersionSetting versionSetting = profile.getVersionSetting(versionId);
        this.gameDirItem.setDisable(versionId != null && profile.getRepository().isModpack(versionId));
        this.settingsTypePane.setDisable(versionId != null && profile.getRepository().isModpack(versionId));
        if (this.lastVersionSetting != null) {
            FXUtils.unbindInt(this.txtWidth, (Property<Number>)this.lastVersionSetting.widthProperty());
            FXUtils.unbindInt(this.txtHeight, (Property<Number>)this.lastVersionSetting.heightProperty());
            FXUtils.unbindInt(this.txtMaxMemory, (Property<Number>)this.lastVersionSetting.maxMemoryProperty());
            FXUtils.unbindString(this.javaItem.getTxtCustom(), (Property<String>)this.lastVersionSetting.javaDirProperty());
            FXUtils.unbindString(this.gameDirItem.getTxtCustom(), (Property<String>)this.lastVersionSetting.gameDirProperty());
            FXUtils.unbindString(this.txtJVMArgs, (Property<String>)this.lastVersionSetting.javaArgsProperty());
            FXUtils.unbindString(this.txtGameArgs, (Property<String>)this.lastVersionSetting.minecraftArgsProperty());
            FXUtils.unbindString(this.txtMetaspace, (Property<String>)this.lastVersionSetting.permSizeProperty());
            FXUtils.unbindString(this.txtWrapper, (Property<String>)this.lastVersionSetting.wrapperProperty());
            FXUtils.unbindString(this.txtPrecallingCommand, (Property<String>)this.lastVersionSetting.preLaunchCommandProperty());
            FXUtils.unbindString(this.txtServerIP, (Property<String>)this.lastVersionSetting.serverIpProperty());
            FXUtils.unbindBoolean(this.chkFullscreen, (Property<Boolean>)this.lastVersionSetting.fullscreenProperty());
            FXUtils.unbindBoolean(this.chkNoGameCheck, (Property<Boolean>)this.lastVersionSetting.notCheckGameProperty());
            FXUtils.unbindBoolean(this.chkNoJVMCheck, (Property<Boolean>)this.lastVersionSetting.notCheckJVMProperty());
            FXUtils.unbindBoolean(this.chkNoJVMArgs, (Property<Boolean>)this.lastVersionSetting.noJVMArgsProperty());
            FXUtils.unbindBoolean(this.chkShowLogs, (Property<Boolean>)this.lastVersionSetting.showLogsProperty());
            FXUtils.unbindEnum(this.cboLauncherVisibility);
            this.lastVersionSetting.usesGlobalProperty().removeListener(this.specificSettingsListener);
            this.lastVersionSetting.javaDirProperty().removeListener(this.javaListener);
            this.lastVersionSetting.javaProperty().removeListener(this.javaListener);
            this.gameDirItem.selectedDataProperty().unbindBidirectional(this.lastVersionSetting.gameDirTypeProperty());
            this.gameDirItem.subtitleProperty().unbind();
        }
        this.javaItem.setToggleSelectedListener(null);
        FXUtils.bindInt(this.txtWidth, (Property<Number>)versionSetting.widthProperty());
        FXUtils.bindInt(this.txtHeight, (Property<Number>)versionSetting.heightProperty());
        FXUtils.bindInt(this.txtMaxMemory, (Property<Number>)versionSetting.maxMemoryProperty());
        FXUtils.bindString(this.javaItem.getTxtCustom(), (Property<String>)versionSetting.javaDirProperty());
        FXUtils.bindString(this.gameDirItem.getTxtCustom(), (Property<String>)versionSetting.gameDirProperty());
        FXUtils.bindString(this.txtJVMArgs, (Property<String>)versionSetting.javaArgsProperty());
        FXUtils.bindString(this.txtGameArgs, (Property<String>)versionSetting.minecraftArgsProperty());
        FXUtils.bindString(this.txtMetaspace, (Property<String>)versionSetting.permSizeProperty());
        FXUtils.bindString(this.txtWrapper, (Property<String>)versionSetting.wrapperProperty());
        FXUtils.bindString(this.txtPrecallingCommand, (Property<String>)versionSetting.preLaunchCommandProperty());
        FXUtils.bindString(this.txtServerIP, (Property<String>)versionSetting.serverIpProperty());
        FXUtils.bindBoolean(this.chkFullscreen, (Property<Boolean>)versionSetting.fullscreenProperty());
        FXUtils.bindBoolean(this.chkNoGameCheck, (Property<Boolean>)versionSetting.notCheckGameProperty());
        FXUtils.bindBoolean(this.chkNoJVMCheck, (Property<Boolean>)versionSetting.notCheckJVMProperty());
        FXUtils.bindBoolean(this.chkNoJVMArgs, (Property<Boolean>)versionSetting.noJVMArgsProperty());
        FXUtils.bindBoolean(this.chkShowLogs, (Property<Boolean>)versionSetting.showLogsProperty());
        FXUtils.bindEnum(this.cboLauncherVisibility, versionSetting.launcherVisibilityProperty());
        versionSetting.usesGlobalProperty().addListener(this.specificSettingsListener);
        if (versionId != null) {
            this.chkEnableSpecificSettings.setSelected(!versionSetting.isUsesGlobal());
        }
        this.javaItem.setToggleSelectedListener(newValue -> {
            if (this.javaItem.isCustomToggle((Toggle)newValue)) {
                versionSetting.setUsesCustomJavaDir();
            } else {
                versionSetting.setJavaVersion((JavaVersion)newValue.getUserData());
            }
        });
        versionSetting.javaDirProperty().addListener(this.javaListener);
        versionSetting.javaProperty().addListener(this.javaListener);
        this.gameDirItem.selectedDataProperty().bindBidirectional(versionSetting.gameDirTypeProperty());
        this.gameDirItem.subtitleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> Paths.get(profile.getRepository().getRunDirectory(versionId).getAbsolutePath(), new String[0]).normalize().toString(), (Observable[])new Observable[]{versionSetting.gameDirProperty(), versionSetting.gameDirTypeProperty()}));
        this.lastVersionSetting = versionSetting;
        this.initializeSelectedJava();
        this.initJavaSubtitle();
        this.loadIcon();
    }

    private void initializeSelectedJava() {
        if (this.lastVersionSetting == null || !this.javaItemsLoaded) {
            return;
        }
        if (this.lastVersionSetting.isUsesCustomJavaDir()) {
            this.javaItem.getGroup().getToggles().stream().filter(this.javaItem::isCustomToggle).findFirst().get().setSelected(true);
        } else {
            try {
                this.javaItem.setSelectedData(this.lastVersionSetting.getJavaVersion());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void initJavaSubtitle() {
        VersionSetting versionSetting = this.lastVersionSetting;
        if (versionSetting == null) {
            return;
        }
        Task.supplyAsync(versionSetting::getJavaVersion).thenAcceptAsync(Schedulers.javafx(), javaVersion -> this.javaItem.setSubtitle(Optional.ofNullable(javaVersion).map(JavaVersion::getBinary).map(Path::toString).orElse("Invalid Java Path"))).start();
    }

    @FXML
    private void editGlobalSettings() {
        Versions.modifyGlobalSettings(this.profile);
    }

    @FXML
    private void onExploreIcon() {
        if (this.versionId == null) {
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("extension.png"), new String[]{"*.png"}));
        File selectedFile = chooser.showOpenDialog((Window)Controllers.getStage());
        if (selectedFile != null) {
            File iconFile = this.profile.getRepository().getVersionIconFile(this.versionId);
            try {
                FileUtils.copyFile(selectedFile, iconFile);
                this.loadIcon();
            }
            catch (IOException e) {
                Logging.LOG.log(Level.SEVERE, "Failed to copy icon file from " + selectedFile + " to " + iconFile, e);
            }
        }
    }

    @FXML
    private void onDeleteIcon() {
        if (this.versionId == null) {
            return;
        }
        File iconFile = this.profile.getRepository().getVersionIconFile(this.versionId);
        if (iconFile.exists()) {
            iconFile.delete();
        }
        this.loadIcon();
    }

    private void loadIcon() {
        if (this.versionId == null) {
            this.iconPickerItem.setImage(FXUtils.newImage("/assets/img/grass.png"));
            return;
        }
        File iconFile = this.profile.getRepository().getVersionIconFile(this.versionId);
        if (iconFile.exists()) {
            this.iconPickerItem.setImage(new Image("file:" + iconFile.getAbsolutePath()));
        } else {
            this.iconPickerItem.setImage(FXUtils.newImage("/assets/img/grass.png"));
        }
        FXUtils.limitSize(this.iconPickerItem.getImageView(), 32.0, 32.0);
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }
}

