/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.upgrade;

import java.io.IOException;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.upgrade.IntegrityChecker;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.upgrade.UpdateChannel;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class UpdateChecker {
    private static ObjectProperty<RemoteVersion> latestVersion = new SimpleObjectProperty();
    private static BooleanBinding outdated = Bindings.createBooleanBinding(() -> {
        RemoteVersion latest = (RemoteVersion)latestVersion.get();
        if (latest == null || UpdateChecker.isDevelopmentVersion(Metadata.VERSION)) {
            return false;
        }
        return VersionNumber.asVersion(latest.getVersion()).compareTo(VersionNumber.asVersion(Metadata.VERSION)) > 0;
    }, (Observable[])new Observable[]{latestVersion});
    private static ReadOnlyBooleanWrapper checkingUpdate = new ReadOnlyBooleanWrapper(false);

    private UpdateChecker() {
    }

    public static void init() {
        ConfigHolder.config().updateChannelProperty().addListener(FXUtils.onInvalidating(UpdateChecker::requestCheckUpdate));
        UpdateChecker.requestCheckUpdate();
    }

    public static RemoteVersion getLatestVersion() {
        return (RemoteVersion)latestVersion.get();
    }

    public static ReadOnlyObjectProperty<RemoteVersion> latestVersionProperty() {
        return latestVersion;
    }

    public static boolean isOutdated() {
        return outdated.get();
    }

    public static ObservableBooleanValue outdatedProperty() {
        return outdated;
    }

    public static boolean isCheckingUpdate() {
        return checkingUpdate.get();
    }

    public static ReadOnlyBooleanProperty checkingUpdateProperty() {
        return checkingUpdate.getReadOnlyProperty();
    }

    private static RemoteVersion checkUpdate(UpdateChannel channel) throws IOException {
        if (!IntegrityChecker.isSelfVerified() && !"true".equals(System.getProperty("hmcl.self_integrity_check.disable"))) {
            throw new IOException("Self verification failed");
        }
        String url = NetworkUtils.withQuery(Metadata.UPDATE_URL, Lang.mapOf(Pair.pair("version", Metadata.VERSION), Pair.pair("channel", channel.channelName)));
        return RemoteVersion.fetch(url);
    }

    private static boolean isDevelopmentVersion(String version) {
        return version.contains("@") || version.contains("SNAPSHOT");
    }

    public static void requestCheckUpdate() {
        Platform.runLater(() -> {
            if (UpdateChecker.isCheckingUpdate()) {
                return;
            }
            checkingUpdate.set(true);
            UpdateChannel channel = ConfigHolder.config().getUpdateChannel();
            Lang.thread(() -> {
                RemoteVersion result = null;
                try {
                    result = UpdateChecker.checkUpdate(channel);
                    Logging.LOG.info("Latest version (" + (Object)((Object)channel) + ") is " + result);
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to check for update", e);
                }
                RemoteVersion finalResult = result;
                Platform.runLater(() -> {
                    checkingUpdate.set(false);
                    if (finalResult != null) {
                        if (channel.equals((Object)ConfigHolder.config().getUpdateChannel())) {
                            latestVersion.set((Object)finalResult);
                        } else {
                            UpdateChecker.requestCheckUpdate();
                        }
                    }
                });
            }, "Update Checker", true);
        });
    }
}

