/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.function.ExceptionalRunnable;
import org.jackhuang.hmcl.util.function.ExceptionalSupplier;

public final class Lang {
    public static final Function<Throwable, Void> handleUncaught = e -> {
        Lang.handleUncaughtException(e);
        return null;
    };

    private Lang() {
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mapOf(Pair<K, V> ... pairs) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (Pair<K, V> pair : pairs) {
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    @SafeVarargs
    public static <T> List<T> immutableListOf(T ... elements) {
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    public static <T extends Comparable<T>> T clamp(T min, T val, T max) {
        if (val.compareTo(min) < 0) {
            return min;
        }
        if (val.compareTo(max) > 0) {
            return max;
        }
        return val;
    }

    public static double clamp(double min, double val, double max) {
        return Math.max(min, Math.min(val, max));
    }

    public static int clamp(int min, int val, int max) {
        return Math.max(min, Math.min(val, max));
    }

    public static boolean test(ExceptionalRunnable<?> r) {
        try {
            r.run();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <E extends Exception> boolean test(ExceptionalSupplier<Boolean, E> r) {
        try {
            return r.get();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> T ignoringException(ExceptionalSupplier<T, ?> supplier) {
        return Lang.ignoringException(supplier, null);
    }

    public static <T> T ignoringException(ExceptionalSupplier<T, ?> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (Exception ignore) {
            return defaultValue;
        }
    }

    public static <V> Optional<V> tryCast(Object obj, Class<V> clazz) {
        if (clazz.isInstance(obj)) {
            return Optional.of(clazz.cast(obj));
        }
        return Optional.empty();
    }

    public static <T> T getOrDefault(List<T> a, int index, T defaultValue) {
        return index < 0 || index >= a.size() ? defaultValue : a.get(index);
    }

    public static <T> T merge(T a, T b, BinaryOperator<T> operator) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return (T)operator.apply(a, b);
    }

    public static <T> List<T> removingDuplicates(List<T> list) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return new ArrayList(set);
    }

    public static <T> List<T> merge(Collection<? extends T> a, Collection<? extends T> b) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (a != null) {
            result.addAll(a);
        }
        if (b != null) {
            result.addAll(b);
        }
        return result;
    }

    public static <T> List<T> copyList(List<T> list) {
        return list == null ? null : (list.isEmpty() ? null : new ArrayList<T>(list));
    }

    public static void executeDelayed(Runnable runnable, TimeUnit timeUnit, long timeout, boolean isDaemon) {
        Lang.thread(() -> {
            try {
                timeUnit.sleep(timeout);
                runnable.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }, null, isDaemon);
    }

    public static Thread thread(Runnable runnable) {
        return Lang.thread(runnable, null);
    }

    public static Thread thread(Runnable runnable, String name) {
        return Lang.thread(runnable, name, false);
    }

    public static Thread thread(Runnable runnable, String name, boolean isDaemon) {
        Thread thread = new Thread(runnable);
        if (isDaemon) {
            thread.setDaemon(true);
        }
        if (name != null) {
            thread.setName(name);
        }
        thread.start();
        return thread;
    }

    public static ThreadPoolExecutor threadPool(String name, boolean daemon, int threads, long timeout, TimeUnit timeunit) {
        AtomicInteger counter = new AtomicInteger(1);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(threads, threads, timeout, timeunit, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread t = new Thread(r, name + "-" + counter.getAndIncrement());
            t.setDaemon(daemon);
            return t;
        });
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    public static int parseInt(Object string, int defaultValue) {
        try {
            return Integer.parseInt(string.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Integer toIntOrNull(Object string) {
        try {
            if (string == null) {
                return null;
            }
            return Integer.parseInt(string.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @SafeVarargs
    public static <T> T nonNull(T ... t) {
        for (T a : t) {
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public static <T> T apply(T t, Consumer<T> consumer) {
        consumer.accept(t);
        return t;
    }

    public static void handleUncaughtException(Throwable e) {
        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
    }
}

