/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public final class Logging {
    public static final Logger LOG = Logger.getLogger("HMCL");
    private static ByteArrayOutputStream storedLogs = new ByteArrayOutputStream();

    public static void start(Path logFolder) {
        LOG.setLevel(Level.ALL);
        LOG.setUseParentHandlers(false);
        try {
            Files.createDirectories(logFolder, new FileAttribute[0]);
            FileHandler fileHandler = new FileHandler(logFolder.resolve("hmcl.log").toAbsolutePath().toString());
            fileHandler.setLevel(Level.FINEST);
            fileHandler.setFormatter(DefaultFormatter.INSTANCE);
            LOG.addHandler(fileHandler);
        }
        catch (IOException e) {
            System.err.println("Unable to create hmcl.log, " + e.getMessage());
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(DefaultFormatter.INSTANCE);
        consoleHandler.setLevel(Level.FINER);
        LOG.addHandler(consoleHandler);
        StreamHandler streamHandler = new StreamHandler(storedLogs, DefaultFormatter.INSTANCE){

            @Override
            public synchronized void publish(LogRecord record) {
                super.publish(record);
                this.flush();
            }
        };
        streamHandler.setLevel(Level.ALL);
        LOG.addHandler(streamHandler);
    }

    public static byte[] getRawLogs() {
        return storedLogs.toByteArray();
    }

    public static String getLogs() {
        return storedLogs.toString();
    }

    private static final class DefaultFormatter
    extends Formatter {
        static final DefaultFormatter INSTANCE = new DefaultFormatter();
        private final SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");

        private DefaultFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String date = this.format.format(new Date(record.getMillis()));
            String log = String.format("[%s] [%s.%s/%s] %s%n", date, record.getSourceClassName(), record.getSourceMethodName(), record.getLevel().getName(), record.getMessage());
            ByteArrayOutputStream builder = new ByteArrayOutputStream();
            if (record.getThrown() != null) {
                try (PrintWriter writer = new PrintWriter(builder);){
                    record.getThrown().printStackTrace(writer);
                }
            }
            return log + builder.toString();
        }
    }
}

