/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.Locales;

public final class I18n {
    private I18n() {
    }

    public static Locales.SupportedLocale getCurrentLocale() {
        try {
            return ConfigHolder.config().getLocalization();
        }
        catch (IllegalStateException e) {
            return Locales.DEFAULT;
        }
    }

    public static ResourceBundle getResourceBundle() {
        return I18n.getCurrentLocale().getResourceBundle();
    }

    public static String i18n(String key, Object ... formatArgs) {
        return String.format(I18n.i18n(key), formatArgs);
    }

    public static String i18n(String key) {
        try {
            return I18n.getResourceBundle().getString(key);
        }
        catch (MissingResourceException e) {
            Logging.LOG.log(Level.SEVERE, "Cannot find key " + key + " in resource bundle", e);
            return key;
        }
    }

    public static boolean hasKey(String key) {
        try {
            I18n.getResourceBundle().getString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }
}

