/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jackhuang.hmcl.util.function.ExceptionalBiConsumer;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public abstract class HttpRequest {
    protected final URL url;
    protected final String method;
    protected final Map<String, String> headers = new HashMap<String, String>();
    protected ExceptionalBiConsumer<URL, Integer, IOException> responseCodeTester;

    private HttpRequest(URL url, String method) {
        this.url = url;
        this.method = method;
    }

    public HttpRequest accept(String contentType) {
        return this.header("Accept", contentType);
    }

    public HttpRequest authorization(String token) {
        return this.header("Authorization", token);
    }

    public HttpRequest contentType(String contentType) {
        return this.header("Content-Type", contentType);
    }

    public HttpRequest header(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public abstract String getString() throws IOException;

    public <T> T getJson(Class<T> typeOfT) throws IOException, JsonParseException {
        return JsonUtils.fromNonNullJson(this.getString(), typeOfT);
    }

    public HttpRequest filter(ExceptionalBiConsumer<URL, Integer, IOException> responseCodeTester) {
        this.responseCodeTester = responseCodeTester;
        return this;
    }

    protected HttpURLConnection createConnection() throws IOException {
        HttpURLConnection con = NetworkUtils.createHttpConnection(this.url);
        con.setRequestMethod(this.method);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            con.setRequestProperty(entry.getKey(), entry.getValue());
        }
        return con;
    }

    public static HttpGetRequest GET(String url) throws MalformedURLException {
        return HttpRequest.GET(new URL(url));
    }

    public static HttpGetRequest GET(URL url) {
        return new HttpGetRequest(url);
    }

    public static HttpPostRequest POST(String url) throws MalformedURLException {
        return HttpRequest.POST(new URL(url));
    }

    public static HttpPostRequest POST(URL url) {
        return new HttpPostRequest(url);
    }

    public static class HttpGetRequest
    extends HttpRequest {
        public HttpGetRequest(URL url) {
            super(url, "GET");
        }

        @Override
        public String getString() throws IOException {
            HttpURLConnection con = this.createConnection();
            con = NetworkUtils.resolveConnection(con);
            return IOUtils.readFullyAsString(con.getInputStream());
        }
    }

    public static class HttpPostRequest
    extends HttpRequest {
        private byte[] bytes;

        public HttpPostRequest(URL url) {
            super(url, "POST");
        }

        public <T> HttpPostRequest json(Object payload) throws JsonParseException {
            return this.string(payload instanceof String ? (String)payload : JsonUtils.GSON.toJson(payload), "application/json");
        }

        public HttpPostRequest form(Map<String, String> params) {
            return this.string(NetworkUtils.withQuery("", params), "application/x-www-form-urlencoded");
        }

        public HttpPostRequest string(String payload, String contentType) {
            this.bytes = payload.getBytes(StandardCharsets.UTF_8);
            this.header("Content-Length", "" + this.bytes.length);
            this.contentType(contentType + "; charset=utf-8");
            return this;
        }

        @Override
        public String getString() throws IOException {
            HttpURLConnection con = this.createConnection();
            con.setDoOutput(true);
            if (this.responseCodeTester != null) {
                this.responseCodeTester.accept(this.url, con.getResponseCode());
            }
            try (OutputStream os = con.getOutputStream();){
                os.write(this.bytes);
            }
            return NetworkUtils.readData(con);
        }
    }
}

