/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public class Unzipper {
    private final Path zipFile;
    private final Path dest;
    private boolean replaceExistentFile = false;
    private boolean terminateIfSubDirectoryNotExists = false;
    private String subDirectory = "/";
    private FileFilter filter = null;
    private Charset encoding = StandardCharsets.UTF_8;

    public Unzipper(Path zipFile, Path destDir) {
        this.zipFile = zipFile;
        this.dest = destDir;
    }

    public Unzipper(File zipFile, File destDir) {
        this(zipFile.toPath(), destDir.toPath());
    }

    public Unzipper setReplaceExistentFile(boolean replaceExistentFile) {
        this.replaceExistentFile = replaceExistentFile;
        return this;
    }

    public Unzipper setFilter(FileFilter filter) {
        this.filter = filter;
        return this;
    }

    public Unzipper setSubDirectory(String subDirectory) {
        this.subDirectory = FileUtils.normalizePath(subDirectory);
        return this;
    }

    public Unzipper setEncoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public Unzipper setTerminateIfSubDirectoryNotExists() {
        this.terminateIfSubDirectoryNotExists = true;
        return this;
    }

    public void unzip() throws IOException {
        Files.createDirectories(this.dest, new FileAttribute[0]);
        try (FileSystem fs = CompressingUtils.readonly(this.zipFile).setEncoding(this.encoding).setAutoDetectEncoding(true).build();){
            final Path root = fs.getPath(this.subDirectory, new String[0]);
            if (!root.isAbsolute() || this.subDirectory.length() > 1 && this.subDirectory.endsWith("/")) {
                throw new IllegalArgumentException("Subdirectory for unzipper must be absolute");
            }
            if (this.terminateIfSubDirectoryNotExists && Files.notExists(root, new LinkOption[0])) {
                return;
            }
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    block5: {
                        String relativePath = root.relativize(file).toString();
                        Path destFile = Unzipper.this.dest.resolve(relativePath);
                        if (Unzipper.this.filter != null && !Unzipper.this.filter.accept(file, false, destFile, relativePath)) {
                            return FileVisitResult.CONTINUE;
                        }
                        try {
                            CopyOption[] copyOptionArray;
                            if (Unzipper.this.replaceExistentFile) {
                                CopyOption[] copyOptionArray2 = new CopyOption[1];
                                copyOptionArray = copyOptionArray2;
                                copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                            } else {
                                copyOptionArray = new CopyOption[]{};
                            }
                            Files.copy(file, destFile, copyOptionArray);
                        }
                        catch (FileAlreadyExistsException e) {
                            if (!Unzipper.this.replaceExistentFile) break block5;
                            throw e;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String relativePath = root.relativize(dir).toString();
                    Path dirToCreate = Unzipper.this.dest.resolve(relativePath);
                    if (Unzipper.this.filter != null && !Unzipper.this.filter.accept(dir, true, dirToCreate, relativePath)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    Files.createDirectories(dirToCreate, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static interface FileFilter {
        public boolean accept(Path var1, boolean var2, Path var3, String var4) throws IOException;
    }
}

