/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.jackhuang.hmcl.util.function.ExceptionalPredicate;
import org.jackhuang.hmcl.util.io.CompressingUtils;

public final class Zipper
implements Closeable {
    private final FileSystem fs;

    public Zipper(Path zipFile) throws IOException {
        this(zipFile, null);
    }

    public Zipper(Path zipFile, Charset encoding) throws IOException {
        Files.deleteIfExists(zipFile);
        this.fs = CompressingUtils.createWritableZipFileSystem(zipFile, encoding);
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
    }

    public void putDirectory(Path source, String rootDir) throws IOException {
        this.putDirectory(source, rootDir, null);
    }

    public void putDirectory(final Path source, String targetDir, final ExceptionalPredicate<String, IOException> filter) throws IOException {
        final Path root = this.fs.getPath(targetDir, new String[0]);
        Files.createDirectories(root, new FileAttribute[0]);
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (".DS_Store".equals(file.getFileName().toString())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                String relativePath = source.relativize(file).normalize().toString();
                if (filter != null && !filter.test(relativePath.replace('\\', '/'))) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Files.copy(file, root.resolve(relativePath), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String relativePath = source.relativize(dir).normalize().toString();
                if (filter != null && !filter.test(relativePath.replace('\\', '/'))) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path path = root.resolve(relativePath);
                if (Files.notExists(path, new LinkOption[0])) {
                    Files.createDirectory(path, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void putFile(File file, String path) throws IOException {
        this.putFile(file.toPath(), path);
    }

    public void putFile(Path file, String path) throws IOException {
        Files.copy(file, this.fs.getPath(path, new String[0]), new CopyOption[0]);
    }

    public void putStream(InputStream in, String path) throws IOException {
        Files.copy(in, this.fs.getPath(path, new String[0]), new CopyOption[0]);
    }

    public void putTextFile(String text, String path) throws IOException {
        this.putTextFile(text, "UTF-8", path);
    }

    public void putTextFile(String text, String encoding, String pathName) throws IOException {
        Files.write(this.fs.getPath(pathName, new String[0]), text.getBytes(encoding), new OpenOption[0]);
    }
}

