/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.javafx;

import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javafx.beans.binding.ObjectBinding;
import org.jackhuang.hmcl.util.function.ExceptionalFunction;
import org.jackhuang.hmcl.util.javafx.ObservableCache;

public class ObservableOptionalCache<K, V, E extends Exception> {
    private final ObservableCache<K, Optional<V>, E> backed;

    public ObservableOptionalCache(ExceptionalFunction<K, Optional<V>, E> source, BiConsumer<K, Throwable> exceptionHandler, Executor executor) {
        this.backed = new ObservableCache(source, exceptionHandler, Optional.empty(), executor);
    }

    public Optional<V> getImmediately(K key) {
        return this.backed.getImmediately(key).flatMap(it -> it);
    }

    public void put(K key, V value) {
        this.backed.put(key, Optional.of(value));
    }

    public Optional<V> get(K key) {
        return this.backed.get(key);
    }

    public Optional<V> getDirectly(K key) throws E {
        return this.backed.getDirectly(key);
    }

    public ObjectBinding<Optional<V>> binding(K key) {
        return this.backed.binding(key);
    }

    public ObjectBinding<Optional<V>> binding(K key, boolean quiet) {
        return this.backed.binding(key, quiet);
    }

    public void invalidate(K key) {
        this.backed.invalidate(key);
    }
}

