/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ManagedProcess {
    private final Process process;
    private final List<String> commands;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Queue<String> lines = new ConcurrentLinkedQueue<String>();
    private final List<Thread> relatedThreads = new LinkedList<Thread>();

    public ManagedProcess(Process process, List<String> commands) {
        this.process = process;
        this.commands = Collections.unmodifiableList(new ArrayList<String>(commands));
    }

    public Process getProcess() {
        return this.process;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Collection<String> getLines() {
        return Collections.unmodifiableCollection(this.lines);
    }

    public void addLine(String line) {
        this.lines.add(line);
    }

    public void addRelatedThread(Thread thread) {
        this.relatedThreads.add(thread);
    }

    public boolean isRunning() {
        try {
            this.process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public int getExitCode() {
        return this.process.exitValue();
    }

    public void stop() {
        this.process.destroy();
        this.relatedThreads.forEach(Thread::interrupt);
    }

    public String toString() {
        return "ManagedProcess[commands=" + this.commands + ", isRunning=" + this.isRunning() + "]";
    }
}

