/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.versioning;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Stack;
import org.jackhuang.hmcl.util.StringUtils;

public class VersionNumber
implements Comparable<VersionNumber> {
    private String value;
    private String canonical;
    private ListItem items;
    public static Comparator<String> VERSION_COMPARATOR = Comparator.comparing(VersionNumber::asVersion);

    public static VersionNumber asVersion(String version) {
        Objects.requireNonNull(version);
        return new VersionNumber(version);
    }

    public static String normalize(String str) {
        return new VersionNumber(str).getCanonical();
    }

    public static boolean isIntVersionNumber(String version) {
        if (version.chars().noneMatch(ch -> ch != 46 && (ch < 48 || ch > 57)) && !version.contains("..") && StringUtils.isNotBlank(version)) {
            String[] arr;
            for (String str : arr = version.split("\\.")) {
                if (str.length() <= 9) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public VersionNumber(String version) {
        this.parseVersion(version);
    }

    private void parseVersion(String version) {
        this.value = version;
        ListItem list = this.items = new ListItem();
        Stack<ListItem> stack = new Stack<ListItem>();
        stack.push(list);
        boolean isDigit = false;
        int startIndex = 0;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c == '.') {
                if (i == startIndex) {
                    list.add(IntegerItem.ZERO);
                } else {
                    list.add(VersionNumber.parseItem(version.substring(startIndex, i)));
                }
                startIndex = i + 1;
                continue;
            }
            if ("!\"#$%&'()*+,-/:;<=>?@[\\]^_`{|}~".indexOf(c) != -1) {
                if (i == startIndex) {
                    list.add(IntegerItem.ZERO);
                } else {
                    list.add(VersionNumber.parseItem(version.substring(startIndex, i)));
                }
                startIndex = i + 1;
                ListItem listItem = list;
                list = new ListItem(c);
                listItem.add(list);
                stack.push(list);
                continue;
            }
            if (Character.isDigit(c)) {
                if (!isDigit && i > startIndex) {
                    list.add(VersionNumber.parseItem(version.substring(startIndex, i)));
                    startIndex = i;
                    ListItem listItem = list;
                    list = new ListItem();
                    listItem.add(list);
                    stack.push(list);
                }
                isDigit = true;
                continue;
            }
            if (isDigit && i > startIndex) {
                list.add(VersionNumber.parseItem(version.substring(startIndex, i)));
                startIndex = i;
                ListItem listItem = list;
                list = new ListItem();
                listItem.add(list);
                stack.push(list);
            }
            isDigit = false;
        }
        if (version.length() > startIndex) {
            list.add(VersionNumber.parseItem(version.substring(startIndex)));
        }
        while (!stack.isEmpty()) {
            list = (ListItem)stack.pop();
            list.normalize();
        }
        this.canonical = this.items.toString();
    }

    private static Item parseItem(String buf) {
        return buf.chars().allMatch(Character::isDigit) ? new IntegerItem(buf) : new StringItem(buf);
    }

    @Override
    public int compareTo(VersionNumber o) {
        return this.items.compareTo(o.items);
    }

    public String toString() {
        return this.value;
    }

    public String getCanonical() {
        return this.canonical;
    }

    public boolean equals(Object o) {
        return o instanceof VersionNumber && this.canonical.equals(((VersionNumber)o).canonical);
    }

    public int hashCode() {
        return this.canonical.hashCode();
    }

    private static class IntegerItem
    implements Item {
        private final BigInteger value;
        public static final IntegerItem ZERO = new IntegerItem();

        private IntegerItem() {
            this.value = BigInteger.ZERO;
        }

        IntegerItem(String str) {
            this.value = new BigInteger(str);
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public boolean isNull() {
            return BigInteger.ZERO.equals(this.value);
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return BigInteger.ZERO.equals(this.value) ? 0 : 1;
            }
            switch (item.getType()) {
                case 0: {
                    return this.value.compareTo(((IntegerItem)item).value);
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
            }
            throw new RuntimeException("invalid item: " + item.getClass());
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static interface Item {
        public static final int INTEGER_ITEM = 0;
        public static final int STRING_ITEM = 1;
        public static final int LIST_ITEM = 2;

        public int compareTo(Item var1);

        public int getType();

        public boolean isNull();
    }

    private static class ListItem
    extends ArrayList<Item>
    implements Item {
        Character separator;

        public ListItem() {
        }

        public ListItem(char separator) {
            this.separator = Character.valueOf(separator);
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public boolean isNull() {
            return this.size() == 0;
        }

        void normalize() {
            for (int i = this.size() - 1; i >= 0; --i) {
                Item lastItem = (Item)this.get(i);
                if (lastItem.isNull()) {
                    this.remove(i);
                    continue;
                }
                if (!(lastItem instanceof ListItem)) break;
            }
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                if (this.size() == 0) {
                    return 0;
                }
                Item first = (Item)this.get(0);
                return first.compareTo(null);
            }
            switch (item.getType()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    Iterator left = this.iterator();
                    Iterator right = ((ListItem)item).iterator();
                    while (left.hasNext() || right.hasNext()) {
                        Item r;
                        Item l = left.hasNext() ? (Item)left.next() : null;
                        Item item2 = r = right.hasNext() ? (Item)right.next() : null;
                        int result = l == null ? (r == null ? 0 : -1 * r.compareTo(l)) : l.compareTo(r);
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
            }
            throw new RuntimeException("invalid item: " + item.getClass());
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            for (Item item : this) {
                if (buffer.length() > 0 && !(item instanceof ListItem)) {
                    buffer.append('.');
                }
                buffer.append(item);
            }
            if (this.separator != null) {
                return this.separator + buffer.toString();
            }
            return buffer.toString();
        }
    }

    private static class StringItem
    implements Item {
        private String value;

        StringItem(String value) {
            this.value = value;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean isNull() {
            return this.value.isEmpty();
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return 1;
            }
            switch (item.getType()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return this.value.compareTo(((StringItem)item).value);
                }
                case 2: {
                    return -1;
                }
            }
            throw new RuntimeException("invalid item: " + item.getClass());
        }

        public String toString() {
            return this.value;
        }
    }
}

