import crafttweaker.item.IIngredient;
import crafttweaker.item.IItemStack;
import mods.jei.JEI;

/*
 * Putting this here because aaaaaaa formatting.
 * Also, such a dense file needs to have proper formatting to be legible.
 * 
 * Syntax
 * * The item should not be enclosed in [] unless it is a list.
 * * The description should not be enclosed in [] unless it is meant to be separated by a line break, in which case use an extra "".
 * * Try to keep separate pages of descriptions close to each other in the file...
 * * Try to separate long descriptions onto separate pages where fit.
 * 
 * Spacing
 * * 2 lines between categories
 * * 1 line between groups within the category
 * 
 * Sorting
 * * PLEASE put descriptions in the correct category. As of this viewing, brick and wildberries are under BWM.
 * * Grouped by purpose or aesthetic
 * * Categorized by what you would normally organize your chests with, such as:
 * * - Ores
 * * - Ingots
 * * - Manufacturing
 * * - Plants
 * * - Food
 * * - Decorative blocks
 * * - Tools
 * * - Weapons
 * * - Armor
 * * - Redstone
 * * - etc.
 * 
 * Style
 * * Put categories in /* Category here *\/ (Ignore the \, merely for the comment)
 * * Follow Spacing guidelines
 * * PLEASE don't comment every single damn item...
 * * ...Unless the item's id is undescriptive (like <betterwithmods:material:39>)
 * * * In case of said undescriptiveness, make a val that has a more descriptive name
 * * * An example is under the pyrotech section (soon to be revamped)
 * * Try not to put lines between items... it increases the line count waaayyy too much
 * * Also try not to put lines between comments and the item
 * 
 * And that is my page long style guide...
 * Please follow it. - democat, the god
 */

/* Tools, Weapons, and Armor */
val handle = <spartanweaponry:material>;
val pole = <spartanweaponry:material:1>;

JEI.addDescription(handle,"让你能更好的抓住武器，这样似乎更称手");
JEI.addDescription(pole,"一寸长！一寸强！");

JEI.addDescription(<atop:mud_helmet>,"比铁更硬.....也，更冷。");
JEI.addDescription(<atop:mud_chestplate>,"这比光着膀子到处乱跑要好多了");
JEI.addDescription(<atop:mud_leggings>,"比铁硬，还很透气！");
JEI.addDescription(<atop:mud_boots>,"防护没那么好，但相当舒适和耐用。");
JEI.addDescription(<atop:mud_sword>,"一把标准的青铜剑。");
JEI.addDescription(<spartanshields:shield_basic_bronze>, "也被称为大圆盾。能在不牺牲进攻能力的情况下提供出色的防护。");

JEI.addDescription(<atop:tanzanite_helmet>,"在广阔森林的中心…");

JEI.addDescription(<betterwithmods:steel_pickaxe>,"能提供更快的挖矿速度和更高的耐久，但只能使用原版的附魔。");
JEI.addDescription(<betterwithmods:steel_mattock>,"更好的采矿工具。将镐和铲合并为一个工具，只能使用原版的附魔。");
JEI.addDescription(<betterwithmods:steel_axe>,"能提供更快的挖矿速度和更高的耐久，但只能使用原版的附魔。");
JEI.addDescription(<betterwithmods:steel_shovel>,"能提供更快的挖矿速度和更高的耐久，但只能使用原版的附魔。但只能使用原版的附魔。但只能使用原版的附魔。");
JEI.addDescription(<betterwithmods:steel_hoe>,"能提供更高的耐久，但只能使用原版的附魔。");
JEI.addDescription(<betterwithmods:steel_hacksaw>,"用这个钢锯右键一个方块来切割方块！");

JEI.addDescription([<betterwithaddons:steel_machete>],["一个多用途的工具。可以很快的清除蜘蛛网和藤曼，就像剪刀一样。会从你的背包中直接放置出藤曼。只能使用原版附魔"]);
JEI.addDescription([<betterwithaddons:steel_matchpick>],["一个多用途的工具。右键单击会直接放置火。如果你没有火把或者正在潜行，它会直接放置火把。（似乎是这样的）这对探索地狱很帮助。但只能使用原版的附魔。"]);
JEI.addDescription([<betterwithaddons:steel_spade>],["一种多功能工具，如果你挖掘了沙子或者泥土之类的方块，它们将会直接进入你的物品栏，当你使用这把工具右击的时候可以直接放出沙子和泥土。但只能使用原版的附魔。"]);
JEI.addDescription([<contenttweaker:steel_crowbar>],["一个可以瞬间破坏高硬度方块的工具，代价是消耗更多耐久。"]);
JEI.addDescription([<contenttweaker:sfs_masonpick>],["一把可以瞬间破坏高硬度方块的镐子，代价是消耗更多耐久。"]);
JEI.addDescription([<contenttweaker:mythril_masonpick>],["一把可以瞬间破坏高硬度方块的镐子，代价是消耗更多耐久。"]);
JEI.addDescription([<betterwithaddons:steel_kukri>],["一把多功能工具，可以瞬间采集木头或者树叶。手持次工具右击的时候可以放出你物品栏里的树苗，但只能使用原版的附魔。"]);
JEI.addDescription([<betterwithaddons:steel_carpentersaw>],["一把多功能工具，可以瞬间采集木头并存入物品栏，使用其右击时可以放置被加工的木制品，如木台阶，木楼梯等。但只能使用原版的附魔。"]);

JEI.addDescription(<pyrotech:bucket_wood>,"它撑不了太久的，也别想着用它装高温流体！");
JEI.addDescription(<pyrotech:bucket_stone>,"重要的是，金属桶虽然不会被熔岩所融化，但是会被其加热！那高温足以焚毁你的皮肤！熔岩可不和你开玩笑的！");
JEI.addDescription(<pyrotech:crude_fishing_rod>, "一根宛如朽木的钓鱼竿……每次使用都有概率直接损坏。");

JEI.addDescription(<quark:witch_hat>,"由魔法织物编织而成……戴着很舒服。而且戴着它就不会被那些该死的幽灵诅咒了。");
JEI.addDescription(<betterwithmods:ender_spectacles>,"当你凝视终末的时候，终末也在凝视着你[DISABLED]");
JEI.addDescription(<quark:archaeologist_hat>,"戴上它可以让你壮壮胆，并且更走运一些。更可能在一些拐弯抹角的地方找到文物并把它们存放到你的博物馆里。");
<quark:archaeologist_hat>.addTooltip("佩戴时，开采宝石类矿物时有小概率增产。");

JEI.addDescription(<mod_lavacow:bonesword>,"你绝对会使用这把剑撕碎你的敌人的————通过这把剑上那些尖锐的，嗜血的牙齿。记住一点：登得越高，摔得越狠。");
JEI.addDescription(<dungeontactics:sharp_stick>,"至少比玩具剑可靠一些……对于那些游荡于陌生土地上的流浪者而言。耐久很低，但胜在可堆叠。");
JEI.addDescription(<dungeontactics:golden_club>,'一把来自黑暗时代的，独具一格的“武器”；折磨那些来自下界的土著再合适不过了。有概率缴械你的敌人。');
JEI.addDescription(<dungeontactics:golden_battleaxe>,"用于处决那些罪犯，而其制作材料被认为是对这把武器的侮辱。");
JEI.addDescription(<trumpetskeleton:trumpet>,"无人可以掌握这股力量。");
JEI.addDescription(<dungeontactics:silver_sword>,"真.黑暗之锋是一把汇聚了堕落者无尽力量的，鲜活的刀刃。它通过折磨你的对手来获得力量。随着被它斩杀的敌人越来越多，它也会变得愈发强大。甚至可以无视那些凡俗的防御直击被害者的灵魂。");

JEI.addDescription(<pyrotech:matchstick>,"一个用普通材料制成的点火器，可以用于点燃窑，但是很明显不如打火石。");

JEI.addDescription(<toolbelt:belt>,"一种使用皮革与线编织而成的简单腰带，可以用于存放工具，佩戴腰带时，按住`（默认情况下是这个键位，可以改）即可打开腰带。你可以向里面放入或者拿出物品。正常情况下可以装两个。你可以通过在铁砧上使用皮带袋可以升级腰带，使其可以容纳更多物品。");
JEI.addDescription(<toolbelt:pouch>,"把它们用铁砧砸到你的工具皮带上以拓展其容量，最多九个！");

JEI.addDescription(<dungeontactics:high_striker>,"一把拥有着有趣灵魂的锤子，可以让目标去见上帝。");
JEI.addDescription(<dungeontactics:wackerjab>,"这绝对是一位扭曲而混沌的神灵所铸造的刀刃，它由最为精纯的扭曲与虚无所制成。会扭曲被它击中生物的生命形态。");
JEI.addDescription(<dungeontactics:taser>,"自苍穹之上坠落，只有使用者悄然无声的接近对手，使用它攻击，才会引起惊醒风暴的重视。");
JEI.addDescription(<dungeontactics:claws>,"唤起那被遗忘许久的诡异咒文，手持此刃者将饮下其对手之血温养己身。");
JEI.addDescription(<dungeontactics:lithen_scythe>,"一把被尘封于历史中的锋刃，来自一位和平主义者。可以在短时间内将受害者损失的生命化为己用。");
JEI.addDescription(<dungeontactics:pirate_hook>, "贪婪的象征，具有点“血”成金的神奇力量，不过很明显，只有在使用者进行那满含仇恨与怒火的暴力行径时，这股力量才会生效。");
JEI.addDescription(<dungeontactics:engineer_dungarees>, "工程裤，可以避免你触发那些陷阱，如钳制陷阱，穿上铁/金/钻石靴子以最大程度的保护你和你的基地的安全。");

JEI.addDescription(<defiledlands:the_ravager>, "这把武器的核心便是那颗不断跳动和扭曲着的黑色心脏，其射速奇快无比，可以使用那些造价不菲的弹药打出不俗的伤害。");
JEI.addDescription(<defiledlands:pellet_umbrium>, "用融魂钢打造的弹药，其强大的韧性足以承担毁灭者手炮那恐怖的爆发力。");


/* Ores and Ingots */
val crudeSteelIngot = <dungeontactics:steel_ingot>;
val sfsSteelIngot = <betterwithmods:material:14>;
val charcoal = <minecraft:coal:1>;
val zincOre = <pyrotech:rock:3>;

JEI.addDescription(<endreborn:block_essence_ore>, "一种硬的难以置信的，并带有醉人的紫色的特殊石头。被认为是终末之力的源泉。");
JEI.addDescription(<endreborn:item_end_essence>, "伴随着它们文明的衰落，毁灭与混沌如潮水般倾泻向这片大地。");
JEI.addDescription(<biomesoplenty:biome_essence>,"诞生自虚空，组成世界上各种生物群系的力量残余，可以在末地主岛的底部找到。");
JEI.addDescription(<ore:ingotSilver>,"一种极端克制亡灵生物的金属，但是除了挖掘和伤害上有所造诣，也就没什么用了。");
JEI.addDescription(<ore:ingotIron>,"尽管有着青铜和钢这样的比铁更为强大的材料，但是铁的重要地位仍不会被取代。");
JEI.addDescription(<contenttweaker:material_part:49>,"那些含碳量极低，且含有微量炉渣的铁被称之为熟铁。它们坚硬但是脆的慌。",'令人惊讶的是，地下这种金属的含量奇多，因为这种金属并非“自然”形成的。');
JEI.addDescription(crudeSteelIngot,["尽管坩埚钢并不是最好的钢，但是比起青铜来说仍然是十分优秀的。钢因为其耐用和兼容的特点被广泛使用于各种机器的制作。",'虽然铁匠们发现了很多更为强大的合金钢，但是那复杂而繁琐的制作过程早已被磨灭在历史的长河中了，其他的那些则被认为“太过于危险”而被明令禁止制作。有传闻，一位足够优秀的匠人将会发现一种最为强大的合金钢。']);
JEI.addDescription(sfsSteelIngot,"一种后期材料，用于制作最棒的采矿工具——鹤嘴锄！当然，后期的其他工具也需要它。");
JEI.addDescription(<ore:ingotBronze>,"强于铁而弱于钢。");
JEI.addDescription(<ore:ingotBrass>,"用于那些需要大量的动态元件且摩擦极小的机械上，当然，它还具有一些特殊的声学特性。");
JEI.addDescription(<rotn_blocks:exorite_crystal>,"一种生长于末地，梦幻而醉人的水晶，常常有人把它们和紫水晶搞混。");
JEI.addDescription(<netherex:amethyst_crystal>,"一种生长于猪灵们的土地上的，美丽而晶莹的水晶，它们极其稀有，因为据说下界所有的矿脉已经被开采光了。一些处于苦寒之地的村民们应该知道这东西的来路。");
JEI.addDescription(<ore:gemDiamond>,'钻石！这是你醒过来的世界里最为强盛的材料！其作用数不胜数，但是除了用于打造盔甲工具和装饰之外，它也是钢锭的合金材料之一，钻石钢锭可以合成“钻石”盔甲，武器。和工具。');
JEI.addDescription(charcoal,"如果要获得木炭需要使用合适的碳窑或者木炭堆来烧制，普通熔炉的火焰太过于猛烈，只会把木头烧成灰。");
JEI.addDescription(<quark:biotite>,"一种由坚硬的有机物组成的特殊水晶，可以在杀死末影龙后于末地主岛发现。");
JEI.addDescription(<ore:dustCopper>,"那些较为脆弱的金属即使不需要铁砧也可以被碾成粉。");
JEI.addDescription(<ore:dustZinc>,"可以从那些寒冷生物群系中发现的锌矿碎块里获得或者作为磁铁矿的伴生矿被发现。那些较为脆弱的金属即使不需要铁砧也可以被碾成粉。");
JEI.addDescription(<ore:dustTin>,"Crumblier metals can be bashed into workable dusts without the need of an anvil.");
JEI.addDescription(<ore:dustBronze>,"那些较为脆弱的金属即使不需要铁砧也可以被碾成粉。");
JEI.addDescription(<ore:dustIron>,"那些较为脆弱的金属即使不需要铁砧也可以被碾成粉。");
JEI.addDescription(<ore:dustGold>,"那些较为脆弱的金属即使不需要铁砧也可以被碾成粉。");
JEI.addDescription(<ore:dustSilver>,"那些较为脆弱的金属即使不需要铁砧也可以被碾成粉。");
JEI.addDescription(<ore:dustGravitite>,"那些较为脆弱的金属即使不需要铁砧也可以被碾成粉。");
JEI.addDescription(<ore:dustEndorium>,"那些较为脆弱的金属即使不需要铁砧也可以被碾成粉。");
JEI.addDescription(zincOre, "有人叫它们炉甘石，可以在寒冷生物群系里被发现，它们出现的地方周围往往会有磁铁。");

/* Manufacturing */
val hempFiber = <betterwithmods:material:3>;
val windmillBlade = <betterwithmods:material:11>;
val millstone = <betterwithmods:single_machine>;
val woodChips = <pyrotech:rock:7>;
val pulp = <pyrotech:material:25>;
val bark = <ore:barkWood>;
val denseRedstone = <pyrotech:material:36>;
// val fiber = <betterwithmods:material:3>;
val plantFiber = <pyrotech:material:12>;
val driedPlantFiber = <pyrotech:tinder>;
val twine = <pyrotech:material:14>;
val durableTwine = <pyrotech:material:26>;
val coade = <liquid:coade_stone>;
val kaolin_quartz = <pyrotech:material:37>;
val expertly_crafted_arrow_head = <betterwithaddons:japanmat:17>;
val ground_nether_dust = <ore:dustNetherrack>;

JEI.addDescription(windmillBlade,"任意木板都可以制作，当然，用螺杆锯制作的木梁更便宜。");
JEI.addDescription(millstone,"每一位机械师的必备机械，需要从顶部或者底部通入机械能。");
JEI.addDescription(<betterwithmods:saw>,["需要通入机械能才可以工作，一台水车或者风车应该够了。","","如果有生物站在石质砧板上，螺杆锯在割裂它们那脆弱的肉体时也不会忘记的撕下它们的头颅。"]);
JEI.addDescription(<harvestcraft:well>,"井可以提取埋藏于地下的水源，这个精密的结构如果被破坏的话，只会返还一些合成材料。");
JEI.addDescription(<betterwithmods:wooden_gearbox>, ["只有一个输入面，但是输出面很多，在有箭头的那一面放置一个传动轴以改变机械能的传动方向。","","注意，木质变速箱只能传递三格机械能（作为垂直风车的框架时没这一条限制）。可以通过给它一个红石信号来关闭它，如果下雨了，可以试试给它装个风铃。"]);
JEI.addDescription(<betterwithmods:material>,"由于应力过载，这个可怜的变速箱变成了这个鬼样子。不过幸运的是，它们还挺好修的。");

JEI.addDescription(<pyrotech:drying_rack:1>, "可以同时处理四个物品，如果周围有火的话会更快，但是如果暴露在雨里，即使是在高温的火焰也无能为力。");
JEI.addDescription(<pyrotech:chopping_block>, "砧板可以用于获得树皮和木片，以及制作鞣制皮革和焦油之类的东西。");
JEI.addDescription(<pyrotech:stone_kiln>,"一种原始的机器，可以用于基础冶炼。如粘土，青铜，烧木炭什么的。上面可以放熔炼物，最多一组。下面放燃料，使用打火石或者弓钻之类的东西点燃。");
JEI.addDescription(<pyrotech:brick_kiln>,"石窑的上位替代品，可以做石窑能做的所有工作，但是效率更高，甚至可以保留燃料的剩余燃烧时间。");
JEI.addDescription(<pyrotech:anvil_granite>,"用于把物品砸碎，如把铜和锡变得能制作青铜。");
JEI.addDescription(<pyrotech:compacting_bin>,"取出成品请使用铲子。");

JEI.addDescription(woodChips, "这些木头的副产品如果遇上一个足够机敏的木匠，那么它们一样可以发光发热。");
JEI.addDescription(bark,"啊哈！这些树皮是从原木上剥下来的。可以用来制作鞣制皮革。当然，在一个足够机敏的木匠手上还有其他用处。");
JEI.addDescription(driedPlantFiber, "小搓的干燥植物纤维，可以拧成一股绳或者制作捆成一捆。");
JEI.addDescription(plantFiber, "通过打碎各种植物获得。");
JEI.addDescription(hempFiber,"高级合成配方里所使用的东西，由植物纤维拧成的。");
JEI.addDescription(twine, "一种和蜘蛛网能力差不多的纤维捆。");
JEI.addDescription(durableTwine, "通过将普通麻绳浸泡在木焦油中，可以获得一种更加耐用的麻绳。");
JEI.addDescription(pulp, "通过浸泡木料或者甘蔗，以及把树皮打成浆获得，用于干制成纸。");
JEI.addDescription(coade, "一种足以承担熔岩热量的材料，其名称来源于某种制陶材料，虽然和粘土半点关系都没有，但是这个名字还是沿用至今。");
JEI.addDescription(denseRedstone, "一种致密的红石晶体，只需要轻微的触碰便会被激活，它的上面跳跃着爆裂的能量，好像无数躁动的灵魂被拘束于这块晶体里…………但是如此精纯而无穷的力量源泉，使用起来，代价是什么呢？");
JEI.addDescription(kaolin_quartz, "来源于下界的优质石英，含有大量高岭土，是制造瓷器的重要材料。");
JEI.addDescription(<betterwithmods:material:15>, "The dust of dried, flesh-like rock. It instantly becomes a viscuous substance when touching fluids; a conveyor belt could be another method of transport for this...");
JEI.addDescription(ground_nether_dust, "地狱岩被粉碎后的产物，接触流体会使其变成某种粘性物质，也许我们应该用传送带来运输它的");
JEI.addDescription(<rustic:rope>, "用于攀爬和支持各种植物生长，需要配合栽培桩使用。具体请参考年历通书。");
JEI.addDescription(<rustic:crop_stake>, "用于支持各种植物生长，需要配合绳索使用。具体请参考年历通书。");
JEI.addDescription(expertly_crafted_arrow_head, "这是个质量很高的箭头，很明显，制造它的人是个技艺精湛的匠师。它可以被技艺同样精湛的制箭师制作为高级箭矢。");
JEI.addDescription(<pyrotech:compost_bin>,"堆肥是个简单的伙计，用你冗余的食物填满堆肥，然后倒入一些水，接下来的事情就交给时间去处理吧。");

JEI.addDescription(<dungeontactics:engineers_wrench_iron>,"用于旋转各种方块，重置被触发的陷阱，拾起红石机关等。");
JEI.removeAndHide(<base:wrench>);
JEI.addDescription(<contenttweaker:peat>,"在沼泽地可以被找到的一种生物燃料，可以进一步加工。");
JEI.addDescription(<contenttweaker:mossy_peat>,"洞穴苔藓取代了泥炭的位置，这种海绵一样的东西会和其他物质一样吸收煤层气。");
JEI.addDescription(<contenttweaker:charmpeat>,"吸饱了煤层气的苔藓泥炭，其蕴含的能量足以冶炼任何东西。");


/* Multiblock Kilns, Refractory Structures, Pit Burning, Camping and Cooking */
val refractoryClayBall = <pyrotech:material:4>;
val refractoryBrick = <pyrotech:material:5>;
val slag = <pyrotech:material:8>;

JEI.addDescription(<contenttweaker:brick_minecraft_clay>,["砖块不仅可以用作建筑材料，还可以搭建那巨大而臃肿的砖窑，搭建方式如下：将四个砖块围城一圈，中间空出来一格放置你想冶炼的方块，然后在被冶炼的方块下面点上一把火。","","当然，砖窑永远比不上那些单方块的石窑或者耐火窑的效率，这是因为方块间隙之间的空气流动导致热量散失严重。"]);
JEI.addDescription(<pyrotech:material>, "烧炼的副产物，只需要小心一点，就可以把它们压制成块。");

JEI.addDescription(refractoryClayBall, "这种特殊的石灰粘土烧制成的砖几乎不导热，这是其成为了制作耐火结构的绝佳材料。");
JEI.addDescription(slag, "含有某些稀有成分（如二氧化硅，铝，钙，镁等）的材料的残余。");
JEI.addDescription([<contenttweaker:brick_pyrotech_refractory>, refractoryBrick], "耐火材料可以承担某些高温燃烧配方，使用耐火材料制成一个方形房间，使用要燃烧的方块填充其内部，点燃它们，再快速封上房间。如果操作得当，材料会被合成为被燃烧后的版本，如果结构内有收集器的存在，还会输出燃烧中产生的流体。");
JEI.addDescription(<pyrotech:refractory_door>, "耐火燃烧结构的工作实质是通过燃烧而非起火，因此，这个结构上不准出现哪怕是一丝一毫的缝隙，包括门……");
JEI.addDescription(<pyrotech:living_tar>, '一种极其耐烧，由粘腻的油脂和血肉堆砌而成的焦油块，据它的创造者说，它将是世界上最恶心燃料的候选人之一。"');
JEI.addDescription(<pyrotech:tinder>, "将它放在地上，添加一些原木使其变成一个篝火，随后点燃它。这将是你在野外寻求熟食的一个不错的出路。");
JEI.addDescription(<exsartagine:range>, "厨房必备品之一，为其添加燃料可以为放置其上的煮食锅，平底锅，冶炼炉（真的，不是匠魂那个）提供热量。此外，与炉灶链接的半径3格以内的熔炉将会成为炉灶结构的一部分，也可以为放置其上的锅具供热。");
JEI.addDescription(<exsartagine:pan>, "非常适合煎炸单一食物。");
JEI.addDescription(<exsartagine:pot>, "非常适合炖煮某些食物。");
JEI.addDescription(<exsartagine:kettle>, "最棒的烹饪锅！啥都能煮！欧耶！");
JEI.addDescription(<minecraft:furnace>, "用于冶炼矿石和烹饪食物的一台基础机械，它不像窑那样专业，也不像坩埚那样能处理高级配方，它和烤箱也沾不上边，但是它发出的热也足以加热放置其上的锅具了。");


/* Plants */
JEI.addDescription(<rustic:wildberries>,"一种味道浓郁的浆果，可以榨汁和酿酒。其具有十分艳丽的红色，很适合制作燃料。");
JEI.addDescription(<rustic:wildberry_bush>,"野莓灌木可以作为一种无害的食物来源。可以用骨粉使其扩散。在大部分气候适宜的生物群系里它们广泛分布。");
JEI.addDescription(<rustic:mooncap_mushroom>, "在丛林生物群系的地下洞穴发现。");
JEI.addDescription(<rustic:cloudsbluff>,"这种柔软如白云的花朵生长于高海拔地区。");
JEI.addDescription(<betterwithaddons:thorn_rose>, "一种诡异的植物，生长于沙子上。可以沿着墙壁蔓延。成熟后可以收获一些有趣的小东西。");
JEI.addDescription(<biomesoplenty:berries>, "从那些令人厌烦的灌木里摘得的酸涩无比的浆果，但是架不住动物们喜欢它的味道。尤其是马，当它们被喂食这种浆果的时候会发生意想不到的事情。");
JEI.addDescription(<biomesoplenty:plant_0:5>, "浆果灌木，它们的叶子柔软而可爱。但是当它们感觉到自己的生命被威胁时，它们会选择用自己的纸条武装自己。它们的果子对马有独特的功效。");
JEI.addDescription(<minecraft:cactus>,"一种可以装水的瓶子，在炎热的群系里饮用可以获得少量的增益效果。");
JEI.addDescription(<pyrotech:mulch>, "一个精明的园丁总是知道怎么打理好植物————用氮和钾制成的化肥！它们可以保证作物不在被踩坏，也可以加速植物生长。");

JEI.addDescription(<harvestcraft:juteitem>, "耐用，但是需要经过打理才可以投入使用。可以把几根搓成一股绳子。");
JEI.addDescription(<harvestcraft:flaxitem>, "亚麻在纺织上有很高的价值，但是还是不如大麻。它也可以制作淡蓝色燃料。");
JEI.addDescription(<harvestcraft:kenafitem>, "含有大量植物纤维……仅能造纸。");
JEI.addDescription(<harvestcraft:sisalitem>, "也有人叫它“灰叶剑麻”，它的纤维作用很多，主要生长于干旱的生物群系。");
JEI.addDescription(<harvestcraft:cottonitem>, "虽然不是最具弹性的植物纤维，但是作为衣物内垫的时候，棉花还是很舒服。");
JEI.addDescription(<betterwithmods:hemp>,"一种被广为使用的植物，大麻的纤维耐用非常，用于制作风车帆布和绳索在适合不过了，和甘蔗一样，它会生长两个方块高，记得一定只能收获第二格的！");
JEI.addDescription(<growthcraft_rice:rice>,"一种生长于水塘里的植物，种植它的水塘被称为“稻田”。生米含有大量细菌，不可食用。");
JEI.addDescription(<growthcraft_hops:hop_seeds>,"用于酿造麦芽汁和啤酒，啤酒花的生长需要作物架支持。");

/* Food */
JEI.addDescription(<animania:friesian_cheese_wheel>,"要制作奶酪块，请把山羊或者绵阳或者奶牛的奶导入模具，然后把剩下的活交给时间。");
JEI.addDescription(<animania:holstein_cheese_wheel>,"要制作奶酪块，请把山羊或者绵阳或者奶牛的奶导入模具，然后把剩下的活交给时间。");
JEI.addDescription(<animania:jersey_cheese_wheel>,"要制作奶酪块，请把山羊或者绵阳或者奶牛的奶导入模具，然后把剩下的活交给时间。");
JEI.addDescription(<animania:goat_cheese_wheel>,"要制作奶酪块，请把山羊或者绵阳或者奶牛的奶导入模具，然后把剩下的活交给时间。");
JEI.addDescription(<animania:sheep_cheese_wheel>,"要制作奶酪块，请把山羊或者绵阳或者奶牛的奶导入模具，然后把剩下的活交给时间。");

JEI.addDescription(<forge:bucketfilled>.withTag({FluidName: "milk_jersey", Amount: 1000}),"娟珊牛牛奶来源于娟珊牛。");
JEI.addDescription(<forge:bucketfilled>.withTag({FluidName: "milk_friesian", Amount: 1000}),"黑白花牛牛奶来源于黑白花牛。");
JEI.addDescription(<forge:bucketfilled>.withTag({FluidName: "milk_holstein", Amount: 1000}),"荷斯坦牛牛奶来源荷斯坦牛。");
JEI.addDescription(<forge:bucketfilled>.withTag({FluidName: "milk_goat", Amount: 1000}),"山羊奶来源于山羊。");
JEI.addDescription(<forge:bucketfilled>.withTag({FluidName: "milk_sheep", Amount: 1000}),"绵羊奶来源于绵羊。");

JEI.addDescription(<minecraft:poisonous_potato>, "一个发芽的马铃薯，如果喂给小动物，那么它们这辈子也长不大了。");
JEI.addDescription(<mod_lavacow:parasite_item>, "这种恶心的东西以那些被古老病毒感染的肉体为食，在那次大灾变降临的时候，它们凭借独特的生活习性活了下来。当被用作发酵酵母时，它会让酿造物变得杀人于无形……");
JEI.addDescription(<mod_lavacow:parasite_item:1>, "这些恶心的东西以深埋于地下的木乃伊为食，由于古老的仪式，木乃伊腐烂的速度比一般尸体慢的多。");
JEI.addDescription(<mod_lavacow:parasite_item:2>, "这些恶心的东西以真菌和腐殖质为食，但是如果有机会，它们也不介意去品尝一下新鲜血肉。");
JEI.addDescription(<exsartagine:yeast>, "酵母可以撒在面粉上，撒上酵母后再往面粉上洒点水开始发面。破坏正在改变的方块会掉落酵母。");
/* Mobs and Drops */
val dung = <betterwithmods:material:5>;

JEI.addDescription(<quark:parrot_egg:*>, "就像其他鸟类一样，鹦鹉喜爱蔬菜和种子的味道。但是甜菜根是它们的最爱，也是它们在繁殖季节的小零食：有时鹦鹉吃了甜菜种子之后会下蛋。");
JEI.addDescription(<minecraft:gunpowder>, "大多数爆炸物的核心原材料。也可以放在地上作为引信点燃。");
JEI.addDescription(<minecraft:skull:3>, "一个在村庄中流传的古老传说提到了，一个以特定的人的名字命名的傀儡中会容纳那个人的一点点灵魂……而那些拥有禁忌知识的人可以将这些灵魂的回音带回现实维度之中。命名后的雪傀儡携带南瓜被女巫杀死后会掉落那个人的头颅。");
JEI.addDescription(<minecraft:dragon_breath>, "这种诅咒的野兽的酸性吐息蕴含了强大的力量。滞留的毒性气体甚至可以感染石头。");
JEI.addDescription(<minecraft:blaze_rod>, "这些稳定棒可以中和烈焰人本身所蕴含的爆裂能量。甚至从烈焰人本身的结构脱离出来之后，烈焰棒也散发着微热。放置烈焰棒可以用来进行一些奇妙的装饰。");
JEI.addDescription(<quark:tallow>,"可以用来制作蜡烛或是在铁砧上用来修复基础的齿轮。猪是油脂的良好来源；将腐肉浸泡在工业酒精（也叫甲醇）之中也可以提取油脂。");
JEI.addDescription(<mod_lavacow:moltenbeef>,"年幼的炎熔螈的第一反应永远都是逃跑，这样可以帮助它们逃离捕食者的爪牙。成年的炎熔螈倒是没有这种本性……因为没什么敢惹怒一只成年炎熔螈。");
JEI.addDescription(<mowziesmobs:glowing_jelly>,"Puffbulbs are particularly fragile creatures that sustain themselves by absorbing energy from a living mineral, surviving against all odds amidst the horrors of the Beneath.");
JEI.addDescription(<mod_lavacow:dreamcatcher>,"如果你在睡觉时装备或拿着一个捕梦网，它就有几率在你醒来之时将你噩梦的化身召唤到现实世界中……");
JEI.addDescription(<primitivemobs:wonder_sap>,"一个由A marvelous material produced by grove sprites. It can turn other species of wood into the type of wood the grove sprite originated from. Most interestingly, when combined with certain dense liquids, it makes for an extremely strong adhesive. It also has various agricultural uses.");
JEI.addDescription(<biomesoplenty:flesh>, "它摸起来居然还是热的。");
JEI.addDescription(<primitivemobs:camouflage_dye>, "现在你看得到我啦，现在你又看不到啦……This substance found in chameleons can dye most things into camouflaging colors.");

JEI.addDescription(<betteranimalsplus:wolfhead_1>,"冰原狼几乎是顶级的猎食者，它们不会接受任何陌生人给予的肉，但是也许会接受一些恐怖生物的骨头作为食物。");
JEI.addDescription(<betteranimalsplus:wolfhead_1>,"要驯服一只冰原狼，你需要一个强大生物的头颅，一共有两种，其中一个非常明显（因为这是原版头颅，不认识的建议重玩原版），而另一个……能不能找到就看造化咯。");
JEI.addDescription([<betteranimalsplus:coyotehead_1>, <betteranimalsplus:coyotehead_1>],"郊狼会吃几乎各种肉类，同时，它们也会吃多种水果。它们作为吃货可一点也不挑剔。");
JEI.addDescription([<betteranimalsplus:foxhead_1>, <betteranimalsplus:foxhead_1>, <betteranimalsplus:foxhead_2>, <betteranimalsplus:foxhead_3>,<betteranimalsplus:foxhead_4>],"狐狸通常会把那些较小的生物作为它们的食物，如家鸡，青蛙，野鸡，还有兔子。当然，它们对浆果的热情不弱于这些小动物们");
JEI.addDescription([<betteranimalsplus:hirschgeistskull>, <betteranimalsplus:hirschgeistskull_1>],"强大的繁森之灵的被诅咒的头颅");
JEI.addDescription(<betteranimalsplus:hirschgeistskullwearable>,"强大的繁森之灵的被诅咒的头颅是一种仪式用的头盔，戴上它，即使是森林中最为凶恶的野兽也得对你礼让三分");

JEI.addDescription(dung,"恶心？不不不，这才是大自然真正的力量。通过喂食驯服的狼使其在胃中发酵获得，当然，消化需要大把大把的时间，也需要你大把大把的耐心。如果你二者兼备，你将会获得鞣制皮革");
JEI.addDescription(<betterwithmods:breeding_harness>, "你所需要的仅仅是顺从，接下来的东西就交给它来完成");

JEI.addDescription(<netherex:frost_rod>, "被凛冬注视的棒状物，被那些寒冰术士所青睐");
JEI.addDescription(<netherex:frost_powder>, "如果我怠慢了它，即使是被碾碎了，它的寒气依然足以让我喝一壶的");
JEI.addDescription(<netherex:coolmar_spider_fang>, "骨蜘蛛并非真正的蜘蛛，它只不过是一只由冰块与骸骨所构成的傀儡罢了，据民间传言，它们将会在世界末日到来前不久出现");

JEI.addDescription(<betterwithmods:material:54>, "不同于大多数蜘蛛的独来独往，丛林蜘蛛总是喜欢打配合战。它们的毒液科研造成呕吐和食欲不振，但是绝大多数生物活不到毒性完全发作的时候");
JEI.addDescription(<mod_lavacow:poisonstinger>, "蜜蜂只能蛰你一次，但是巨锋能蛰你蛰到你归西");

JEI.addDescription(<mod_lavacow:scythe_claw>, "伊萨库亚那肮脏与憎恶的利爪，其内蕴含着对新鲜血肉的贪婪");

JEI.addDescription(<defiledlands:black_heart>, "一颗强力的心脏。被难以理解的邪恶力量驱动…");
JEI.addDescription(<defiledlands:scuronotte>, "黑夜蘑菇通过吸取那些被污染的，亵渎的魔法物质生长");
JEI.addDescription(<mod_lavacow:undyingheart>, "一颗强力的心脏。被一个可怕的诅咒所驱动……");

/* Decorative Blocks */
JEI.addDescription(<minecraft:bed:*>, ["通过一些简单的填充物和木头，你便可以制造一个舒适度足以支持你躺下的地方，现在，酣然入梦，为了迎接明天更为灿烂的黎明。祝你好运"]);

JEI.addDescription(<minecraft:purpur_block>, ["远在上古之时，想要控制潜影贝对于末影帝国的居民来说和吃饭喝水没有什么区别，不过往昔不在，现在，它们成为了这些雄伟建筑最后的见证者……和蛀虫"]);
JEI.addDescription(<betterwithaddons:elytra_magma>, "一个神秘的方块，只要你穿着鞘翅飞过它，它就会给予你一个向上的推力");
JEI.addDescription(<minecraft:end_stone>,"曾有人见过这种来自异次元的石头，据说，它们是末影人的家园最常见的“土壤”……不过，那时候它们被描述成上面长有茂密的紫色草和其他的诡异植物……");

JEI.addDescription(<chutes:chute_wood>, "一个方块里能放四个，对于快速转移进入水下非常有用");
JEI.addDescription(<chutes:chute_entry_wood>, "一个方块里能放四个，对于快速转移进入水下非常有用，与其他的不同，这是入口");

JEI.addDescription(<quark:sugar_block>, "那些粗心的农民总是抱怨自己的糖又双叒叕不见了，哈，糖块如果放在水边上，那么没一会它们就将和你说再见咯");
JEI.addDescription(<charm:gunpowder_block>, "存储火药的另一种形式，和其他中立方块一样，它也会在悬空时自由落体。而且……和它的掉落物形式类似，它溶于熔岩");
JEI.addDescription(<contenttweaker:halite>,"一大块未加工的盐！");
JEI.addDescription(<charm:rotten_flesh_block>, "有点像下界群系——内脏堆哪里发现的肉……但是有些不同，它一直在蠕动……还会时不时抽搐两下，如果把它埋起来而且时间足够长……一些腐烂的精粹将会溢出来……并转化其上的泥土");
JEI.addDescription(<aether_legacy:aerogel>, "熔岩在天境所凝结而成的东西，抗爆性和它的姊妹黑曜石一般无二，挖掘等级也是如此……");

JEI.addDescription(<quark:black_ash>, "腐朽的本源之物，可以感受到一阵阵的邪恶力量波动正在从它内部散发出来，没有任何生物能在它上面或者在它上面的方块上生成！任何都不行！");
JEI.addDescription(<ore:blockCandle>, "一种颜值比较高的火把，如果它的支撑物消失了，它也会被破坏");
JEI.addDescription(<minecraft:torch>, "冒险家们们最好的朋友，大部分人宁愿去深入地下挖煤矿也不会愿意去挖坑窑烧木炭的……更何况是那些更为复杂的烧木炭方式呢？当然，这还有些更为强大的光源，如巨型火把，灯笼，悬挂灯之类的");
JEI.addDescription(<arcanearchives:quartz_sliver>, "一种廉价的火把替代品，使用辉耀石英在那些较为坚硬的方块上敲击获得");
JEI.addDescription(<simpleores:copper_block>, "铜块的特殊之处在于，其表面会形成一层颜色鲜亮若钻石的美丽铜锈，当然，如果你不喜欢，你可以试试给它打个蜡");

/* Redstone, Automation and Functional Blocks */
JEI.addDescription(<quark:ender_watcher>, "一种结合了末影之眼独特性质的红石机关，当期被注视时会发出红石信号");
JEI.addDescription(<quark:gravisand>, "一种怪异的物质，其独特的性质甚至在天境传说中都未曾记载，只有在被红石激活时才会掉落，如果其已然接地，则会……飘起来？");
JEI.addDescription(<quark:gold_button>, "发出2t的信号（0.1s）");
JEI.addDescription(<quark:iron_button>, "发出长达六秒的红石信号");
JEI.addDescription(<quark:obsidian_pressure_plate>, "只有人类走过的时候才会被激活，也许是因为他们承担着生活的重担吧");
JEI.addDescription(<quark:redstone_inductor>, "将输入其中的红石信号强度拧成一股输出，可被比较器锁定");
JEI.addDescription(<quark:redstone_randomizer>, "向左侧或者右侧输出红石信号");
JEI.addDescription(<minecraft:compass>, "潜行右击一张床，旗帜，灯塔，可以使指南针绑定它。相当于创建路径点");
JEI.addDescription(<betterwithmods:rope>, "一种结构揽胜，可以与滑轮一起配合创造升降平台");

JEI.addDescription(<ceramics:unfired_clay:9>, "那些逻辑原件都离不开粘土");
JEI.addDescription(<contenttweaker:redstuff>, "在一个不寻常的日子里，一个粗心的铁匠把熔融的铁和铜混在了一起，当然，这并没有产生什么新的合金，但是当它泼洒到那些珍贵且精细的红石电路上时，奇迹发生了，一种全新的材料出现了！铁匠把它注册了商标：Red Stuff™，好吧，至今为止没人知道他们是怎么工作的");
JEI.addDescription(<charset:stopwatch>, "检测方块之间更新时间差的工具，使用它右击一个方块，再右击第二个。当第二个方块发生更新时，则会出现提示，第二个方块和第一个方块更新的时间差是多少");
JEI.addDescription(<charset:signal_meter>, "一种用于侦测红石信号的东西，手持其即可查阅红石消耗，在部分特殊原件上同样有独特的作用");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:nor", li: 1 as byte}), "一个简单的原件，在输入任何等级的红石信号时都会输出信号，它有三个输入端和一个输出端");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:nor", li: 0 as byte}), "一个简单的原件，在输入任何等级的红石信号时都会输出信号，它有三个输入端和一个输出端");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:buffer", li: 0 as byte}), "一个简单的原件，在没被输入信号时发出信号，它有三个输入端和一个输出端");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:nand", li: 1 as byte}), "一个简单的原件，在三个输入端都被接通时输出信号，它有三个输入端和一个输出端");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:nand", li: 0 as byte}), "一个简单的原件，在三个输入端有任何一个没输入时输出信号，它有三个输入端和一个输出端");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:xor", li: 0 as byte}), "一个简单的原件，在只有一个输入端被接通时输出信号，如果两个都接通则不输出，它只有两个输入端和一个输出端");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:xor", li: 1 as byte}), "一个简单的原件，只有在两个输入都接通或都不接通时输出信号，它只有两个输入端和一个输出端");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:buffer", li: 1 as byte}), "一种重定向红石信号输出方向的原件，有一个输入和三个输出");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:multiplexer"}), "一种判定原件，可以根据其后端输入的状态输出不同的信号，输出的信号取决于其左右两端的输入状态，后端承担开关或者说切换的作用。有三个输入端和一个输出端");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:pulse_former"}), "一种简单的原件，在其后端输入打开时输出短暂的信号，只有一个输出和一个输入");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:repeater"}), "一种类似于红石中继器的组件，可以重置信号至15级并产生延迟，不过，它的最大延迟为128tick，且不能被锁定");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:randomizer"}), "一种简单的随机触发器，不过，它可以将每一个输出都单独随机化，这对于制作随机长度的脉冲是非常有用的。打开时，允许随机脉冲的出现，关闭时则锁定每个脉冲的能量");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:rs_latch"}), "一种特殊组件，可以对信号进行锁存或重置，当锁存完成时，第二道信号并不会重置它，它有最多两个输入和最多四个输出，这取决于配置");
// JEI.addDescription(<projectred-integration:gate:14>, "一种类似于普通中继器的组件，它允许锁定信号。当后端输入打开时，输出设置为左输入;当后端输入被关闭时，输出被锁定。它有两个输入和两个输出");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:timer"}), "一种延时系统，当没有信号输入时，它会一直等待，当输入信号时，计时器将会归零。打开它的gui以完成调整");
// JEI.addDescription(<projectred-integration:gate:19>, "保留内部计数的原件，该计数不能低于0。当计数为0时，反向输出打开;当计数在可配置的最大值时，前端输出打开。左边和右边分别通过减法和加法控制计数，或者可以通过用螺丝刀右击移动组件来翻转计数。原件可以通过GUI进行配置。它有两个输入和两个输出");
// JEI.addDescription(<projectred-integration:gate:20>, "一种类似于计时器的原件，具有可配置的时间。计时器可以使用后面的或右边的输入进行重置，后面的输入可以启动计时器。当计时器运行时，左侧输出是打开的;当计时器停止时，前端输出脉冲。右键单击它以打开配置GUI。它有两个输入和两个输出");
JEI.addDescription(<charset:logic_gate>.withTag({logic: "simplelogic:synchronizer"}), "一种类似于阀门的原件，输入信号必须在对应点上输入才会输出，同时重置其内部状态");
JEI.addDescription(<charset:logic_wire_n:0>, "一种用RedStuff™制成的线缆.");
JEI.addDescription(<charset:logic_wire_n:1>, "一种独立线缆，不需要支撑物。可以通过正常线缆来连接到电路上");

JEI.addDescription(<sereneseasons:greenhouse_glass>, "只要附近有光源和水源，这些被自然之灵所祝福的玻璃就可以让农作物在其下方生长");

JEI.addDescription([<advancedmortars:mortar:0>, <advancedmortars:mortar:2>, <advancedmortars:mortar:4>, <advancedmortars:mortar:6>], "神奇的迫击炮…… [处于WIP状态]");
JEI.addDescription(<advancedmortars:mortar:1>, "由极其耐用的金属制成，非常安全");
JEI.addDescription(<advancedmortars:mortar:3>, '虽然其因为制造材料的原因远不如它的其他同族，但是它的身份依然摆在那，不容忽视');


/* Mechanical, Defense, and Item Movement */
JEI.addDescription(<quark:rope>, "一个便捷的攀爬工具，直接右击会向下放置，shift右击反之。");
JEI.addDescription(<growthcraft:rope>, "可以固定于栽培桩上以支持葡萄，啤酒花等作物生长。");
JEI.addDescription(<quark:chain>, "这种锁链可以把船或矿车连在一起，使其更有条理。");
JEI.addDescription(<minecraft:minecart>, "用手中的燃料shift右击矿车以上色。");
JEI.addDescription(<minecraft:lead>, "除了栓动物，栓绳还可以栓在栅栏上，可以连接两个栅栏。一些强大的生物栓绳并不能把它们控制住，因此，我们需要更为坚韧的一种栓绳……");

JEI.addDescription(<quark:chute>, "一个有趣的漏斗，可以把其上方或者输入其内的物品直接以掉落物形式漏出。");
JEI.addDescription(<quark:grate>, "动物们可不想走在这些东西上面……而且因为上面的洞太多了，掉落物会直接漏过去。当然，我们和怪物还是可以走过去的。");

JEI.addDescription(<quark:iron_rod>, "一种本来是用于支撑矿井，但不知怎的变成了最受欢迎的采矿工具的玩意。当被活塞推动时，它可以摧毁能被活塞推动的一切。");
JEI.addDescription(<quark:iron_ladder>, "锡制梯子可以悬空放置（藤蔓），和绳索一样，直接右击可以向下延伸。");

JEI.addDescription(<pyrotech:faucet_stone>,"右击它，它可以把流体从一个容器中转移到另一个容器中，再次右击可停止。可被红石控制。");
JEI.addDescription([<betterwithaddons:aqueduct>,<betterwithaddons:aqueduct:1>,<betterwithaddons:aqueduct:4>],"一种用于长距离转移水源的方块，水道只会从海洋，河流和沼泽群系里运输水。因为其他地方的水不足以使其工作。");
JEI.addDescription(<betterwithaddons:aqueduct:4>,"那些伟大的沙漠文明凭借着这些水槽而存活于世，直至今日。");

JEI.addDescription(<contenttweaker:elevator>,"最先进的机器的最粗糙复刻版……如果这也能被称之为机器的话。它曾经是由先进的末地文明所创造的。只是目前来说……它毫无用处。当然，这只是暂时的，后面可说不准。");
JEI.addDescription(<advancedliftingmethods:ultimate_ender_elevator>,"在它们的科技达到顶峰的时候，末地的居民们甚至可以随意的扭曲空间，而不使用它们与生俱来的传送能力。由两台末地电梯可以组成一对电梯。按下空格以转移到上面那台，按下shift则是传送到下面那台。");
JEI.addDescription(<dungeontactics:fan_block>,"推动 §l所有的实体与物品§r, 熄灭火焰还有吹走灰尘。如果后面有个风扇的话效果更好。 因为其动力远低于风扇电梯。而且它§l不能使气流吹过溜槽。");
JEI.addDescription(<dungeontactics:flamer_block>,"对范围内实体造成火焰伤害，同时可以驱动一些可以被火焰驱动的东西，比如点燃TNT，激活炼金术大锅等。");
JEI.addDescription(<advancedliftingmethods:blowing_elevator>,"因为石质压力板不能被物品激活，所以这东西只会推动实体。你可以尝试把它做成风扇电梯。");

JEI.addDescription(<malisisdoors:garage_door>, "使用红石激活，所有的方块视作一个整体。");
JEI.addDescription(<malisisdoors:jail_door>, "使用红石控制。");


/* Nyx Stars and Meteors */
JEI.addDescription(<nyx:fallen_star>,"自苍穹坠落，降临尘世。当然，这并不多见，除了在流星雨的情况下。");
JEI.addDescription(<nyx:meteor_shard>, "通过破坏流星石获得。");
JEI.addDescription(<nyx:meteor_rock>, "从散布于世界各地的流星里发现。");
JEI.addDescription(<nyx:unrefined_crystal>, "通过破坏流星团簇获得。");
JEI.addDescription(<nyx:gleaning_meteor_rock>, "在流星雨事件中会被发现。");


/* Hearts */
JEI.addDescription(<contenttweaker:heartofthefallen>,"这颗心脏的跳动从未停止。如果你仔细听，你可以听到里面回荡着痛苦和悲伤的微弱哭声。");
JEI.addDescription(<contenttweaker:heavensheart>,"这颗心脏以受祝福的愤怒之力从天而降，流淌着燃烧的光芒和驱除邪恶的灼热力量。");
JEI.addDescription(<quark:diamond_heart>,"一颗罕见的活体矿物之心从世界核心撕裂下来，并以魔法恢复了生命。");


/* Stat Modifiers (Enchanting, Reforging) */
JEI.addDescription(<quark:ancient_tome>,"充满了来自一个早已灭绝的文明的神秘秘密。将一本古卷和一本与之匹配的附魔书放在铁砧上，使附魔等级提高，可以超过正常情况下的最高等级。");
JEI.addDescription(<qualitytools:reforging_station>,"将一个工具/装备和一个小型魔力碎片一起放入锻造台，能够改变工具/装备的品质。");
JEI.addDescription(<minecraft:enchanting_table>,"可以用附魔台升级。创建一个区块需要消耗XP。每增加3个区块，这个XP费用就增加1。把它们放在格子里来应用它们。别太贪心了!");
JEI.addDescription(<ore:ingotElectrum>,"与Aetherial Electrum相比，普通的Electrum没有什么价值。可能是由瓦尔基里人发现的，这种材料的价值远远大于其各部分的总和。");


/* Storage */
JEI.addDescription(<netherchest:nether_chest>,"当物品存放在下界宝箱中时，由于下界将空间压缩8倍，因此它们的正常堆叠大小限制乘以8。此堆叠大小增加也适用于工具和通常不可堆叠的任何其他物品。尽管他们的名字，试图在下界打开它是一个非常糟糕的主意。");
JEI.addDescription(<pyrotech:compacting_bin>, "一种加固的容器，对于将东西压成更密的材料或块状很有用。");
JEI.addDescription(<pyrotech:shelf>,"摆放物品比箱子更显眼。");
JEI.addDescription(<pyrotech:stash>,"当你需要一个地方来存放物品时......而不是一个神秘的宝库。最多可以容纳32组相同的物品。");


/* Rats and the Plague */
JEI.addDescription(<rats:treacle>,"据称，陈酿至少十年的糖浆可以帮助抵御瘟疫。除非你在十年前就开始为瘟疫做准备，否则这不会有帮助......除非你能找到一些东西来神奇地使糖浆老化或引发奇怪的发酵反应。");
JEI.addDescription(<rats:plague_essence>,"钙化的瘟疫能量团块。瘟疫被认为是被永远封存起来了，但现在这个菌株，至少，已经报复性地回来了。");
JEI.addDescription(<rats:plague_doctor_mask>,"保护穿戴者免受恶臭的影响。喙有足够的空间在里面塞进一束甜美的草药——是分散检查困扰或腐烂的肉体的臭味的理想选择。");
JEI.addDescription(<rats:plague_doctorate>,"包含研究和治疗瘟疫的重要知识。鼠疫医生由于其工作的性质，在他们自己的社区内常常被人害怕，甚至被人回避。");
JEI.addDescription(<rats:rat_breeding_lantern>,"随之而来的点唱机和蜡烛的使用完全是可选的。");
JEI.addDescription(<rats:plague_scythe>,"被灌输了摧毁帝国的腐败潜力。");
JEI.addDescription(<rats:black_death_mask>,"疾病通过实验得到完善......还有什么比血流成河的战场更好的实验室？");
JEI.addDescription(<rats:block_of_cheese>,"这种奶酪已经被粗暴地挤在一起了。把它分离成可食用的楔子是不可能的，但它仍然可以作为囤积老鼠食物的一种方式......或者用作装饰。");
JEI.addDescription(<rats:rattrap>,"用来引诱和杀死野鼠。必须用食物做诱饵，每次使用后都要重新设置。");
JEI.addDescription(<rats:rat_cage>,"用于容纳老鼠进行繁殖或使其远离麻烦。笼子可以用鼠管连接，并配备许多笼子的装饰品。");


/* Bees */
JEI.addDescription(<rustic:bee>, "通过打破蜂巢发现。在养蜂场中放置一个蜂窝，偶尔会产生另一只蜜蜂。");
JEI.addDescription(<rustic:beeswax>, "一种高效、有效和环保的燃料来源——压缩后效果更好。");
JEI.addDescription(<rustic:honeycomb>, "通过打破蜂巢和蜂箱获得——也可通过养蜂场获得。");
JEI.addDescription(<ceramics:clay_bucket>.withTag({fluids: {FluidName: "honey", Amount: 1000}}), "如果你获得了这个物品，不！要！放！下！来！！！！它不能被回收！");
JEI.addDescription(<forge:bucketfilled>.withTag({FluidName: "honey", Amount: 1000}), "如果你获得了这个物品，不！要！放！下！来！！！！它不能被回收！");
JEI.addDescription(<pyrotech:bucket_wood>.withTag({fluids: {FluidName: "honey", Amount: 1000}}), "如果你获得了这个物品，不！要！放！下！来！！！！它不能被回收！");
JEI.addDescription(<pyrotech:bucket_clay>.withTag({fluids: {FluidName: "honey", Amount: 1000}}), "如果你获得了这个物品，不！要！放！下！来！！！！它不能被回收！");
JEI.addDescription(<pyrotech:bucket_stone>.withTag({fluids: {FluidName: "honey", Amount: 1000}}), "如果你获得了这个物品，不！要！放！下！来！！！！它不能被回收！");
JEI.addDescription(<rustic:apiary>, "把蜜蜂赛到这里面让它们工作去吧！顺带一提，蜂房在工作时可以加速周围十字形的作物生长，每个面向外延伸4格即是他的工作范围，上下还可以各延展一格（工作范围：每个面对应的1*4*3，一共四个面）");


/* Relics */
JEI.addDescription(<msmlegacy:relic_aqueous>, "DonMartn的遗物创意。感谢你成为我们Patreon上的龙钢支持者!");
JEI.addDescription(<msmlegacy:relic_candy>, "Just A BLU Toon的遗物创意。感谢你成为我们Patreon上的龙钢支持者!");


/* Lore */
val steelPlate = <betterwithmods:material:51>;

JEI.addDescription(<netherex:ghast_queen_tear>,"他们说每个恶魂女王都会为他们在另一个空间的爱人哭泣。将眼泪滴入一个2x2的水池中，水池周围是草地上的花朵，以打开入口。注意：恶魂女王目前已经禁用，所以我们提供了一个临时配方，这样你仍然可以进入暮色森林。");
JEI.addDescription(steelPlate,"他们还在那里吗？是否有任何遗留的痕迹？看啊，宽大的死人眼像exorite。");
JEI.addDescription(<minecraft:rotten_flesh>,"...他们将上升，只是为了在每个夜晚降临时再次寻找表面...");
JEI.addDescription(<minecraft:rotten_flesh>,"也被称为 RotN Flesh。");
JEI.addDescription(<betternether:pig_statue_01>,"雕刻的是猪人的模样。炉子边缘的铭文是用陌生的语言雕刻的......除了一个。你可以看到 'VARKAAL...'、'LIFE FROM LIGHT... '和 'DUST... '等字样。");
////// JEI.addDescription(<minecraft:clay_ball>,"这样一种可塑性强的材料，他们能在虚空中看到我们一样吗？"); -> should be put on a more fitting item
JEI.addDescription(<quark:soul_powder>,"困在这些被诅咒的灰烬中的某处是迷失的灵魂的记忆。即使在这种状态下，他们仍然在寻找他们死亡的可怕地点。也许找到这样的地方会给他们带来平静。");
JEI.addDescription(<quark:soul_bead>,"扭曲的珠子由一个被诅咒的裹尸人的核心形成。摄取它可以释放里面被困的灵魂，但代价是惊动了各种被稀有魔法吸引的可怕生物。");
JEI.addDescription(<villagenames:codex>,"抄本是一种古老的信息索引，很久以前被先进的文明使用。在手边拿着一本书的时候使用它，会记录其持有者所在的结构的数据。");
JEI.addDescription(<contenttweaker:shard_of_night>,"沾染了黑夜的精华。可以从收割者那里获得。");
JEI.addDescription(<contenttweaker:volatile_core>,"地外生物的动荡本质。含有用于浓缩和提炼陨石的不稳定粉末。");
JEI.addDescription(<contenttweaker:ardicite>,"一种自然形成的纯粹的地狱之火，可以承载缟玛瑙的形成。它是一种炽热的物质，可以在尼瑟斯的易燃硫磺袋中找到。");
JEI.addDescription(<contenttweaker:ofuda>,"一张写着难以辨认的文字的旧纸。经常发现悬挂在被认为是高度危险或被诅咒的地方，这些可能被用作某种符咒，以抵御危险或疾病。制作这些东西的人可能已经不在了；这些ofuda可能是为了从灾难中拯救自己而做的最后努力......或者是对未来可能偶然发现它们的人的警告。它通过未知的方法发出微弱的光芒。");
JEI.addDescription(<betterwithaddons:ancestry_bottle>,"从灵魂中提取的精神；原始生物几乎不存在。在杀死超自然的亡灵时，在你的物品栏存中保留一个瓶子，以便在它回到精神领域之前抢夺精神。");

/* Miscellaneous (and I mean TRUE miscellaneous) */
val arcaneBarrier = <dimstack:bedrock:0>;
val arcanePortal = <dimstack:portal>;
val dummy_fire = <contenttweaker:fire_block>;
val lodestone = <dungeontactics:mithril_block>;

JEI.addDescription(arcanePortal,"越过这些，你就会到达一些地方......");
JEI.addDescription(arcaneBarrier,"越过这些将把你带到黑暗的地方......");
JEI.addDescription(dummy_fire,"火! 曾经被认为是这样的，现在不能确定人类是第一个征服这种自然力量的文明，但他们仍然和以前一样善于充分利用它。使用手钻、火石和钢、火药......或更隐蔽的方法点燃火焰。更多时候，火最好是在受控的环境中使用，如火把、营火和熔炉。");
JEI.addDescription(lodestone, "具有磁性的神秘石头很久以前就被埋在寒冷的地方。挖掘它让你感觉很有趣...");
JEI.addDescription(<contenttweaker:scaffolding>, "一种摇摇欲坠的建筑材料，由比看上去更聪明的怪物扔在一起。很容易被清理掉。随着时间的推移，会被分解。");

/* Runes and Magic */
JEI.addDescription(<quark:rune:*>, "一个用于给物品上色的美学符文。与铁砧中的附魔物品结合，可以改变物品的闪光颜色。");

JEI.addDescription(<dungeontactics:magic_scroll>,"魔杖含有强大的魔力，随时可以根据法师的命令释放。为魔杖提供能量需要一种魔法粉末。学者们可以在指南中的 '魔法 '部分找到更多知识。");

JEI.addDescription(<dungeontactics:magic_powder>, "含有从各种来源获得的魔法的粉末。用魔杖施放强大的法术时需要这种魔法材料。");

#Runes
//JEI.addDescription(<ore:runeItem>,"符文是刻在石头上的符号，被赋予了自然界的某些方面，使其对某一元素具有特殊而强烈的魔法亲和力。它们的主要用途是作为其他魔法物品的催化剂或创造一次性使用的球体。");
JEI.addItem(<contenttweaker:blank_rune>);
JEI.addDescription(<contenttweaker:blank_rune>,"被魔法粉末浸泡过的石头。用作所有符文的基础。");
JEI.addItem(<contenttweaker:disint_rune>);
JEI.addDescription(<contenttweaker:disint_rune>,"用魔法物品进行制作，将其分解为魔力。");

JEI.addItem(<contenttweaker:sol_rune>);
JEI.addItem(<contenttweaker:luna_rune>);
JEI.addItem(<contenttweaker:air_rune>);
JEI.addItem(<contenttweaker:fire_rune>);
JEI.addItem(<contenttweaker:earth_rune>);
JEI.addItem(<contenttweaker:water_rune>);
JEI.addItem(<contenttweaker:balance_rune>);
JEI.addItem(<contenttweaker:chaos_rune>);
JEI.addItem(<contenttweaker:creation_rune>);
JEI.addItem(<contenttweaker:death_rune>);
JEI.addItem(<contenttweaker:energy_rune>);
JEI.addItem(<contenttweaker:illusion_rune>);
JEI.addItem(<contenttweaker:knowledge_rune>);
JEI.addItem(<contenttweaker:life_rune>);
JEI.addItem(<contenttweaker:mind_rune>);
JEI.addItem(<contenttweaker:nature_rune>);
JEI.addItem(<contenttweaker:order_rune>);
JEI.addItem(<contenttweaker:poison_rune>);
JEI.addItem(<contenttweaker:soul_rune>);
JEI.addItem(<contenttweaker:strength_rune>);
JEI.addItem(<contenttweaker:trans_rune>);
JEI.addItem(<contenttweaker:holding_rune>);
JEI.addItem(<contenttweaker:nether_rune>);
JEI.addItem(<contenttweaker:plague_rune>);
// JEI.addItem(<contenttweaker:time_rune>);
JEI.hide(<contenttweaker:time_rune>);
JEI.addItem(<contenttweaker:aether_rune>);
JEI.addItem(<contenttweaker:arcane_rune>);
JEI.addItem(<contenttweaker:draconic_rune>);
JEI.addItem(<contenttweaker:fae_rune>);
#Scepters
JEI.addDescription(<iceandfire:lich_staff>,"消耗耐久召唤出冰魂髑髅。可以使用灵魂灌注器中的灵魂进行充能。");
JEI.addDescription(<aether_legacy:cloud_staff>,"召唤两只迷你云护卫，将冰晶球射向你所指的方向。可以使用灵魂灌注器中的灵魂进行充能。");
JEI.addDescription(<defiledlands:tears_flame>,"蓄力后可向目标发射5个火球。可以使用灵魂灌注器中的灵魂进行充能。");

/* Hit with Axe */
JEI.addDescription(<hitwithaxe:debarked_magic>, "用斧头击打魔法木。");

/* Yeasts */
JEI.addDescription(<growthcraft_cellar:yeast>, "一种似乎是自然界中的基本酵母。它可以在任何生物群系中用任何可发酵的液体在发酵罐中培养，尽管在其他酵母菌可能蓬勃发展的生物群落中含量比例较低。把它放在发酵罐的输出槽中，将忽略生物群系确保只生产酿酒酵母。");
JEI.addDescription(<growthcraft_cellar:yeast:1>, "一种酵母，似乎能够制造出可爱的拉格啤酒。它可以在寒冷的生物群系中用任何可发酵的液体在发酵罐中培养，如泰加。把它放在发酵罐的输出槽中，将忽略生物群系确保只生产拉格酵母。");
JEI.addDescription(<growthcraft_cellar:yeast:2>, "一种似乎能够酿造出美妙的波特酒的酵母。它有时可以在收获葡萄时获得。将其置于发酵罐的输出槽中，将忽略生物群系确保只产生贝酵母。");
JEI.addDescription(<growthcraft_cellar:yeast:3>, "一种似乎具有神秘特性的酵母。它可以在神奇的生物群系中用任何可发酵的液体在发酵罐中培养，如神秘丛林。把它放在发酵罐的输出槽中，将忽略生物群系确保只生产乙醇酵母。");
JEI.addDescription(<growthcraft_cellar:yeast:4>, "一种看起来很像菌丝的酵母。它可以在蘑菇岛生物群系的任何可发酵液体的发酵罐中培养，如蘑菇岛。把它放在发酵罐的输出槽中，将忽略生物群系确保只生产原酵母。");

/* Misc */
JEI.addItem(<biomesoplenty:farmland_0:1>);