/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.FileBuffer;
import com.wb.common.Parser;
import com.wb.common.UrlBuffer;
import com.wb.common.Var;
import com.wb.tool.TaskManager;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Base
implements Filter {
    public static ServletContext servletContext;
    public static File path;
    public static int pathLen;
    public static File modulePath;
    public static String modulePathText;
    public static int modulePathLen;
    public static Date startTime;
    public static ConcurrentHashMap<String, Object> map;
    private static boolean initFailed;
    private static Throwable initError;

    static {
        map = new ConcurrentHashMap();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (initFailed) {
            throw new RuntimeException(initError);
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String url = req.getServletPath();
        String xwl = UrlBuffer.get(url);
        if (xwl != null) {
            request.setCharacterEncoding("utf-8");
            if (xwl.isEmpty()) {
                xwl = request.getParameter("xwl");
                if (xwl == null) {
                    resp.sendError(400, "null xwl");
                    return;
                }
                xwl = StringUtil.concat(xwl, ".xwl");
            }
            this.setRequest(req);
            Parser parser = new Parser(req, resp);
            parser.parse(xwl);
        } else {
            String lowerUrl = url.toLowerCase();
            if (lowerUrl.startsWith("/wb/modules/") || lowerUrl.startsWith("/wb/system/")) {
                resp.sendError(403, url);
            } else if (Var.cacheEnabled && lowerUrl.startsWith("/wb/")) {
                FileBuffer.service(url, req, resp);
            } else {
                chain.doFilter(request, response);
            }
        }
    }

    public void init(FilterConfig config) throws ServletException {
        try {
            startTime = new Date();
            servletContext = config.getServletContext();
            path = new File(servletContext.getRealPath("/"));
            pathLen = FileUtil.getPath(path).length() + 1;
            modulePath = new File(path, "wb/modules");
            modulePathText = FileUtil.getPath(modulePath);
            modulePathLen = modulePathText.length() + 1;
            SysUtil.reload(2);
            if (!Var.jndi.isEmpty()) {
                SysUtil.reload(3);
                TaskManager.start();
            }
        }
        catch (Throwable e) {
            initFailed = true;
            initError = e;
        }
    }

    private void setRequest(HttpServletRequest request) {
        request.setAttribute("sys.date", (Object)new Date());
        request.setAttribute("sys.id", (Object)SysUtil.getId());
        WebUtil.setLanguage(request);
    }

    public void destroy() {
        try {
            TaskManager.stop();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

