/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.ScriptBuffer;
import com.wb.common.Session;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.common.XwlBuffer;
import com.wb.controls.Control;
import com.wb.controls.ExtControl;
import com.wb.controls.ScriptControl;
import com.wb.interact.Controls;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.LogUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Parser {
    private StringBuilder headerHtml = new StringBuilder();
    private ArrayList<String> footerHtml = new ArrayList(15);
    private int htmlPointer;
    private StringBuilder headerScript = new StringBuilder();
    private ArrayList<String> footerScript = new ArrayList(15);
    private int scriptPointer;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private static final int RUN_NORMAL = 0;
    private static final int RUN_MODULE = 1;
    private static final int RUN_CONTROL = 2;
    private static final int RUN_INVOKE = 3;

    public Parser(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public void parse(String moduleFile) throws ServletException {
        boolean hasExcept = false;
        List<FileItem> fileItemList = null;
        ConcurrentHashMap<String, Object> varMap = null;
        try {
            try {
                varMap = new ConcurrentHashMap<String, Object>();
                this.request.setAttribute("sys.varMap", varMap);
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)this.request)) {
                    fileItemList = WebUtil.setUploadFile(this.request);
                }
                this.execute(moduleFile, this.request.getParameter("xwlt") == null ? 0 : 3, null);
            }
            catch (Throwable e) {
                hasExcept = true;
                WebUtil.showException(e, this.request, this.response);
                this.closeObjects(varMap, hasExcept);
                if (fileItemList != null) {
                    WebUtil.clearUploadFile(this.request, fileItemList);
                }
            }
        }
        finally {
            this.closeObjects(varMap, hasExcept);
            if (fileItemList != null) {
                WebUtil.clearUploadFile(this.request, fileItemList);
            }
        }
    }

    private void execute(String moduleFile, int runType, String xwlId) throws Exception {
        boolean createFrame;
        boolean runInvoke;
        JSONObject fullModule = XwlBuffer.get(moduleFile, false);
        JSONObject module = (JSONObject)((JSONArray)fullModule.opt("children")).opt(0);
        JSONObject configs = (JSONObject)module.opt("configs");
        boolean runNormal = runType == 0;
        boolean bl = runInvoke = runType == 3;
        if (runNormal || runInvoke) {
            String method = this.getString(configs, "method");
            String tokens = this.getString(configs, "tokens");
            if (!method.isEmpty() && !method.equalsIgnoreCase(this.request.getMethod())) {
                throw new IllegalArgumentException("Method not allowed");
            }
            if ((tokens.isEmpty() || !this.checkToken(tokens)) && Boolean.TRUE.equals(fullModule.opt("loginRequired"))) {
                if (!WebUtil.checkLogin(this.request, this.response)) {
                    return;
                }
                if (!XwlBuffer.canAccess(fullModule, Session.getRoles(this.request))) {
                    throw new Exception(Str.format(this.request, "forbidden", StringUtil.select(fullModule.optString("title"), FileUtil.getFilename(moduleFile)), moduleFile));
                }
            }
        }
        JSONObject events = (JSONObject)module.opt("events");
        JSONObject emptyJson = new JSONObject();
        JSONObject moduleGeneral = (JSONObject)Controls.get("module").opt("general");
        String theme = null;
        String touchTheme = null;
        boolean[] libTypes = null;
        boolean hasChildren = module.has("children");
        boolean hasEvents = events != null;
        HttpSession session = null;
        String content = this.getString(configs, "logMessage");
        if (!content.isEmpty()) {
            LogUtil.info(this.request, content);
        }
        if (!(content = this.getString(configs, "initScript")).isEmpty()) {
            ScriptBuffer.run(StringUtil.concat((String)configs.opt("id"), ".is"), content, this.request, this.response, moduleFile);
        }
        if (!(content = this.getString(configs, "serverMethod")).isEmpty()) {
            SysUtil.executeMethod(content, this.request, this.response);
        }
        if ((createFrame = this.getBool(configs, "createFrame", true)) && runNormal) {
            this.headerHtml.append("<!DOCTYPE html>\n<html>\n<head>\n<meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\"/>\n<meta name=\"description\" content=\"Welcome to www.putdb.com, we provide excellent solutions.\"/>\n<title>");
            String title = this.getString(configs, "title");
            if (title.isEmpty()) {
                title = fullModule.optString("title");
                if (title.startsWith("Str.")) {
                    title = Str.format(this.request, title.substring(4), new Object[0]);
                }
            } else if (title.equals("-")) {
                title = null;
            }
            if (!StringUtil.isEmpty(title)) {
                this.headerHtml.append(title);
            }
            this.headerHtml.append("</title>");
            this.appendScript(this.headerHtml, this.getString(configs, "head"));
            session = this.request.getSession(false);
            String string = theme = session == null ? null : (String)session.getAttribute("sys.theme");
            if (theme == null) {
                theme = Var.getString("sys.app.theme");
            }
            String string2 = touchTheme = session == null ? null : (String)session.getAttribute("sys.touchTheme");
            if (touchTheme == null) {
                touchTheme = Var.getString("sys.app.touchTheme");
            }
            libTypes = this.setLinks(configs, theme, touchTheme);
            String tagConfigs = this.getString(configs, "tagConfigs");
            if (tagConfigs.isEmpty()) {
                this.headerHtml.append("\n</head>\n<body>");
            } else {
                this.headerHtml.append("\n</head>\n<body ");
                this.headerHtml.append(tagConfigs);
                this.headerHtml.append('>');
            }
            this.headerScript.append("<script language=\"javascript\" type=\"text/javascript\">");
        }
        this.appendScript(this.headerHtml, this.getString(configs, "initHtml"));
        if (createFrame) {
            if (this.headerScript.length() > 0) {
                this.headerScript.append('\n');
            }
            if (runNormal && libTypes[1]) {
                this.headerScript.append("Ext.onReady(function(contextOptions,contextOwner){");
            } else if (runNormal && libTypes[2]) {
                this.headerScript.append("Ext.setup({");
                if (hasChildren) {
                    this.headerScript.append(this.getTouchViewport((JSONArray)module.opt("children"), moduleGeneral, runNormal));
                }
                this.headerScript.append("onReady:function(contextOptions,contextOwner){");
            } else {
                this.headerScript.append("(function(contextOptions,contextOwner){");
            }
            String namespace = (String)configs.opt("itemId");
            if (namespace.equals("module")) {
                this.headerScript.append("\nvar app={};");
            } else {
                this.headerScript.append("\nWb.ns(\"");
                this.headerScript.append(namespace);
                this.headerScript.append("\");\nvar app=");
                this.headerScript.append(namespace);
                this.headerScript.append(";");
            }
            if (runNormal && libTypes[2]) {
                this.headerScript.append("\nthis.appScope=app;\napp[this.itemId]=this;");
            }
            this.headerScript.append("\napp.contextOwner=contextOwner;");
            if (runNormal) {
                this.headerScript.append("\nwindow.app=app;\nWb.init({zo:");
                if (Var.useLocalTime) {
                    Calendar cal = Calendar.getInstance();
                    this.headerScript.append((cal.get(15) + cal.get(16)) / 60000);
                } else {
                    this.headerScript.append("-1");
                }
                if (Var.maskTimeout != 1500) {
                    this.headerScript.append(",mask:");
                    this.headerScript.append(Var.maskTimeout);
                }
                if (Var.ajaxTimeout != 0) {
                    this.headerScript.append(",timeout:");
                    this.headerScript.append(Var.ajaxTimeout);
                }
                if (!"gray".equals(theme)) {
                    this.headerScript.append(",theme:\"");
                    this.headerScript.append(theme);
                    this.headerScript.append('\"');
                }
                if (!"classic".equals(touchTheme)) {
                    this.headerScript.append(",touchTheme:\"");
                    this.headerScript.append(touchTheme);
                    this.headerScript.append('\"');
                }
                String string = theme = session == null ? null : (String)session.getAttribute("sys.editTheme");
                if (theme == null) {
                    theme = Var.getString("sys.ide.editTheme");
                }
                if (!"default".equals(theme)) {
                    this.headerScript.append(",editTheme:\"");
                    this.headerScript.append(theme);
                    this.headerScript.append('\"');
                }
                this.headerScript.append("});");
            } else if ((runType == 2 || runType == 1) && xwlId != null) {
                this.headerScript.append("\ncontextOwner[");
                this.headerScript.append(StringUtil.quote(xwlId));
                this.headerScript.append("]=app;");
            }
        }
        if (!(content = this.getString(configs, "importModules")).isEmpty()) {
            this.importModules(content);
        }
        if (!(content = this.getString(configs, "serverScript")).isEmpty()) {
            ScriptBuffer.run(StringUtil.concat((String)configs.opt("id"), ".ss"), content, this.request, this.response, moduleFile);
        }
        if (hasEvents) {
            String beforeunload = this.getString(events, "beforeunload");
            if (!beforeunload.isEmpty()) {
                this.appendScript(this.headerScript, StringUtil.concat("Wb.onUnload(function(){\n", beforeunload, "\n},contextOwner);"));
            }
            this.appendScript(this.headerScript, this.getString(events, "initialize"));
        }
        if (hasChildren) {
            this.scan(module, moduleGeneral, emptyJson, runNormal);
        }
        if (this.response.isCommitted()) {
            return;
        }
        this.appendScript(this.headerHtml, this.getString(configs, "finalHtml"));
        if (hasEvents) {
            this.appendScript(this.headerScript, this.getString(events, "finalize"));
        }
        if (createFrame) {
            if (runNormal) {
                if (libTypes[1]) {
                    this.headerScript.append("\n});");
                } else if (libTypes[2]) {
                    this.headerScript.append("\n}});");
                } else {
                    this.headerScript.append("\n})();");
                }
            } else if (runType == 2) {
                this.headerScript.append("\nreturn Wb.optMain(app);\n})(null,app)");
            } else if (runType == 1) {
                this.headerScript.append("\n})(null,app);");
            } else {
                this.headerScript.append("\nreturn app;\n})();");
            }
        }
        if (runNormal) {
            if (createFrame) {
                this.headerScript.append("\n</script>\n</body>\n</html>");
            }
            this.output();
        } else if (runInvoke) {
            this.output();
        }
    }

    private boolean checkToken(String tokens) {
        String[] ls;
        String token = this.request.getParameter("_token");
        if (StringUtil.isEmpty(token)) {
            return false;
        }
        String[] stringArray = ls = StringUtil.split(tokens, ",");
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (token.equals(s.trim())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void output() throws IOException {
        if (this.headerHtml.length() > 0 && this.headerScript.length() > 0) {
            this.headerHtml.append('\n');
        }
        this.headerHtml.append((CharSequence)this.headerScript);
        if (this.headerHtml.length() > 0) {
            if (WebUtil.jsonResponse(this.request)) {
                WebUtil.send(this.response, this.headerHtml.toString(), true);
            } else {
                WebUtil.send(this.response, this.headerHtml);
            }
        }
    }

    private void scan(JSONObject parentNode, JSONObject parentGeneral, JSONObject emptyJson, boolean normalType) throws Exception {
        JSONArray ja = (JSONArray)parentNode.opt("children");
        int j = ja.length();
        int k = j - 1;
        int i = 0;
        while (i < j) {
            boolean isScriptControl;
            Control control;
            JSONObject jo = (JSONObject)ja.opt(i);
            String type = (String)jo.opt("type");
            JSONObject meta = Controls.get(type);
            JSONObject general = (JSONObject)meta.opt("general");
            String className = (String)general.opt("class");
            if (className == null) {
                control = new ExtControl();
                isScriptControl = true;
            } else if (className.equals("null")) {
                control = null;
                isScriptControl = false;
                if (type.equals("xwl")) {
                    boolean rootParent = Boolean.TRUE.equals(parentGeneral.opt("root"));
                    this.addModule(jo, rootParent);
                    if (!rootParent && i < j - 1) {
                        this.headerScript.append(',');
                    }
                }
            } else {
                if (className.indexOf(46) == -1) {
                    className = "com.wb.controls." + className;
                }
                control = (Control)Class.forName(className).newInstance();
                isScriptControl = control instanceof ScriptControl;
            }
            if (control != null) {
                control.init(this.request, this.response, jo, meta, parentGeneral, i == k, normalType);
                control.create();
            }
            if (isScriptControl) {
                ScriptControl sc = (ScriptControl)control;
                this.appendScript(this.headerHtml, sc.getHeaderHtml());
                this.pushHtml(sc.getFooterHtml());
                this.appendScript(this.headerScript, sc.getHeaderScript());
                this.pushScript(sc.getFooterScript());
            }
            if (jo.has("children")) {
                this.scan(jo, general, emptyJson, normalType);
            }
            if (isScriptControl) {
                JSONObject configItems;
                this.appendScript(this.headerHtml, this.popHtml());
                String lastScript = this.popScript();
                int quoteIndex = lastScript.lastIndexOf(125);
                if (quoteIndex != -1 && (configItems = (JSONObject)jo.opt("__configs")) != null) {
                    this.appendScript(this.headerScript, lastScript.substring(0, quoteIndex));
                    this.headerScript.append(',');
                    this.scan(configItems, emptyJson, emptyJson, normalType);
                    this.appendScript(this.headerScript, lastScript.substring(quoteIndex));
                } else {
                    this.appendScript(this.headerScript, lastScript);
                }
            }
            ++i;
        }
    }

    private void addModule(JSONObject jo, boolean rootParent) throws Exception {
        JSONObject configs = (JSONObject)jo.opt("configs");
        String file = (String)configs.opt("file");
        if (file != null) {
            this.execute(FileUtil.getModuleFile(file), rootParent ? 1 : 2, (String)configs.opt("itemId"));
        }
    }

    private void pushHtml(String script) {
        ++this.htmlPointer;
        if (this.footerHtml.size() < this.htmlPointer) {
            this.footerHtml.add(script);
        } else {
            this.footerHtml.set(this.htmlPointer - 1, script);
        }
    }

    private String popHtml() {
        --this.htmlPointer;
        return this.footerHtml.get(this.htmlPointer);
    }

    private void pushScript(String script) {
        ++this.scriptPointer;
        if (this.footerScript.size() < this.scriptPointer) {
            this.footerScript.add(script);
        } else {
            this.footerScript.set(this.scriptPointer - 1, script);
        }
    }

    private String popScript() {
        --this.scriptPointer;
        return this.footerScript.get(this.scriptPointer);
    }

    private void appendScript(StringBuilder buf, String script) {
        if (!StringUtil.isEmpty(script)) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(script);
        }
    }

    private void importModules(String modules) throws Exception {
        JSONArray moduleArray = new JSONArray(modules);
        int j = moduleArray.length();
        int i = 0;
        while (i < j) {
            this.execute(FileUtil.getModuleFile((String)moduleArray.opt(i)), 1, null);
            ++i;
        }
    }

    private boolean[] setLinks(JSONObject configs, String theme, String touchTheme) {
        int index;
        String value;
        int i;
        int j;
        ArrayList<String> cssArray = new ArrayList<String>();
        ArrayList<String> jsArray = new ArrayList<String>();
        JSONArray cssLinks = null;
        JSONArray jsLinks = null;
        String loadJS = this.getString(configs, "loadJS");
        String lang = (String)this.request.getAttribute("sys.useLang");
        boolean[] libTypes = new boolean[4];
        String debugSuffix = Var.debug ? "-debug" : "";
        this.request.setAttribute("debugSuffix", (Object)debugSuffix);
        String cssLinksText = this.getString(configs, "cssLinks");
        String jsLinksText = this.getString(configs, "jsLinks");
        if (!cssLinksText.isEmpty()) {
            cssLinks = new JSONArray(cssLinksText);
        }
        if (!jsLinksText.isEmpty()) {
            jsLinks = new JSONArray(jsLinksText);
        }
        if (loadJS.isEmpty()) {
            loadJS = "ext";
        }
        jsArray.add(StringUtil.concat("wb/script/locale/wb-lang-", Str.optLanguage(lang), debugSuffix, ".js"));
        if (loadJS.indexOf("ext") != -1) {
            libTypes[1] = true;
            cssArray.add(StringUtil.concat("wb/libs/ext/resources/ext-theme-", theme, "/ext-theme-", theme, "-all", debugSuffix, ".css"));
            jsArray.add(StringUtil.concat("wb/libs/ext/ext-all", debugSuffix, ".js"));
            jsArray.add(StringUtil.concat("wb/libs/ext/locale/ext-lang-", Str.optExtLanguage(lang), debugSuffix, ".js"));
        }
        if (loadJS.indexOf("touch") != -1) {
            libTypes[2] = true;
            cssArray.add(StringUtil.concat("wb/libs/touch/resources/css/", touchTheme, debugSuffix, ".css"));
            jsArray.add(StringUtil.concat("wb/libs/touch/locale/t-lang-", Str.optTouchLanguage(lang), debugSuffix, ".js"));
            jsArray.add(StringUtil.concat("wb/libs/touch/sencha-touch-all", debugSuffix, ".js"));
        }
        if (loadJS.indexOf("bootstrap") != -1) {
            libTypes[3] = true;
            cssArray.add(StringUtil.concat("wb/libs/bs/css/bootstrap", debugSuffix, ".css"));
            jsArray.add(StringUtil.concat("wb/libs/jquery/jquery", debugSuffix, ".js"));
            jsArray.add(StringUtil.concat("wb/libs/bs/js/bootstrap", debugSuffix, ".js"));
        }
        if (loadJS.indexOf("jquery") != -1) {
            jsArray.add("wb/libs/jquery/jquery" + debugSuffix + ".js");
        }
        cssArray.add(StringUtil.concat("wb/css/style", debugSuffix, ".css"));
        jsArray.add(StringUtil.concat("wb/script/wb", debugSuffix, ".js"));
        if (cssLinks != null) {
            j = cssLinks.length();
            i = 0;
            while (i < j) {
                value = cssLinks.getString(i);
                index = cssArray.indexOf(value);
                if (index != -1) {
                    cssArray.remove(index);
                }
                cssArray.add(value);
                ++i;
            }
        }
        if (jsLinks != null) {
            j = jsLinks.length();
            i = 0;
            while (i < j) {
                value = jsLinks.getString(i);
                index = jsArray.indexOf(value);
                if (index != -1) {
                    jsArray.remove(index);
                }
                jsArray.add(value);
                ++i;
            }
        }
        for (String css : cssArray) {
            this.headerHtml.append("\n<link type=\"text/css\" rel=\"stylesheet\" href=\"");
            this.headerHtml.append(css);
            this.headerHtml.append("\">");
        }
        for (String js : jsArray) {
            this.headerHtml.append("\n<script type=\"text/javascript\" src=\"");
            this.headerHtml.append(js);
            this.headerHtml.append("\"></script>");
        }
        return libTypes;
    }

    private String getString(JSONObject object, String name) {
        String value = (String)object.opt(name);
        if (value == null) {
            return "";
        }
        return WebUtil.replaceParams(this.request, value);
    }

    private boolean getBool(JSONObject object, String name, boolean defaultValue) {
        String value = this.getString(object, name);
        if (value.isEmpty()) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    private void closeObjects(ConcurrentHashMap<String, Object> map, boolean isExcept) {
        Set<Map.Entry<String, Object>> es = map.entrySet();
        ArrayList<Connection> connList = new ArrayList<Connection>();
        ArrayList<Statement> stList = new ArrayList<Statement>();
        for (Map.Entry<String, Object> e : es) {
            Object object = e.getValue();
            if (object == null) continue;
            if (object instanceof ResultSet) {
                DbUtil.close((ResultSet)object);
                continue;
            }
            if (object instanceof Statement) {
                stList.add((Statement)object);
                continue;
            }
            if (object instanceof Connection) {
                connList.add((Connection)object);
                continue;
            }
            if (object instanceof InputStream) {
                IOUtils.closeQuietly((InputStream)((InputStream)object));
                continue;
            }
            if (!(object instanceof OutputStream)) continue;
            IOUtils.closeQuietly((OutputStream)((OutputStream)object));
        }
        for (Statement st : stList) {
            DbUtil.close(st);
        }
        for (Connection conn : connList) {
            DbUtil.close(conn, isExcept);
        }
    }

    private String getTouchViewport(JSONArray items, JSONObject parentGeneral, boolean normalType) throws Exception {
        if (items == null) {
            return "";
        }
        JSONObject meta = Controls.get("tviewport");
        StringBuilder script = new StringBuilder();
        int j = items.length();
        int k = j - 1;
        int i = 0;
        while (i < j) {
            JSONObject jo = (JSONObject)items.opt(i);
            if ("tviewport".equals(jo.opt("type"))) {
                ExtControl control = new ExtControl();
                control.normalMode = false;
                control.init(this.request, this.response, jo, meta, parentGeneral, i == k, normalType);
                control.create();
                script.append("\nviewport:");
                script.append(control.getHeaderScript());
                script.append(control.getFooterScript());
                script.append(',');
                return script.toString();
            }
            ++i;
        }
        return "";
    }
}

