/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.util.DbUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.servlet.http.HttpServletRequest;

public class Resource {
    public static String getString(HttpServletRequest request, String id, String defaultValue) {
        return Resource.getString(WebUtil.getIdWithUser(request, id), defaultValue);
    }

    public static String getString(String id, String defaultValue) {
        try {
            byte[] bytes = Resource.getBytes(id, null);
            if (bytes == null) {
                return defaultValue;
            }
            return new String(bytes, "utf-8");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String getString(String id) {
        return Resource.getString(id, null);
    }

    public static byte[] getBytes(HttpServletRequest request, String id, byte[] defaultValue) {
        return Resource.getBytes(WebUtil.getIdWithUser(request, id), defaultValue);
    }

    public static byte[] getBytes(String id, byte[] defaultValue) {
        byte[] result = DbUtil.getBytes("select RES_CONTENT from WB_RESOURCE where RES_ID=?", id);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static void set(HttpServletRequest request, String id, String data) {
        Resource.set(WebUtil.getIdWithUser(request, id), data);
    }

    public static void set(String id, String data) {
        try {
            byte[] bytes = data == null ? (byte[])null : data.getBytes("utf-8");
            Resource.set(id, bytes);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void remove(String id) {
        Resource.set(id, null);
    }

    public static void remove(HttpServletRequest request, String id) {
        Resource.set(request, id, null);
    }

    public static void set(String id, byte[] data) {
        Connection conn = null;
        PreparedStatement st = null;
        boolean hasData = data != null;
        try {
            try {
                conn = DbUtil.getConnection();
                if (hasData) {
                    conn.setAutoCommit(false);
                }
                st = conn.prepareStatement("delete from WB_RESOURCE where RES_ID=?");
                st.setString(1, id);
                st.executeUpdate();
                DbUtil.close(st);
                st = null;
                if (hasData) {
                    st = conn.prepareStatement("insert into WB_RESOURCE values(?,?)");
                    st.setString(1, id);
                    st.setBinaryStream(2, (InputStream)new ByteArrayInputStream(data), data.length);
                    st.executeUpdate();
                    conn.commit();
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(st);
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(st);
        DbUtil.close(conn);
    }

    public static void set(HttpServletRequest request, String id, byte[] data) {
        Resource.set(WebUtil.getIdWithUser(request, id), data);
    }
}

