/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.SimpleListener;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.tool.Encrypter;
import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class Session {
    public static ConcurrentHashMap<String, HashSet<HttpSession>> userList = new ConcurrentHashMap();
    private static Object lock = new Object();

    public static void verify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String referer = request.getHeader("Referer");
        HttpSession session = request.getSession(false);
        if (Var.getBool("sys.session.verifyImage.enabled")) {
            if (session == null) {
                throw new Exception(Str.format(request, "vcExpired", new Object[0]));
            }
            String verifyCode = (String)session.getAttribute("sys.verifyCode");
            session.removeAttribute("sys.verifyCode");
            if (StringUtil.isEmpty(verifyCode) || !StringUtil.isSame(verifyCode, request.getParameter("verifyCode"))) {
                throw new Exception(Str.format(request, "vcInvalid", new Object[0]));
            }
        }
        if (session != null) {
            session.invalidate();
        }
        Session.createSession(request);
        if (referer.endsWith("/login") || referer.endsWith("m?xwl=sys/session/login")) {
            referer = Var.getString("sys.home");
        }
        if (referer.endsWith("/tlogin") || referer.endsWith("m?xwl=sys/session/tlogin")) {
            referer = Var.getString("sys.homeMobile");
        }
        WebUtil.send(response, referer);
    }

    public static void getSessionList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String user = request.getParameter("user");
        int start = Integer.parseInt(request.getParameter("start"));
        int limit = Integer.parseInt(request.getParameter("limit"));
        int index = -1;
        JSONArray rows = new JSONArray();
        HashSet<HttpSession> sessions = userList.get(user);
        if (limit > Var.limitRecords) {
            limit = Var.limitRecords;
        }
        int end = start + limit;
        if (sessions != null) {
            for (HttpSession session : sessions) {
                if (++index < start || index == end) continue;
                JSONObject row = new JSONObject();
                row.put("ip", session.getAttribute("sys.ip"));
                row.put("userAgent", session.getAttribute("sys.userAgent"));
                row.put("createDate", (Object)new Date(session.getCreationTime()));
                row.put("lastAccessDate", (Object)new Date(session.getLastAccessedTime()));
                rows.put((Object)row);
            }
        }
        JSONObject result = new JSONObject();
        result.put("rows", (Object)rows);
        result.put("total", index + 1);
        WebUtil.send(response, result);
    }

    public static void getUserList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int start = Integer.parseInt(request.getParameter("start"));
        int limit = Integer.parseInt(request.getParameter("limit"));
        int index = -1;
        JSONArray rows = new JSONArray();
        Set<Map.Entry<String, HashSet<HttpSession>>> es = userList.entrySet();
        if (limit > Var.limitRecords) {
            limit = Var.limitRecords;
        }
        int end = start + limit;
        for (Map.Entry<String, HashSet<HttpSession>> e : es) {
            if (++index < start || index == end) continue;
            HashSet<HttpSession> sessions = e.getValue();
            int sessionCount = 0;
            HttpSession session = null;
            for (HttpSession sess : sessions) {
                if (session == null) {
                    session = sess;
                }
                ++sessionCount;
            }
            if (sessionCount == 0) continue;
            JSONObject row = new JSONObject();
            row.put("sessionCount", sessionCount);
            row.put("user", (Object)e.getKey());
            row.put("username", session.getAttribute("sys.username"));
            row.put("dispname", session.getAttribute("sys.dispname"));
            row.put("ip", session.getAttribute("sys.ip"));
            row.put("userAgent", session.getAttribute("sys.userAgent"));
            rows.put((Object)row);
        }
        JSONObject result = new JSONObject();
        result.put("rows", (Object)rows);
        result.put("total", index + 1);
        WebUtil.send(response, result);
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public static String[] getRoles(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (String[])session.getAttribute("sys.roles");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSession(HttpServletRequest request) throws Exception {
        int timeout = Var.sessionTimeout;
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        ResultSet rs = (ResultSet)DbUtil.run(request, "select USER_ID,DISPLAY_NAME,PASSWORD,USE_LANG from WB_USER where USER_NAME={?username?} and STATUS=1");
        if (!rs.next()) {
            throw new IllegalArgumentException(Str.format(request, "userNotExist", username));
        }
        String userId = rs.getString("USER_ID");
        String dispname = rs.getString("DISPLAY_NAME");
        String useLang = rs.getString("USE_LANG");
        if (!rs.getString("PASSWORD").equals(Encrypter.getMD5(password))) {
            throw new IllegalArgumentException(Str.format(request, "passwordInvalid", new Object[0]));
        }
        HttpSession session = request.getSession(true);
        session.setAttribute("sys.logined", (Object)true);
        if (timeout == -1) {
            timeout = Integer.MAX_VALUE;
        }
        if (timeout > 0) {
            session.setMaxInactiveInterval(timeout);
        }
        session.setAttribute("sys.user", (Object)userId);
        session.setAttribute("sys.username", (Object)username);
        session.setAttribute("sys.dispname", (Object)dispname);
        session.setAttribute("sys.userAgent", (Object)StringUtil.substring(request.getHeader("user-agent"), 0, 500));
        session.setAttribute("sys.ip", (Object)request.getRemoteAddr());
        session.setAttribute("sys.lang", (Object)StringUtil.select(useLang, "auto"));
        DbUtil.run(request, "update WB_USER set LOGIN_TIMES=LOGIN_TIMES+1 where USER_ID={?sys.user?}");
        Session.storeUserValues(request, session, userId);
        SimpleListener simpleListener = new SimpleListener();
        if (Var.uniqueLogin) {
            String[] usernames = new String[]{username};
            Object object = lock;
            synchronized (object) {
                Session.removeSession(usernames);
                session.setAttribute("simpleListener", (Object)simpleListener);
            }
        } else {
            session.setAttribute("simpleListener", (Object)simpleListener);
        }
    }

    private static void storeUserValues(HttpServletRequest request, HttpSession session, String userId) throws Exception {
        String[] names = Var.sessionVars.split(",");
        String[] valueIds = new String[names.length];
        ArrayList<String> roles = new ArrayList<String>();
        int i = 0;
        ResultSet rs = (ResultSet)DbUtil.run(request, "select ROLE_ID from WB_USER_ROLE where USER_ID={?sys.user?} and ROLE_ID<>'default'");
        roles.add("default");
        while (rs.next()) {
            roles.add(rs.getString(1));
        }
        session.setAttribute("sys.roles", (Object)roles.toArray(new String[roles.size()]));
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            valueIds[i++] = StringUtil.concat("'", name, "@", userId, "'");
            ++n2;
        }
        rs = (ResultSet)DbUtil.run(request, "select VAL_ID,VAL_CONTENT from WB_VALUE where VAL_ID in (" + StringUtil.join(valueIds, ',') + ")");
        while (rs.next()) {
            String fieldName = rs.getString("VAL_ID");
            fieldName = StringUtil.substring(fieldName, 0, fieldName.indexOf(64));
            String fieldValue = rs.getString("VAL_CONTENT");
            session.setAttribute("sys." + fieldName, (Object)fieldValue);
        }
    }

    public static void removeSession(String[] userIds) {
        if (!Var.recordSession) {
            return;
        }
        String[] stringArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            String userId = stringArray[n2];
            HashSet<HttpSession> sessions = userList.get(userId);
            if (sessions != null) {
                HttpSession[] sessionArray = new HttpSession[sessions.size()];
                int i = 0;
                for (HttpSession session : sessions) {
                    sessionArray[i++] = session;
                }
                HttpSession[] httpSessionArray = sessionArray;
                int n3 = sessionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    HttpSession session;
                    session = httpSessionArray[n4];
                    session.invalidate();
                    ++n4;
                }
                userList.remove(userId);
            }
            ++n2;
        }
    }

    public static void updateSession(String userId, String[] roles, boolean status) {
        if (!Var.recordSession) {
            return;
        }
        HashSet<HttpSession> sessions = userList.get(userId);
        if (sessions != null) {
            if (status) {
                for (HttpSession session : sessions) {
                    session.setAttribute("sys.roles", (Object)roles);
                }
            } else {
                String[] userIds = new String[]{userId};
                Session.removeSession(userIds);
            }
        }
    }
}

