/*
 * Decompiled with CFR 0.152.
 */
package com.wb.common;

import com.wb.common.Base;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Var {
    public static boolean uncheckModified;
    public static boolean sendStreamGzip;
    public static int sendGzipMinSize;
    public static boolean printError;
    public static boolean log;
    public static boolean taskLog;
    public static int limitRecords;
    public static int limitExportRecords;
    public static int gzipMinSize;
    public static boolean cacheEnabled;
    public static int cacheMaxAge;
    public static boolean debug;
    public static boolean homeShowApp;
    public static boolean consolePrint;
    public static boolean batchUpdate;
    public static int sessionTimeout;
    public static boolean uniqueLogin;
    public static int ajaxTimeout;
    public static int maskTimeout;
    public static boolean useLocalTime;
    public static boolean recordSession;
    public static String syncPath;
    public static String jndi;
    public static String language;
    public static String defaultLanguage;
    public static String urlEncoding;
    public static String sessionVars;
    public static final File file;
    public static ConcurrentHashMap<String, Object> buffer;

    static {
        file = new File(Base.path, "wb/system/var.json");
    }

    public static Object get(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new NullPointerException("Var name \"" + name + "\" can not be blank");
        }
        Object val = buffer.get(name);
        if (val == null) {
            throw new NullPointerException("Var \"" + name + "\" does not exist");
        }
        return val;
    }

    public static String getString(String name) {
        return Var.get(name).toString();
    }

    public static int getInt(String name) {
        Object val = Var.get(name);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        throw new RuntimeException("Var \"" + name + "\" is not an integer value");
    }

    public static double getDouble(String name) {
        Object val = Var.get(name);
        if (val instanceof Double) {
            return (Double)val;
        }
        throw new RuntimeException("Var \"" + name + "\" is not a double value");
    }

    public static boolean getBool(String name) {
        Object val = Var.get(name);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        throw new RuntimeException("Var \"" + name + "\" is not a boolean value");
    }

    public static synchronized void set(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("Null variable name");
        }
        if (value == null) {
            throw new NullPointerException("Null variable value");
        }
        try {
            JSONObject object = JsonUtil.readObject(file);
            Object valObject = JsonUtil.getValue(object, name, '.');
            if (!(valObject instanceof JSONArray)) {
                throw new RuntimeException("\"" + name + "\" is not a variable.");
            }
            JSONArray valArray = (JSONArray)valObject;
            valArray.put(0, value);
            FileUtil.syncSave(file, object.toString(2));
            buffer.put(name, value);
            Var.loadBasicVars();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void load() {
        try {
            buffer = new ConcurrentHashMap();
            JSONObject object = JsonUtil.readObject(file);
            Var.getValues(object, "");
            Var.loadBasicVars();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static void getValues(JSONObject object, String parentName) {
        Set items = object.entrySet();
        for (Map.Entry item : items) {
            Object value = item.getValue();
            String name = String.valueOf(parentName) + (String)item.getKey();
            if (value instanceof JSONObject) {
                Var.getValues((JSONObject)value, String.valueOf(name) + '.');
                continue;
            }
            JSONArray jsonArray = (JSONArray)value;
            if ("double".equals(jsonArray.getJSONObject(2).opt("type"))) {
                buffer.put(name, ((Number)jsonArray.opt(0)).doubleValue());
                continue;
            }
            buffer.put(name, jsonArray.opt(0));
        }
    }

    public static void loadBasicVars() {
        uncheckModified = !Var.getBool("sys.cache.checkModified");
        sendStreamGzip = Var.getBool("sys.sendStreamGzip");
        sendGzipMinSize = Var.getInt("sys.sendGzipMinSize");
        printError = Var.getBool("sys.printError");
        log = Var.getBool("sys.log");
        taskLog = Var.getBool("sys.task.log");
        limitRecords = Var.getInt("sys.controls.limitRecords");
        limitExportRecords = Var.getInt("sys.controls.limitExportRecords");
        gzipMinSize = Var.getInt("sys.cache.gzipMinSize");
        cacheEnabled = Var.getBool("sys.cache.enabled");
        cacheMaxAge = Var.getInt("sys.cache.maxAge");
        debug = Var.getBool("sys.debug");
        homeShowApp = Var.getBool("sys.app.homeShowApp");
        consolePrint = Var.getBool("sys.ide.consolePrint");
        batchUpdate = Var.getBool("sys.db.batchUpdate");
        sessionTimeout = Var.getInt("sys.session.sessionTimeout");
        uniqueLogin = Var.getBool("sys.session.uniqueLogin");
        ajaxTimeout = Var.getInt("sys.session.ajaxTimeout");
        maskTimeout = Var.getInt("sys.session.maskTimeout");
        useLocalTime = Var.getBool("sys.locale.useLocalTime");
        recordSession = Var.getBool("sys.session.recordSession");
        syncPath = Var.getString("sys.ide.syncPath");
        jndi = Var.getString("sys.jndi.default");
        language = Var.getString("sys.locale.language");
        defaultLanguage = Var.getString("sys.locale.defaultLanguage");
        urlEncoding = Var.getString("sys.locale.urlEncoding");
        sessionVars = Var.getString("sys.session.sessionVars");
    }
}

