/*
 * Decompiled with CFR 0.152.
 */
package com.wb.controls;

import com.wb.controls.Control;
import com.wb.tool.DataProvider;
import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.sql.ResultSet;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class DpControl
extends Control {
    @Override
    public void create() throws Exception {
        long endIndex;
        long beginIndex;
        if (this.gb("disabled", false)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        Long totalCount = null;
        String jndi = this.gs("jndi");
        String limitRecords = this.gs("limitRecords");
        String limitExportRecords = this.gs("limitExportRecords");
        String startParam = this.request.getParameter("start");
        String limitParam = this.request.getParameter("limit");
        String type = this.gs("type");
        if (StringUtil.isEmpty(type) || "array".equals(type)) {
            this.setOrderVars();
        }
        String sql = this.gs("sql");
        String totalSql = this.gs("totalSql");
        if (StringUtil.isEmpty(startParam)) {
            beginIndex = 1L;
            this.request.setAttribute("start", (Object)0L);
        } else {
            beginIndex = Long.parseLong(startParam) + 1L;
        }
        if (StringUtil.isEmpty(limitParam)) {
            endIndex = Long.MAX_VALUE;
            this.request.setAttribute("limit", (Object)endIndex);
        } else {
            endIndex = beginIndex + Long.parseLong(limitParam) - 1L;
        }
        this.request.setAttribute("beginIndex", (Object)beginIndex);
        this.request.setAttribute("endIndex", (Object)endIndex);
        Object result = this.getResult(DbUtil.run(this.request, sql, jndi));
        if (!(result instanceof ResultSet)) {
            WebUtil.send(this.response, StringUtil.concat("{\"total\":1,\"metaData\":{\"fields\":[{\"name\":\"result\",\"type\":\"string\"}]},\"columns\":[{\"xtype\":\"rownumberer\",\"width\":40},{\"dataIndex\":\"result\",flex:1,\"text\":\"result\"}],\"rows\":[{\"result\":", StringUtil.quote(result.toString()), "}],\"elapsed\":", Long.toString(System.currentTimeMillis() - startTime), "}"));
            return;
        }
        ResultSet resultSet = (ResultSet)result;
        if (!StringUtil.isEmpty(totalSql)) {
            ResultSet totalResultSet = (ResultSet)this.getResult(DbUtil.run(this.request, totalSql, jndi));
            if (totalResultSet == null) {
                throw new NullPointerException("No ResultSet in the totalSql.");
            }
            if (totalResultSet.next()) {
                totalCount = Long.parseLong(totalResultSet.getString(1));
            } else {
                throw new NullPointerException("Empty total ResultSet.");
            }
        }
        DataProvider dp = new DataProvider();
        dp.startTime = startTime;
        dp.request = this.request;
        dp.response = this.response;
        dp.resultSet = resultSet;
        dp.fields = this.gs("fields");
        dp.fieldsTag = this.gs("fieldsTag");
        dp.totalCount = totalCount;
        dp.createColumns = this.gb("createColumns", true);
        if (this.gb("autoPage", true)) {
            dp.beginIndex = beginIndex;
            dp.endIndex = endIndex;
        }
        if (!limitRecords.isEmpty()) {
            dp.limitRecords = Integer.parseInt(limitRecords);
        }
        if (!limitExportRecords.isEmpty()) {
            dp.limitExportRecords = Integer.parseInt(limitExportRecords);
        }
        dp.tag = this.gs("tag");
        dp.type = type;
        String dictTableNames = this.gs("dictTableNames");
        dp.createKeyValues = this.gb("createKeyValues", false);
        dp.dictTableNames = dictTableNames.isEmpty() ? null : StringUtil.split(dictTableNames, ',', true);
        dp.dictFieldsMap = this.gs("dictFieldsMap");
        dp.output();
    }

    private Object getResult(Object result) {
        if (result instanceof HashMap) {
            HashMap map = (HashMap)result;
            Object val = map.get("result");
            if (val instanceof ResultSet) {
                return val;
            }
            return map.get("return");
        }
        return result;
    }

    private void setOrderVars() throws Exception {
        String sort = this.request.getParameter("sort");
        if (StringUtil.isEmpty(sort) || this.request.getAttribute("sql.orderBy") != null) {
            return;
        }
        JSONArray ja = new JSONArray(sort);
        int j = ja.length();
        if (j > 0) {
            String defaultPrefix;
            JSONObject orderJo;
            StringBuilder exp = new StringBuilder();
            String orderFields = this.gs("orderFields");
            if (StringUtil.isEmpty(orderFields)) {
                orderJo = null;
                defaultPrefix = null;
            } else {
                orderJo = new JSONObject(orderFields);
                defaultPrefix = orderJo.optString("default", null);
            }
            int i = 0;
            while (i < j) {
                String property;
                JSONObject jo = ja.getJSONObject(i);
                if (i > 0) {
                    exp.append(',');
                }
                if (!StringUtil.checkName(property = jo.getString("property"))) {
                    throw new IllegalArgumentException("Invalid name \"" + property + "\".");
                }
                if (orderJo != null) {
                    if (orderJo.has(property)) {
                        String prefix = orderJo.optString(property);
                        if (!prefix.isEmpty()) {
                            exp.append(prefix);
                            exp.append('.');
                        }
                    } else if (defaultPrefix != null) {
                        exp.append(defaultPrefix);
                        exp.append('.');
                    }
                }
                exp.append(property);
                if (StringUtil.isSame(jo.optString("direction"), "desc")) {
                    exp.append(" desc");
                }
                ++i;
            }
            this.request.setAttribute("sql.orderBy", (Object)(" order by " + exp));
            this.request.setAttribute("sql.orderFields", (Object)("," + exp));
        }
    }
}

