/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.common.Base;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.SortUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class DBE {
    public static void getTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String jndi = request.getParameter("jndi");
        boolean hasSchem = Boolean.parseBoolean(request.getParameter("hasSchem"));
        WebUtil.send(response, StringUtil.isEmpty(jndi) ? DBE.getDbList() : DBE.getTableList(jndi, hasSchem, null));
    }

    public static void checkSelectSql(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String sql = request.getParameter("sql");
        String[] roles = (String[])WebUtil.fetchObject(request, "sys.roles");
        if (!(StringUtil.indexOf(roles, "demo") == -1 || StringUtil.indexOf(roles, "admin") != -1 || sql.startsWith("select * from ") && StringUtil.checkName(sql.substring(14), true) && !sql.substring(14).equalsIgnoreCase("WB_USER"))) {
            SysUtil.accessDenied();
        }
    }

    public static String getDbList() throws Exception {
        JSONObject config = JsonUtil.readObject(new File(Base.path, "wb/system/var.json"));
        HashMap<String, String> map = new HashMap<String, String>();
        config = config.optJSONObject("sys").optJSONObject("jndi");
        Set es = config.entrySet();
        JSONArray ja = new JSONArray();
        String defaultJndi = config.optJSONArray("default").optString(0);
        config.remove("default");
        for (Map.Entry entry : es) {
            String key = (String)entry.getKey();
            map.put(key, ((JSONArray)entry.getValue()).optString(0));
        }
        ArrayList sortedItems = SortUtil.sortKey(map);
        JSONObject jo = new JSONObject();
        jo.put("text", (Object)"default");
        jo.put("jndi", (Object)defaultJndi);
        jo.put("iconCls", (Object)"db_icon");
        ja.put((Object)jo);
        for (Map.Entry entry : sortedItems) {
            jo = new JSONObject();
            jo.put("text", entry.getKey());
            jo.put("jndi", entry.getValue());
            jo.put("iconCls", (Object)"db_icon");
            ja.put((Object)jo);
        }
        return ja.toString();
    }

    public static String getTableList(String jndi, boolean hasSchem, HashSet<String> tables) throws Exception {
        String string;
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        boolean isFirst = true;
        boolean hasTableDefine = tables != null;
        String[] types = new String[]{"TABLE"};
        StringBuilder buf = new StringBuilder();
        HashMap<String, String> tableMap = new HashMap<String, String>();
        try {
            String tableSchem;
            String tableName;
            boolean isOracle;
            conn = DbUtil.getConnection(jndi);
            boolean bl = isOracle = conn.getMetaData().getDatabaseProductName().toLowerCase().indexOf("oracle") != -1;
            if (isOracle) {
                st = conn.createStatement();
                rs = st.executeQuery("select TABLE_NAME,TABLESPACE_NAME from user_tables");
            } else {
                rs = conn.getMetaData().getTables(null, null, null, types);
            }
            while (rs.next()) {
                if (isOracle) {
                    tableName = rs.getString(1);
                    tableSchem = StringUtil.opt(rs.getString(2));
                } else {
                    tableSchem = StringUtil.opt(rs.getString(2));
                    tableName = rs.getString(3);
                }
                tableMap.put(tableName, tableSchem);
            }
            ArrayList sortedEntries = SortUtil.sortKey(tableMap);
            buf.append('[');
            for (Map.Entry entry : sortedEntries) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(',');
                }
                tableName = (String)entry.getKey();
                tableSchem = (String)entry.getValue();
                buf.append("{\"text\":\"");
                if (hasSchem && !StringUtil.isEmpty(tableSchem)) {
                    buf.append(tableSchem);
                    buf.append('.');
                }
                buf.append(tableName);
                buf.append("\",\"table\":\"");
                buf.append(tableName);
                buf.append("\",\"schem\":\"");
                buf.append(tableSchem);
                buf.append("\",\"leaf\":true,\"iconCls\":\"");
                String upperTableName = tableName.toUpperCase();
                if (hasTableDefine && tables.contains(upperTableName)) {
                    tables.remove(upperTableName);
                    buf.append("table_add_icon\"}");
                    continue;
                }
                buf.append("table_icon\"}");
            }
            if (hasTableDefine) {
                for (String fullName : tables) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        buf.append(',');
                    }
                    buf.append("{\"text\":\"");
                    buf.append(fullName);
                    buf.append("\",\"table\":\"");
                    buf.append(fullName);
                    buf.append("\",\"schem\":\"\",\"leaf\":true,\"iconCls\":\"table_delete_icon\"}");
                }
            }
            buf.append(']');
            string = buf.toString();
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        DbUtil.close(conn);
        return string;
    }

    public static void downloadBlob(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String jndi = request.getParameter("__jndi");
        String tableName = request.getParameter("__tableName");
        String fieldName = request.getParameter("__fieldName");
        String selectSql = DbUtil.buildSQLs(jndi, tableName, false, 1, null, new JSONObject().put(fieldName, 1), null, null)[3];
        ResultSet rs = (ResultSet)DbUtil.run(request, selectSql, jndi);
        DbUtil.outputBlob(rs, request, response, "download");
    }

    public static void uploadBlob(HttpServletRequest request, HttpServletResponse response) throws Exception {
        DBE.setBlob(request, false);
    }

    public static void clearBlob(HttpServletRequest request, HttpServletResponse response) throws Exception {
        DBE.setBlob(request, true);
    }

    private static void setBlob(HttpServletRequest request, boolean isClear) throws Exception {
        String jndi = WebUtil.fetch(request, "__jndi");
        String tableName = WebUtil.fetch(request, "__tableName");
        String fieldName = WebUtil.fetch(request, "__fieldName");
        if (isClear) {
            request.setAttribute(fieldName, (Object)"");
        } else {
            request.setAttribute(fieldName, request.getAttribute("file"));
        }
        String updateSql = DbUtil.buildSQLs(jndi, tableName, false, 1, null, new JSONObject().put(fieldName, 1), null, null)[1];
        DbUtil.run(request, updateSql, jndi);
    }
}

