/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.tool.CustomResponse;
import com.wb.tool.DataOutput;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class FilePush {
    public static void getFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filename = WebUtil.fetch(request, "filename");
        String data = WebUtil.fetch(request, "data");
        boolean gzip = Boolean.parseBoolean(WebUtil.fetch(request, "gzip"));
        if (filename == null) {
            filename = gzip ? "data.gz" : "data";
        }
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, filename));
        if (gzip) {
            GZIPOutputStream gos = new GZIPOutputStream((OutputStream)response.getOutputStream());
            try {
                gos.write(data.getBytes("utf-8"));
            }
            finally {
                gos.close();
            }
            response.flushBuffer();
        } else {
            WebUtil.send(response, data);
        }
    }

    public static void writeFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filename = WebUtil.fetch(request, "filename");
        String data = WebUtil.fetch(request, "data");
        boolean gzip = Boolean.parseBoolean(WebUtil.fetch(request, "gzip"));
        File file = new File(filename);
        if (file.exists()) {
            throw new Exception("\u6587\u4ef6 \u201c" + filename + "\u201d \u5df2\u7ecf\u5b58\u5728\u3002");
        }
        if (gzip) {
            FileOutputStream fos = null;
            GZIPOutputStream gos = null;
            try {
                fos = new FileOutputStream(file);
                gos = new GZIPOutputStream(fos);
                gos.write(data.getBytes("utf-8"));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gos);
                fos.close();
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)gos);
            fos.close();
        } else {
            FileUtil.writeString(file, data);
        }
    }

    public static void transfer(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray records;
        String fileExtName;
        JSONObject metaParams = new JSONObject(request.getParameter("__metaParams"));
        boolean isHtml = false;
        String type = metaParams.optString("type");
        if ("excel".equals(type)) {
            fileExtName = DataOutput.getExtName();
        } else if ("text".equals(type)) {
            fileExtName = ".txt";
        } else if ("html".equals(type)) {
            fileExtName = ".html";
            isHtml = true;
        } else {
            throw new IllegalArgumentException("Invalid request file type.");
        }
        String data = metaParams.optString("data", null);
        if (data == null) {
            CustomResponse resp = new CustomResponse(response);
            request.setAttribute("sys.rowOnly", (Object)1);
            request.setAttribute("sys.fromExport", (Object)1);
            WebUtil.include(request, resp, metaParams.optString("url"));
            String respText = FilePush.getResponseString(resp);
            if (respText.startsWith("<textarea>")) {
                data = respText.substring(10, respText.length() - 11);
                JSONObject responseObject = new JSONObject(data);
                data = (String)responseObject.opt("value");
                if (!responseObject.optBoolean("success")) {
                    WebUtil.send(response, data, false);
                    return;
                }
            } else {
                if (!(respText = respText.trim()).startsWith("{") || !respText.endsWith("}")) {
                    WebUtil.send(response, respText, false);
                    return;
                }
                data = respText;
            }
            records = new JSONObject(data).getJSONArray("rows");
        } else {
            records = new JSONArray(data);
        }
        JSONArray headers = metaParams.optJSONArray("headers");
        String title = metaParams.optString("title", null);
        String dateFormat = metaParams.optString("dateFormat");
        String timeFormat = metaParams.optString("timeFormat");
        boolean neptune = metaParams.optBoolean("neptune");
        String decimalSeparator = metaParams.optString("decimalSeparator");
        String thousandSeparator = metaParams.optString("thousandSeparator");
        String filename = metaParams.optString("filename");
        if (StringUtil.isEmpty(filename)) {
            filename = "data";
        }
        filename = String.valueOf(filename) + fileExtName;
        if (!isHtml) {
            response.setHeader("content-type", "application/force-download");
            response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, filename));
        }
        if ("excel".equals(type)) {
            DataOutput.outputExcel(request, (OutputStream)response.getOutputStream(), headers, records, title, dateFormat, timeFormat, neptune);
        } else if ("text".equals(type)) {
            DataOutput.outputText(request, (OutputStream)response.getOutputStream(), headers, records, dateFormat, timeFormat, decimalSeparator, thousandSeparator);
        } else {
            DataOutput.outputHtml(request, (OutputStream)response.getOutputStream(), headers, records, title, dateFormat, timeFormat, neptune, metaParams.getInt("rowNumberWidth"), metaParams.optString("rowNumberTitle"), decimalSeparator, thousandSeparator);
        }
        response.flushBuffer();
    }

    private static String getResponseString(CustomResponse response) throws Exception {
        String result;
        byte[] data = response.getBytes();
        if (data.length > 2 && data[0] == 31 && data[1] == -117) {
            GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(data));
            try {
                result = StringUtil.getString(is);
            }
            finally {
                ((InputStream)is).close();
            }
        } else {
            result = new String(data, "utf-8");
        }
        return result;
    }
}

