/*
 * Decompiled with CFR 0.152.
 */
package com.wb.interact;

import com.wb.common.Base;
import com.wb.common.Resource;
import com.wb.common.Value;
import com.wb.tool.DataOutput;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import com.wb.util.ZipUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;

public class Service {
    public static void getValue(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Service.getData(request, response, false);
    }

    public static void getResource(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Service.getData(request, response, true);
    }

    private static void getData(HttpServletRequest request, HttpServletResponse response, boolean isResource) throws Exception {
        String name = request.getParameter("name");
        String value = isResource ? Resource.getString(request, name, null) : Value.getString(request, name, null);
        WebUtil.send(response, value);
    }

    private static void download(HttpServletRequest request, HttpServletResponse response, boolean webFilesOnly) throws Exception {
        String filename;
        JSONArray ja = new JSONArray(WebUtil.fetch(request, "files"));
        int j = ja.length();
        File base = null;
        File sysFolder = null;
        File[] files = new File[j];
        if (webFilesOnly) {
            base = new File(Base.path, "wb");
            sysFolder = new File(Base.path, "wb/system");
        }
        int i = 0;
        while (i < j) {
            if (webFilesOnly) {
                files[i] = new File(Base.path, ja.optString(i));
                if (!FileUtil.isAncestor(base, files[i]) || FileUtil.isAncestor(sysFolder, files[i]) || FileUtil.isAncestor(Base.modulePath, files[i])) {
                    SysUtil.accessDenied();
                }
            } else {
                files[i] = new File(ja.optString(i));
            }
            ++i;
        }
        boolean useZip = StringUtil.getBool(WebUtil.fetch(request, "zip")) || j > 1 || files[0].isDirectory();
        String downloadName = WebUtil.fetch(request, "downloadName");
        if (StringUtil.isEmpty(downloadName)) {
            filename = files[0].getName();
            if (j == 1) {
                if (useZip) {
                    filename = String.valueOf(FileUtil.removeExtension(filename)) + ".zip";
                }
            } else {
                File parentFile = files[0].getParentFile();
                filename = parentFile == null ? "file.zip" : String.valueOf(parentFile.getName()) + ".zip";
            }
            if (filename.equals(".zip") || filename.equals("/.zip")) {
                filename = "file.zip";
            }
        } else {
            filename = downloadName;
        }
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, filename));
        if (useZip) {
            ZipUtil.zip(files, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        } else {
            WebUtil.send(response, new FileInputStream(files[0]));
        }
    }

    public static void downloadAtAll(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Service.download(request, response, false);
    }

    public static void downloadAtApp(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Service.download(request, response, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void upload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean unzip = StringUtil.getBool((String)request.getAttribute("unzip"));
        boolean sync = StringUtil.getBool((String)request.getAttribute("sync"));
        String path = request.getAttribute("path").toString();
        InputStream stream = (InputStream)request.getAttribute("file");
        String filename = (String)request.getAttribute("filename");
        if (filename == null) {
            filename = (String)request.getAttribute("file__name");
        }
        if (unzip) {
            File syncPath;
            if (!filename.toLowerCase().endsWith(".zip")) throw new Exception("Invalid zip file.");
            File destPath = new File(path);
            ZipUtil.unzip(stream, destPath);
            if (!sync || (syncPath = FileUtil.getSyncPath(destPath)) == null) return;
            FileUtils.copyDirectory((File)destPath, (File)syncPath);
            return;
        } else {
            File syncPath;
            File destPath = new File(path, filename);
            FileUtil.saveStream(stream, destPath);
            if (!sync || (syncPath = FileUtil.getSyncPath(destPath)) == null) return;
            FileUtils.copyFile((File)destPath, (File)syncPath);
        }
    }

    public static void getProgress(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = request.getParameter("progressId");
        HttpSession session = request.getSession(true);
        Long pos = (Long)session.getAttribute("sys.upread." + id);
        Long len = (Long)session.getAttribute("sys.uplen." + id);
        double result = pos == null || len == null || len == 0L ? 0.0 : (double)pos.longValue() / (double)len.longValue();
        WebUtil.send(response, result);
    }

    public static void importData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputStream stream;
        String filename;
        boolean fromServer = StringUtil.getBool(WebUtil.fetch(request, "fromServer"));
        if (fromServer) {
            filename = WebUtil.fetch(request, "filename");
            stream = new FileInputStream(new File(filename));
            filename = filename.toLowerCase();
        } else {
            filename = ((String)request.getAttribute("file__name")).toLowerCase();
            stream = (InputStream)request.getAttribute("file");
        }
        try {
            String tableName = WebUtil.fetch(request, "table");
            boolean trans = StringUtil.getBool(WebUtil.fetch(request, "trans"));
            Connection connection = DbUtil.getConnection(WebUtil.fetch(request, "jndi"));
            try {
                if (trans) {
                    connection.setAutoCommit(false);
                }
                if (filename.endsWith(".gz")) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(stream), "utf-8"));
                    DbUtil.importData(connection, tableName, reader);
                } else if (filename.endsWith(".xls") || filename.endsWith(".xlsx")) {
                    BufferedReader reader = new BufferedReader(new StringReader(DataOutput.excelToJson(stream, filename.endsWith(".xlsx"))));
                    DbUtil.importData(connection, tableName, reader);
                } else {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
                    String fields = reader.readLine();
                    char separator = fields.indexOf(9) == -1 ? (char)',' : '\t';
                    String[] fieldList = StringUtil.split(fields, separator);
                    DbUtil.importData(connection, tableName, reader, fieldList, separator);
                }
                if (trans) {
                    connection.commit();
                }
            }
            finally {
                DbUtil.close(connection);
            }
        }
        finally {
            stream.close();
        }
    }

    public static void exportJson(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultSet rs = (ResultSet)DbUtil.run(request, WebUtil.fetch(request, "sql"), WebUtil.fetch(request, "jndi"));
        String filename = WebUtil.fetch(request, "filename");
        if (filename == null) {
            filename = "data.gz";
        }
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, filename));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)response.getOutputStream()), "utf-8"));
        try {
            DbUtil.exportData(rs, writer);
        }
        finally {
            ((Writer)writer).close();
        }
        response.flushBuffer();
    }

    public static void exportJsonToServer(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultSet rs = (ResultSet)DbUtil.run(request, WebUtil.fetch(request, "sql"), WebUtil.fetch(request, "jndi"));
        String filename = WebUtil.fetch(request, "filename");
        File file = new File(filename);
        if (file.exists()) {
            throw new Exception("\u6587\u4ef6 \u201c" + filename + "\u201d \u5df2\u7ecf\u5b58\u5728\u3002");
        }
        FileOutputStream fos = null;
        BufferedWriter writer = null;
        try {
            fos = new FileOutputStream(file);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(fos), "utf-8"));
            DbUtil.exportData(rs, writer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            fos.close();
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        fos.close();
    }

    public static void testJNDI(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String jndi = request.getParameter("jndi");
        DbUtil.getConnection(jndi).close();
    }
}

