/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.KVBuffer;
import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.util.DateUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataOutput {
    public static void outputExcel(HttpServletRequest request, OutputStream outputStream, JSONArray headers, JSONArray records, String title, String dateFormat, String timeFormat, boolean neptune) throws Exception {
        int startRow = 0;
        Workbook book = DataOutput.getBook();
        try {
            Sheet sheet = book.createSheet();
            if (title != null) {
                startRow = 1;
                sheet.createRow(0);
            }
            Object[] values = DataOutput.createHeaders(sheet, headers, startRow, neptune);
            int headerCols = (Integer)values[0];
            int headerRows = (Integer)values[1];
            JSONArray fields = (JSONArray)values[2];
            if (title != null) {
                DataOutput.createTitle(sheet, title, headerCols);
            }
            startRow += headerRows;
            if (Var.getBool("sys.service.excel.freezePane")) {
                sheet.createFreezePane(0, startRow);
            }
            DataOutput.createRecords(request, sheet, records, fields, startRow, dateFormat, timeFormat);
            book.write(outputStream);
        }
        finally {
            book.close();
        }
    }

    private static void createTitle(Sheet sheet, String title, int headerCols) {
        Row row = sheet.getRow(0);
        Object[] styles = DataOutput.createCellStyle(sheet.getWorkbook(), "title");
        row.setHeight(((Short)styles[1]).shortValue());
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headerCols - 1));
        Cell cell = row.createCell(0);
        cell.setCellStyle((CellStyle)styles[0]);
        cell.setCellValue(title);
    }

    private static Object[] createHeaders(Sheet sheet, JSONArray headers, int startRow, boolean neptune) {
        Workbook book = sheet.getWorkbook();
        JSONArray processedHeaders = new JSONArray();
        Object[] values = DataOutput.prepareHeaders(sheet, headers, processedHeaders, startRow, neptune);
        Cell[][] cells = (Cell[][])values[0];
        Object[] styles = DataOutput.createCellStyle(book, "header");
        CellStyle baseStyle = (CellStyle)styles[0];
        int j = processedHeaders.length();
        int i = 0;
        while (i < j) {
            JSONObject header = processedHeaders.getJSONObject(i);
            int x = header.getInt("x");
            int y = header.getInt("y");
            int colspan = Math.max(header.getInt("colspan"), 0);
            int rowspan = Math.max(header.getInt("rowspan"), 0);
            if (colspan > 0 || rowspan > 0) {
                sheet.addMergedRegion(new CellRangeAddress(y + startRow, y + startRow + rowspan, x, x + colspan));
            }
            Cell cell = cells[x][y];
            CellStyle style = book.createCellStyle();
            style.cloneStyleFrom(baseStyle);
            style.setAlignment(DataOutput.getAlignment(header.optString("titleAlign"), header.has("child") ? (short)2 : 1));
            cell.setCellStyle(style);
            cell.setCellValue(header.optString("text"));
            ++i;
        }
        Object[] result = new Object[]{cells.length, cells[0].length, values[1]};
        return result;
    }

    private static Object[] prepareHeaders(Sheet sheet, JSONArray rawHeaders, JSONArray processedHeaders, int startRow, boolean neptune) {
        JSONArray leafs = new JSONArray();
        Object[] result = new Object[2];
        int flexWidth = Var.getInt("sys.service.excel.flexColumnMaxWidth");
        Object[] styles = DataOutput.createCellStyle(sheet.getWorkbook(), "header");
        CellStyle style = (CellStyle)styles[0];
        short rowHeight = (Short)styles[1];
        double rate = neptune ? 32.06 : 36.55;
        leafs.put(0);
        DataOutput.markParents(leafs, rawHeaders, null, 0);
        int maxDepth = leafs.getInt(0);
        leafs.remove(0);
        int j = leafs.length();
        int i = 0;
        while (i < j) {
            JSONObject node = leafs.getJSONObject(i);
            int width = node.has("width") ? node.getInt("width") : (node.has("flex") ? flexWidth : 100);
            sheet.setColumnWidth(i, (int)((double)width * rate));
            node.put("rowspan", maxDepth - node.getInt("y"));
            do {
                node.put("colspan", node.getInt("colspan") + 1);
                if (node.has("x")) continue;
                node.put("x", i);
                processedHeaders.put((Object)node);
            } while ((node = (JSONObject)node.opt("parent")) != null);
            ++i;
        }
        Cell[][] cells = new Cell[j][++maxDepth];
        int k = 0;
        while (k < maxDepth) {
            Row row = sheet.createRow(k + startRow);
            row.setHeight(rowHeight);
            int l = 0;
            while (l < j) {
                Cell cell = row.createCell(l);
                cell.setCellStyle(style);
                cells[l][k] = cell;
                ++l;
            }
            ++k;
        }
        result[0] = cells;
        result[1] = leafs;
        return result;
    }

    private static void markParents(JSONArray leafs, JSONArray headers, JSONObject parent, int depth) {
        int j = headers.length();
        leafs.put(0, Math.max(leafs.getInt(0), depth));
        int i = 0;
        while (i < j) {
            JSONArray items;
            JSONObject header = headers.getJSONObject(i);
            header.put("y", depth);
            header.put("colspan", -1);
            header.put("rowspan", -1);
            if (parent != null) {
                header.put("parent", (Object)parent);
                parent.put("child", (Object)header);
            }
            if ((items = (JSONArray)header.opt("items")) != null) {
                DataOutput.markParents(leafs, items, header, depth + 1);
            } else {
                leafs.put((Object)header);
            }
            ++i;
        }
    }

    private static void createRecords(HttpServletRequest request, Sheet sheet, JSONArray records, JSONArray fields, int startRow, String defaultDateFormat, String defaultTimeFormat) {
        boolean useBoolString;
        int j = records.length();
        int l = fields.length();
        String[] fieldNames = new String[l];
        Workbook book = sheet.getWorkbook();
        Object[] cellStyles = DataOutput.createCellStyle(book, "text");
        CellStyle baseStyle = (CellStyle)cellStyles[0];
        CellStyle[] colStyles = new CellStyle[l];
        CellStyle[][] dateTimeStyles = new CellStyle[l][2];
        short rowHeight = (Short)cellStyles[1];
        String boolString = Var.getString("sys.service.excel.boolText");
        String trueText = null;
        String falseText = null;
        boolean[] isRate = new boolean[l];
        int[] dataTypes = new int[l];
        Object[] keyMaps = new Object[l];
        boolean bl = useBoolString = !boolString.isEmpty();
        if (useBoolString) {
            String[] boolStrings = boolString.split(",");
            trueText = boolStrings[0];
            falseText = boolStrings[1];
        }
        int k = 0;
        while (k < l) {
            int dataType;
            String dataTypeStr;
            String keyName;
            JSONObject field = fields.getJSONObject(k);
            fieldNames[k] = field.optString("field");
            CellStyle style = book.createCellStyle();
            style.cloneStyleFrom(baseStyle);
            style.setAlignment(DataOutput.getAlignment(field.optString("align"), (short)1));
            if (Boolean.TRUE.equals(field.opt("autoWrap"))) {
                style.setWrapText(true);
            }
            if ((keyName = field.optString("keyName")).isEmpty()) {
                keyMaps[k] = null;
                dataTypeStr = field.optString("type").toLowerCase();
            } else {
                keyMaps[k] = KVBuffer.buffer.get(keyName);
                dataTypeStr = "string";
            }
            String format = field.optString("format");
            isRate[k] = format.endsWith("%");
            if (dataTypeStr.equals("string")) {
                dataType = 1;
            } else if (dataTypeStr.startsWith("int") || dataTypeStr.equals("float") || dataTypeStr.equals("number")) {
                dataType = 2;
                if (!StringUtil.isEmpty(format)) {
                    style.setDataFormat(book.createDataFormat().getFormat(format));
                }
            } else if (dataTypeStr.equals("date")) {
                dataType = 3;
                if (StringUtil.isEmpty(format)) {
                    CellStyle dateStyle = book.createCellStyle();
                    dateStyle.cloneStyleFrom(style);
                    CellStyle dateTimeStyle = book.createCellStyle();
                    dateTimeStyle.cloneStyleFrom(style);
                    format = DataOutput.toExcelDateFormat(defaultDateFormat, true);
                    dateStyle.setDataFormat(book.createDataFormat().getFormat(format));
                    dateTimeStyles[k][0] = dateStyle;
                    format = DataOutput.toExcelDateFormat(String.valueOf(defaultDateFormat) + " " + defaultTimeFormat, true);
                    dateTimeStyle.setDataFormat(book.createDataFormat().getFormat(format));
                    dateTimeStyles[k][1] = dateTimeStyle;
                    style = dateStyle;
                } else {
                    dateTimeStyles[0][0] = null;
                    if ((format = DataOutput.toExcelDateFormat(format, false)) == null) {
                        format = DataOutput.toExcelDateFormat(defaultDateFormat, true);
                    }
                    style.setDataFormat(book.createDataFormat().getFormat(format));
                }
            } else {
                dataType = dataTypeStr.startsWith("bool") ? 4 : 5;
            }
            dataTypes[k] = dataType;
            colStyles[k] = style;
            ++k;
        }
        int i = 0;
        while (i < j) {
            Row row = sheet.createRow(startRow + i);
            row.setHeight(rowHeight);
            JSONObject record = (JSONObject)records.opt(i);
            k = 0;
            while (k < l) {
                Cell cell = row.createCell(k);
                cell.setCellStyle(colStyles[k]);
                Object value = JsonUtil.opt(record, fieldNames[k]);
                if (value != null) {
                    if (keyMaps[k] != null) {
                        value = KVBuffer.getValue((ConcurrentHashMap)keyMaps[k], request, value);
                    }
                    if (dataTypes[k] == 5) {
                        dataTypes[k] = value instanceof Number ? 2 : (value instanceof Date ? 3 : (value instanceof Boolean ? 4 : 1));
                    }
                    switch (dataTypes[k]) {
                        case 2: {
                            double number = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
                            if (isRate[k]) {
                                number /= 100.0;
                            }
                            cell.setCellValue(number);
                            break;
                        }
                        case 3: {
                            Date date;
                            if (dateTimeStyles[k][0] == null) {
                                date = value instanceof Date ? (Date)value : Timestamp.valueOf(value.toString());
                            } else {
                                boolean hasTime;
                                if (value instanceof Date) {
                                    date = (Date)value;
                                    hasTime = !DateUtil.dateToStr(date).endsWith("00:00:00.0");
                                } else {
                                    String dateTimeStr = value.toString();
                                    date = Timestamp.valueOf(dateTimeStr);
                                    boolean bl2 = hasTime = !dateTimeStr.endsWith("00:00:00.0") && !(dateTimeStr.endsWith("00:00:00") | dateTimeStr.endsWith("00:00:00.000"));
                                }
                                if (hasTime) {
                                    cell.setCellStyle(dateTimeStyles[k][1]);
                                } else {
                                    cell.setCellStyle(dateTimeStyles[k][0]);
                                }
                            }
                            cell.setCellValue(date);
                            break;
                        }
                        case 4: {
                            if (useBoolString) {
                                cell.setCellValue(StringUtil.getBool(value.toString()) ? trueText : falseText);
                                break;
                            }
                            cell.setCellValue(StringUtil.getBool(value.toString()));
                            break;
                        }
                        default: {
                            cell.setCellValue(value.toString());
                        }
                    }
                }
                ++k;
            }
            ++i;
        }
    }

    public static Workbook getBook() {
        if (Var.getBool("sys.service.excel.xlsx")) {
            return new XSSFWorkbook();
        }
        return new HSSFWorkbook();
    }

    public static String getExtName() {
        if (Var.getBool("sys.service.excel.xlsx")) {
            return ".xlsx";
        }
        return ".xls";
    }

    public static Object[] createCellStyle(Workbook book, String type) {
        String backColor;
        CellStyle style = book.createCellStyle();
        Font font = book.createFont();
        String fontName = Var.getString("sys.service.excel." + type + ".fontName");
        int fontHeight = Var.getInt("sys.service.excel." + type + ".fontHeight");
        double rowHeight = Var.getDouble("sys.service.excel." + type + ".rowHeight");
        Object[] result = new Object[2];
        if (!fontName.isEmpty()) {
            font.setFontName(fontName);
        }
        font.setBoldweight((short)Var.getInt("sys.service.excel." + type + ".fontWeight"));
        font.setFontHeight((short)fontHeight);
        if (rowHeight < 10.0) {
            rowHeight *= (double)fontHeight;
        }
        if (!"text".equals(type) && Var.getBool("sys.service.excel." + type + ".wrapText")) {
            style.setWrapText(true);
        }
        if ("title".equals(type)) {
            String align = Var.getString("sys.service.excel." + type + ".align");
            if (!align.isEmpty()) {
                Object[][] alignments = new Object[][]{{"\u5c45\u4e2d", (short)2}, {"\u5de6", (short)1}, {"\u53f3", (short)3}, {"\u5c45\u4e2d\u9009\u62e9", (short)6}, {"\u586b\u5145", (short)4}, {"\u5e38\u89c4", (short)0}, {"\u4e24\u7aef\u5bf9\u9f50", (short)5}};
                style.setAlignment(((Short)SysUtil.getValue(alignments, align)).shortValue());
            }
        } else if (Var.getBool("sys.service.excel.border")) {
            style.setBorderTop((short)1);
            style.setBorderBottom((short)1);
            style.setBorderLeft((short)1);
            style.setBorderRight((short)1);
        }
        if ("header".equals(type) && !"\u9ed8\u8ba4".equals(backColor = Var.getString("sys.service.excel.header.backColor"))) {
            Object[][] colors = new Object[][]{{"\u9ed8\u8ba4", -1}, {"\u91d1\u8272", (short)51}, {"\u7070\u8272", (short)22}, {"\u6d45\u9ec4", (short)43}};
            style.setFillForegroundColor(((Short)SysUtil.getValue(colors, backColor)).shortValue());
            style.setFillPattern((short)1);
        }
        style.setVerticalAlignment((short)1);
        style.setFont(font);
        result[0] = style;
        result[1] = Double.valueOf(rowHeight).shortValue();
        return result;
    }

    public static short getAlignment(String align, short defaultAlign) {
        if ("right".equals(align)) {
            return 3;
        }
        if ("center".equals("align")) {
            return 2;
        }
        if ("left".equals("align")) {
            return 1;
        }
        return defaultAlign;
    }

    public static String excelToJson(InputStream inputStream, boolean xlsxFormat) throws Exception {
        int rowIndex = 0;
        ArrayList<String> fieldList = new ArrayList<String>();
        StringBuilder text = new StringBuilder("");
        Object book = xlsxFormat ? new XSSFWorkbook(inputStream) : new HSSFWorkbook(inputStream);
        Sheet sheet = book.getSheetAt(0);
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            if (rowIndex > 1) {
                text.append("\n{");
            } else if (rowIndex > 0) {
                text.append('{');
            }
            Row row = (Row)rows.next();
            Iterator cells = row.cellIterator();
            int colIndex = 0;
            while (cells.hasNext()) {
                Cell cell = (Cell)cells.next();
                Object value = DataOutput.getCellValue(cell);
                if (rowIndex == 0) {
                    if (value == null) {
                        throw new NullPointerException("Field name has null value.");
                    }
                    fieldList.add(value.toString());
                } else {
                    if (colIndex > 0) {
                        text.append(',');
                    }
                    if (colIndex >= fieldList.size()) {
                        throw new RuntimeException("Row " + (rowIndex + 1) + " column " + (colIndex + 1) + " is out of bounds.");
                    }
                    text.append(StringUtil.quote((String)fieldList.get(colIndex)));
                    text.append(':');
                    text.append(StringUtil.encode(value));
                }
                ++colIndex;
            }
            if (rowIndex > 0) {
                text.append('}');
            }
            ++rowIndex;
        }
        return text.toString();
    }

    public static Object getCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case 0: 
            case 2: {
                if (org.apache.poi.ss.usermodel.DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
        }
        return null;
    }

    public static void outputHtml(HttpServletRequest request, OutputStream outputStream, JSONArray headers, JSONArray records, String title, String dateFormat, String timeFormat, boolean neptune, int rowNumberWidth, String rowNumberTitle, String decimalSeparator, String thousandSeparator) throws Exception {
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html><html><head><meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\"><title>");
        if (StringUtil.isEmpty(title)) {
            html.append(Str.format(request, "preview", new Object[0]));
        } else {
            html.append(title);
        }
        html.append("</title><style type=\"text/css\">table{table-layout:fixed;border-collapse:collapse;word-wrap:break-word;");
        String value = Var.getString("sys.service.preview.textFont");
        if (!value.isEmpty()) {
            html.append("font-family:");
            html.append(value);
            html.append(';');
        }
        html.append("line-height:");
        html.append(Var.getString("sys.service.preview.textLineHeight"));
        html.append(";font-size:");
        html.append(Var.getString("sys.service.preview.textFontSize"));
        html.append(";}.header{");
        value = Var.getString("sys.service.preview.headerBackColor");
        if (!value.isEmpty()) {
            html.append("background-color:");
            html.append(value);
            html.append(';');
        }
        html.append("font-weight:");
        html.append(Var.getString("sys.service.preview.headerFontWeight"));
        html.append(";}td{border:1px solid #000000;padding:0 2px 0 2px;}th{border:0;}.wrap{word-wrap:break-word;}</style></head><body>");
        JSONArray fields = DataOutput.createHtmlHeaders(html, headers, title, neptune, rowNumberWidth, rowNumberTitle);
        DataOutput.getTextContent(request, html, records, fields, dateFormat, timeFormat, rowNumberWidth > -1, true, decimalSeparator, thousandSeparator, null);
        html.append("</table></body></html>");
        outputStream.write(html.toString().getBytes("utf-8"));
    }

    public static void outputText(HttpServletRequest request, OutputStream outputStream, JSONArray headers, JSONArray records, String defaultDateFormat, String defaultTimeFormat, String decimalSeparator, String thousandSeparator) throws Exception {
        StringBuilder text = new StringBuilder();
        JSONArray leafs = new JSONArray();
        String lineSeparator = SysUtil.getLineSeparator();
        leafs.put(0);
        DataOutput.markParents(leafs, headers, null, 0);
        leafs.remove(0);
        int j = leafs.length();
        int i = 0;
        while (i < j) {
            if (i > 0) {
                text.append('\t');
            }
            text.append(leafs.getJSONObject(i).optString("text"));
            ++i;
        }
        text.append(lineSeparator);
        DataOutput.getTextContent(request, text, records, leafs, defaultDateFormat, defaultTimeFormat, false, false, decimalSeparator, thousandSeparator, lineSeparator);
        outputStream.write(text.toString().getBytes("utf-8"));
    }

    private static JSONArray createHtmlHeaders(StringBuilder html, JSONArray rawHeaders, String title, boolean neptune, int rowNumberWidth, String rowNumberTitle) {
        JSONArray row;
        JSONObject node;
        JSONArray leafs = new JSONArray();
        JSONArray grid = new JSONArray();
        int flexWidth = Var.getInt("sys.service.excel.flexColumnMaxWidth");
        double rate = neptune ? 0.87719298 : 1.0;
        int tableWidth = rowNumberWidth > -1 ? (rowNumberWidth = (int)Math.round((double)rowNumberWidth * rate)) : 0;
        leafs.put(0);
        DataOutput.markParents(leafs, rawHeaders, null, 0);
        int maxDepth = leafs.getInt(0);
        leafs.remove(0);
        int j = leafs.length();
        int i = 0;
        while (i < j) {
            node = leafs.getJSONObject(i);
            tableWidth += DataOutput.getHtmlCellWidth(node, flexWidth, rate);
            int y = node.getInt("y");
            node.put("rowspan", maxDepth - y);
            do {
                node.put("colspan", node.getInt("colspan") + 1);
                if (node.has("x")) continue;
                node.put("x", i);
                y = node.getInt("y");
                row = grid.optJSONArray(y);
                if (row == null) {
                    row = new JSONArray();
                    grid.put(y, (Object)row);
                }
                row.put(i, (Object)node);
            } while ((node = (JSONObject)node.opt("parent")) != null);
            ++i;
        }
        if (title != null) {
            html.append("<p style=\"text-align:center;width:");
            html.append(tableWidth);
            html.append("px;");
            String value = Var.getString("sys.service.preview.titleFont");
            if (!value.isEmpty()) {
                html.append("font-family:");
                html.append(value);
                html.append(';');
            }
            html.append("font-weight:");
            html.append(Var.getString("sys.service.preview.titleFontWeight"));
            html.append(";line-height:");
            html.append(Var.getString("sys.service.preview.titleLineHeight"));
            html.append(";font-size:");
            html.append(Var.getString("sys.service.preview.titleFontSize"));
            html.append(";\">");
            html.append(StringUtil.toHTML(title, true, true));
            html.append("</p>");
        }
        html.append("<table  style=\"width:");
        html.append(tableWidth);
        html.append("px\">");
        html.append("<tr style=\"height:0\">");
        if (rowNumberWidth > -1) {
            html.append("<th width=\"");
            html.append(rowNumberWidth);
            html.append("px\"></th>");
        }
        j = leafs.length();
        i = 0;
        while (i < j) {
            node = leafs.getJSONObject(i);
            html.append("<th width=\"");
            html.append(DataOutput.getHtmlCellWidth(node, flexWidth, rate));
            html.append("px\"></th>");
            ++i;
        }
        html.append("</tr>");
        j = grid.length();
        i = 0;
        while (i < j) {
            html.append("<tr class=\"header\">");
            if (rowNumberWidth > -1 && i == 0) {
                html.append("<td rowspan=\"");
                html.append(maxDepth + 1);
                html.append("\">");
                html.append(rowNumberTitle);
                html.append("</td>");
            }
            row = grid.getJSONArray(i);
            int l = row.length();
            int k = 0;
            while (k < l) {
                node = row.optJSONObject(k);
                if (node != null) {
                    int rowspan;
                    html.append("<td align=\"");
                    int colspan = node.getInt("colspan");
                    String align = node.optString("titleAlign");
                    if (StringUtil.isEmpty(align) && colspan > 0) {
                        align = "center";
                    }
                    html.append(align);
                    html.append('\"');
                    if (colspan > 0) {
                        html.append(" colspan=\"");
                        html.append(colspan + 1);
                        html.append("\"");
                    }
                    if ((rowspan = node.getInt("rowspan")) > 0) {
                        html.append(" rowspan=\"");
                        html.append(rowspan + 1);
                        html.append("\"");
                    }
                    html.append('>');
                    html.append(node.optString("text"));
                    html.append("</td>");
                }
                ++k;
            }
            html.append("</tr>");
            ++i;
        }
        return leafs;
    }

    private static int getHtmlCellWidth(JSONObject node, int flexWidth, double rate) {
        int width = node.has("width") ? node.getInt("width") : (node.has("flex") ? flexWidth : 100);
        return (int)Math.round((double)width * rate);
    }

    private static void getTextContent(HttpServletRequest request, StringBuilder buf, JSONArray records, JSONArray fields, String defaultDateFormat, String defaultTimeFormat, boolean hasRowNumber, boolean isHtml, String decimalSeparator, String thousandSeparator, String lineSeparator) {
        boolean useBoolString;
        int j = records.length();
        int l = fields.length();
        String[] fieldNames = new String[l];
        String boolString = Var.getString("sys.service.excel.boolText");
        String trueText = null;
        String falseText = null;
        String[] aligns = new String[l];
        boolean[] wraps = new boolean[l];
        boolean[] isRate = new boolean[l];
        int[] dataTypes = new int[l];
        Format[] formats = new Format[l];
        SimpleDateFormat dateFormat = new SimpleDateFormat(DataOutput.toJavaDateFormat(defaultDateFormat, true));
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(DataOutput.toJavaDateFormat(String.valueOf(defaultDateFormat) + " " + defaultTimeFormat, true));
        Object[] keyMaps = new Object[l];
        boolean bl = useBoolString = !boolString.isEmpty();
        if (useBoolString) {
            String[] boolStrings = boolString.split(",");
            trueText = boolStrings[0];
            falseText = boolStrings[1];
        }
        int k = 0;
        while (k < l) {
            int dataType;
            String dataTypeStr;
            JSONObject field = fields.getJSONObject(k);
            String keyName = field.optString("keyName");
            if (keyName.isEmpty()) {
                keyMaps[k] = null;
                dataTypeStr = field.optString("type").toLowerCase();
            } else {
                keyMaps[k] = KVBuffer.buffer.get(keyName);
                dataTypeStr = "string";
            }
            String format = field.optString("format");
            isRate[k] = format.endsWith("%");
            formats[k] = null;
            if (dataTypeStr.equals("string")) {
                dataType = 1;
            } else if (dataTypeStr.startsWith("int") || dataTypeStr.equals("float") || dataTypeStr.equals("number")) {
                dataType = 2;
                if (!format.isEmpty()) {
                    DecimalFormat decimalFormat = new DecimalFormat(format);
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                    dfs.setDecimalSeparator(decimalSeparator.charAt(0));
                    dfs.setGroupingSeparator(thousandSeparator.charAt(0));
                    decimalFormat.setDecimalFormatSymbols(dfs);
                    formats[k] = decimalFormat;
                }
            } else if (dataTypeStr.equals("date")) {
                dataType = 3;
                if (!StringUtil.isEmpty(format)) {
                    formats[k] = (format = DataOutput.toJavaDateFormat(format, false)) == null ? dateFormat : new SimpleDateFormat(format);
                }
            } else {
                dataType = dataTypeStr.startsWith("bool") ? 4 : 5;
            }
            dataTypes[k] = dataType;
            fieldNames[k] = field.optString("field");
            aligns[k] = field.optString("align");
            wraps[k] = Boolean.TRUE.equals(field.opt("autoWrap"));
            ++k;
        }
        int i = 0;
        while (i < j) {
            JSONObject record = (JSONObject)records.opt(i);
            if (isHtml) {
                buf.append("<tr>");
                if (hasRowNumber) {
                    buf.append("<td align=\"right\">");
                    buf.append(i + 1);
                    buf.append("</td>");
                }
            } else if (i > 0) {
                buf.append(lineSeparator);
            }
            k = 0;
            while (k < l) {
                Object value = JsonUtil.opt(record, fieldNames[k]);
                if (value == null) {
                    if (isHtml) {
                        buf.append("<td></td>");
                    } else {
                        buf.append("\t");
                    }
                } else {
                    String valueText;
                    if (isHtml) {
                        buf.append("<td");
                        if (!aligns[k].isEmpty()) {
                            buf.append(" align=\"");
                            buf.append(aligns[k]);
                            buf.append("\"");
                        }
                        if (wraps[k]) {
                            buf.append(" class=\"wrap\"");
                        }
                        buf.append('>');
                    } else if (k > 0) {
                        buf.append("\t");
                    }
                    if (keyMaps[k] != null) {
                        value = KVBuffer.getValue((ConcurrentHashMap)keyMaps[k], request, value);
                    }
                    if (dataTypes[k] == 5) {
                        dataTypes[k] = value instanceof Number ? 2 : (value instanceof Date ? 3 : (value instanceof Boolean ? 4 : 1));
                    }
                    switch (dataTypes[k]) {
                        case 2: {
                            double number;
                            if (value instanceof Number) {
                                if (formats[k] == null) {
                                    valueText = StringUtil.replaceFirst(value.toString(), ".", decimalSeparator);
                                    break;
                                }
                                number = ((Number)value).doubleValue();
                                if (isRate[k]) {
                                    number /= 100.0;
                                }
                                valueText = formats[k].format(number);
                                break;
                            }
                            if (formats[k] == null) {
                                valueText = StringUtil.replaceFirst(value.toString(), ".", decimalSeparator);
                                break;
                            }
                            number = Double.parseDouble(value.toString());
                            if (isRate[k]) {
                                number /= 100.0;
                            }
                            valueText = formats[k].format(number);
                            break;
                        }
                        case 3: {
                            Date date;
                            if (formats[k] == null) {
                                boolean hasTime;
                                if (value instanceof Date) {
                                    date = (Date)value;
                                    hasTime = !DateUtil.dateToStr(date).endsWith("00:00:00.0");
                                } else {
                                    String dateTimeStr = value.toString();
                                    date = Timestamp.valueOf(dateTimeStr);
                                    boolean bl2 = hasTime = !dateTimeStr.endsWith("00:00:00.0") && !(dateTimeStr.endsWith("00:00:00") | dateTimeStr.endsWith("00:00:00.000"));
                                }
                                if (hasTime) {
                                    valueText = dateTimeFormat.format((Object)date);
                                    break;
                                }
                                valueText = dateFormat.format((Object)date);
                                break;
                            }
                            date = value instanceof Date ? (Date)value : Timestamp.valueOf(value.toString());
                            valueText = formats[k].format(date);
                            break;
                        }
                        case 4: {
                            if (useBoolString) {
                                valueText = StringUtil.getBool(value.toString()) ? trueText : falseText;
                                break;
                            }
                            valueText = value.toString();
                            break;
                        }
                        default: {
                            valueText = value.toString();
                        }
                    }
                    if (isHtml) {
                        buf.append(StringUtil.toHTML(valueText, true, true));
                        buf.append("</td>");
                    } else {
                        buf.append(valueText);
                    }
                }
                ++k;
            }
            if (isHtml) {
                buf.append("</tr>");
            }
            ++i;
        }
    }

    public static String toJavaDateFormat(String format, boolean returnDefault) {
        String s;
        String[] unSupportFormats = new String[]{"N", "S", "D", "w", "z", "W", "t", "L", "o", "O", "P", "T", "Z", "c", "U", "F", "MS", "l", "M", "time", "timestamp"};
        String[][] supportFormats = new String[][]{{"y", "yy"}, {"Y", "yyyy"}, {"m", "MM"}, {"n", "M"}, {"d", "dd"}, {"j", "d"}, {"H", "HH"}, {"h", "hh"}, {"G", "H"}, {"g", "h"}, {"i", "mm"}, {"s", "ss"}, {"u", "SSS"}, {"a", "'_x'"}, {"A", "'_X'"}};
        String[] stringArray = unSupportFormats;
        int n = unSupportFormats.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (format.indexOf(s) != -1) {
                return returnDefault ? "yyyy-MM-dd" : null;
            }
            ++n2;
        }
        stringArray = supportFormats;
        n = supportFormats.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            format = StringUtil.replaceAll(format, s[0], s[1]);
            ++n2;
        }
        return format;
    }

    public static String toExcelDateFormat(String format, boolean returnDefault) {
        String s;
        String[] unSupportFormats = new String[]{"N", "S", "w", "z", "W", "t", "L", "o", "u", "O", "P", "T", "Z", "c", "U", "MS", "time", "timestamp"};
        String[][] supportFormats = new String[][]{{"d", "dd"}, {"D", "aaa"}, {"j", "d"}, {"l", "aaaa"}, {"F", "mmmm"}, {"m", "mm"}, {"M", "mmm"}, {"n", "m"}, {"Y", "yyyy"}, {"y", "yy"}, {"a", "am/pm"}, {"A", "AM/PM"}, {"g", "h"}, {"G", "hh"}, {"h", "h"}, {"H", "hh"}, {"i", "mm"}, {"s", "ss"}};
        String[] stringArray = unSupportFormats;
        int n = unSupportFormats.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (format.indexOf(s) != -1) {
                return returnDefault ? "yyyy-mm-dd" : null;
            }
            ++n2;
        }
        stringArray = supportFormats;
        n = supportFormats.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            format = StringUtil.replaceAll(format, s[0], s[1]);
            ++n2;
        }
        return format;
    }
}

