/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Dictionary;
import com.wb.common.KVBuffer;
import com.wb.common.Var;
import com.wb.tool.DictRecord;
import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataProvider {
    public HttpServletRequest request;
    public HttpServletResponse response;
    public ResultSet resultSet;
    public Long totalCount;
    public long startTime;
    public long beginIndex = 1L;
    public long endIndex = Long.MAX_VALUE;
    public String type;
    public String[] dictTableNames;
    public String dictFieldsMap;
    public boolean createKeyValues;
    public String fields;
    public String fieldsTag;
    public String tag;
    public Integer limitRecords;
    public Integer limitExportRecords;
    public boolean createColumns = true;
    private static JSONArray treeMeta = new JSONArray("[{name:'parentId',type:'auto',defaultValue:null,useNull:true},{name:'index',type:'int',defaultValue:-1,persist:false,convert:null},{name:'depth',type:'int',defaultValue:0,persist:false,convert:null},{name:'expanded',type:'bool',defaultValue:false,persist:false,convert:null},{name:'expandable',type:'bool',defaultValue:true,persist:false,convert:null},{name:'checked',type:'auto',defaultValue:null,persist:false,convert:null},{name:'leaf',type:'bool',defaultValue:false},{name:'cls',type:'string',defaultValue:'',persist:false,convert:null},{name:'iconCls',type:'string',defaultValue:'',persist:false,convert:null},{name:'icon',type:'string',defaultValue:'',persist:false,convert:null},{name:'root',type:'boolean',defaultValue:false,persist:false,convert:null},{name:'isLast',type:'boolean',defaultValue:false,persist:false,convert:null},{name:'isFirst',type:'boolean',defaultValue:false,persist:false,convert:null},{name:'allowDrop',type:'boolean',defaultValue:true,persist:false,convert:null},{name:'allowDrag',type:'boolean',defaultValue:true,persist:false,convert:null},{name:'loaded',type:'boolean',defaultValue:false,persist:false,convert:null},{name:'loading',type:'boolean',defaultValue:false,persist:false,convert:null},{name:'href',type:'string',defaultValue:'',persist:false,convert:null},{name:'hrefTarget',type:'string',defaultValue:'',persist:false,convert:null},{name:'qtip',type:'string',defaultValue:'',persist:false,convert:null},{name:'qtitle',type:'string',defaultValue:'',persist:false,convert:null},{name:'qshowDelay',type:'int',defaultValue:0,persist:false,convert:null},{name:'children',type:'auto',defaultValue:null,persist:false,convert:null},{name:'visible',type:'boolean',defaultValue:true,persist:false,convert:null}]");

    public String getScript() throws Exception {
        if ("array".equals(this.type) || StringUtil.isEmpty(this.type)) {
            return this.getArray(false);
        }
        if ("tree".equals(this.type)) {
            return this.getArray(true);
        }
        if ("object".equals(this.type)) {
            return this.getObject();
        }
        throw new IllegalArgumentException("The type is invalid.");
    }

    public void output() throws Exception {
        String script;
        if ("array".equals(this.type) || StringUtil.isEmpty(this.type)) {
            script = this.getArray(false);
        } else if ("tree".equals(this.type)) {
            script = this.getArray(true);
        } else if ("object".equals(this.type)) {
            script = this.getObject();
        } else {
            DbUtil.outputBlob(this.resultSet, this.request, this.response, this.type);
            return;
        }
        if (WebUtil.jsonResponse(this.request)) {
            WebUtil.send(this.response, script, true);
        } else {
            WebUtil.send(this.response, script);
        }
    }

    private String getArray(boolean isTree) throws Exception {
        long count = 0L;
        boolean rowOnly = WebUtil.exists(this.request, "sys.rowOnly");
        boolean hasDict = this.dictTableNames != null;
        boolean first = true;
        boolean hasTotal = this.totalCount != null;
        StringBuilder buf = new StringBuilder();
        ResultSetMetaData meta = this.resultSet.getMetaData();
        int maxRecs = WebUtil.exists(this.request, "sys.fromExport") ? (this.limitExportRecords == null ? Var.limitExportRecords : (this.limitExportRecords == -1 ? Integer.MAX_VALUE : this.limitExportRecords)) : (this.limitRecords == null ? Var.limitRecords : (this.limitRecords == -1 ? Integer.MAX_VALUE : this.limitRecords));
        int j = meta.getColumnCount();
        String[] names = new String[j];
        String[] keyNames = new String[j];
        int[] types = new int[j];
        Object[] keyMaps = new Object[j];
        int i = 0;
        while (i < j) {
            names[i] = meta.getColumnLabel(i + 1);
            if (StringUtil.isEmpty(names[i])) {
                names[i] = "FIELD" + Integer.toString(i + 1);
            }
            if (this.createKeyValues) {
                if (hasDict) {
                    DictRecord dictRecord = Dictionary.find(this.dictTableNames, names[i]);
                    keyMaps[i] = dictRecord.keyName == null ? null : KVBuffer.buffer.get(dictRecord.keyName);
                } else {
                    keyMaps[i] = null;
                }
            }
            keyNames[i] = StringUtil.quote(String.valueOf(names[i]) + "__V");
            names[i] = StringUtil.quote(names[i]);
            types[i] = meta.getColumnType(i + 1);
            ++i;
        }
        buf.append("{\"success\":true");
        if (!rowOnly && !"-".equals(this.fields)) {
            JSONArray sysMeta = DbUtil.getFields(meta, this.createKeyValues ? this.dictTableNames : null);
            if (!StringUtil.isEmpty(this.fields)) {
                this.mergeFields(sysMeta, new JSONArray(this.fields));
            }
            buf.append(",\"metaData\":{\"fields\":");
            if (isTree) {
                buf.append(this.mergeFields(sysMeta, treeMeta).toString());
            } else {
                buf.append(sysMeta.toString());
            }
            if (!StringUtil.isEmpty(this.fieldsTag)) {
                buf.insert(buf.length() - 1, String.valueOf(',') + this.fieldsTag.substring(1, this.fieldsTag.length() - 1));
            }
            buf.append('}');
        }
        if (isTree) {
            buf.append(",\"children\":[");
        } else {
            if (!rowOnly && (this.createColumns || hasDict)) {
                buf.append(",\"columns\":");
                buf.append(DbUtil.getColumns(meta, this.dictTableNames, this.dictFieldsMap));
            }
            buf.append(",\"rows\":[");
        }
        while (this.resultSet.next()) {
            if (++count > (long)maxRecs) {
                --count;
                break;
            }
            if (count < this.beginIndex) continue;
            if (count > this.endIndex) {
                if (!hasTotal) continue;
                break;
            }
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append('{');
            i = 0;
            while (i < j) {
                String val;
                if (i > 0) {
                    buf.append(',');
                }
                Object object = DbUtil.getObject(this.resultSet, i + 1, types[i]);
                buf.append(names[i]);
                buf.append(':');
                if (isTree) {
                    val = object == null ? "null" : ((val = object.toString()).equals("_[]") ? "[]" : (val.equals("_true") ? "true" : (val.equals("_false") ? "false" : StringUtil.encode(object))));
                    buf.append(val);
                } else {
                    buf.append(StringUtil.encode(object));
                }
                if (this.createKeyValues && keyMaps[i] != null) {
                    buf.append(',');
                    buf.append(keyNames[i]);
                    buf.append(':');
                    if (object == null) {
                        buf.append("null");
                    } else {
                        val = KVBuffer.getValue((ConcurrentHashMap)keyMaps[i], this.request, object);
                        buf.append(StringUtil.quote(val));
                    }
                }
                ++i;
            }
            buf.append('}');
        }
        if (!hasTotal) {
            this.totalCount = count;
        }
        buf.append("],\"total\":");
        buf.append(this.totalCount);
        if (!StringUtil.isEmpty(this.tag)) {
            buf.append(',');
            buf.append(this.tag);
        }
        if (this.startTime > 0L) {
            buf.append(",\"elapsed\":");
            buf.append(Long.toString(System.currentTimeMillis() - this.startTime));
        }
        buf.append("}");
        return buf.toString();
    }

    private String getObject() throws Exception {
        JSONObject jo = new JSONObject();
        if (this.resultSet.next()) {
            ResultSetMetaData meta = this.resultSet.getMetaData();
            int j = meta.getColumnCount();
            int i = 0;
            while (i < j) {
                Object value;
                int type = meta.getColumnType(i + 1);
                String key = meta.getColumnLabel(i + 1);
                if (StringUtil.isEmpty(key)) {
                    key = "FIELD" + Integer.toString(i + 1);
                }
                if ((value = DbUtil.getObject(this.resultSet, i + 1, type)) == null) {
                    value = JSONObject.NULL;
                }
                jo.put(key, value);
                ++i;
            }
        }
        return jo.toString();
    }

    private JSONArray mergeFields(JSONArray source, JSONArray dest) {
        int j = source.length() - 1;
        int l = dest.length();
        int k = 0;
        while (k < l) {
            JSONObject destObj = dest.getJSONObject(k);
            String destName = destObj.getString("name");
            int i = j;
            while (i >= 0) {
                JSONObject sourceObj = source.getJSONObject(i);
                if (destName.equals(sourceObj.getString("name"))) {
                    source.remove(i);
                    --j;
                    break;
                }
                --i;
            }
            ++k;
        }
        k = 0;
        while (k < l) {
            source.put((Object)dest.getJSONObject(k));
            ++k;
        }
        return source;
    }
}

