/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Base;
import com.wb.common.Var;
import com.wb.util.FileUtil;
import com.wb.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;

public class MailSender {
    private Session session;
    private Transport transport;

    public MailSender(String smtp, String username, String password, boolean needAuth) throws Exception {
        Properties props = new Properties();
        props.put("mail.smtp.host", smtp);
        props.put("mail.smtp.auth", Boolean.toString(needAuth));
        this.session = Session.getDefaultInstance((Properties)props, null);
        this.transport = this.session.getTransport("smtp");
        try {
            this.transport.connect(smtp, username, password);
        }
        catch (Throwable e) {
            this.close();
        }
    }

    public void close() throws Exception {
        this.transport.close();
    }

    public void send(String from, String to, String cc, String bcc, String title, String content) throws Exception {
        this.send(from, to, cc, bcc, title, content, null, null, null, null);
    }

    public void send(String from, String to, String cc, String bcc, String title, String content, String attachFiles, HttpServletRequest request, String attachObjects, String attachObjectNames) throws Exception {
        MimeMultipart multipart = new MimeMultipart();
        MimeMessage message = new MimeMessage(this.session);
        int sepPos = from.indexOf(60);
        if (sepPos != -1) {
            message.setFrom((Address)new InternetAddress(from.substring(sepPos + 1, from.length() - 1), from.substring(0, sepPos).trim()));
        } else {
            message.setFrom((Address)new InternetAddress(from));
        }
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
        if (!StringUtil.isEmpty(cc)) {
            message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
        }
        if (!StringUtil.isEmpty(bcc)) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc));
        }
        message.setSubject(title);
        message.setSentDate(new Date());
        this.addContent((Multipart)multipart, content);
        this.attachFiles((Multipart)multipart, attachFiles, request, attachObjects, attachObjectNames);
        message.setContent((Multipart)multipart);
        message.saveChanges();
        this.transport.sendMessage((Message)message, message.getAllRecipients());
    }

    private void addContent(Multipart multipart, String content) throws Exception {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Object)content, "text/html;charset=utf-8");
        multipart.addBodyPart((BodyPart)bodyPart);
    }

    private void attachFiles(Multipart multipart, String attachFiles, HttpServletRequest request, String attachObjects, String attachObjectNames) throws Exception {
        MimeBodyPart bodyPart;
        int i;
        int j;
        if (!StringUtil.isEmpty(attachFiles)) {
            if (!attachFiles.startsWith("[")) {
                attachFiles = "[" + attachFiles + "]";
            }
            JSONArray ja = new JSONArray(attachFiles);
            j = ja.length();
            i = 0;
            while (i < j) {
                bodyPart = new MimeBodyPart();
                String file = ja.getString(i);
                bodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(new File(Base.path, file))));
                bodyPart.setFileName(MimeUtility.encodeText((String)FileUtil.getFilename(file)));
                bodyPart.setHeader("content-id", "attach" + i);
                multipart.addBodyPart((BodyPart)bodyPart);
                ++i;
            }
        }
        if (!StringUtil.isEmpty(attachObjects)) {
            boolean hasObjNames;
            String[] objNames = null;
            String[] list = StringUtil.split(attachObjects, ",");
            boolean bl = hasObjNames = !StringUtil.isEmpty(attachObjectNames);
            if (hasObjNames) {
                objNames = StringUtil.split(attachObjectNames, ",");
            }
            j = list.length;
            i = 0;
            while (i < j) {
                Object object = request.getAttribute(list[i]);
                if (object != null) {
                    BinDataSource dataSource = object instanceof InputStream ? new BinDataSource((InputStream)object) : (object instanceof byte[] ? new BinDataSource((byte[])object) : new BinDataSource(object.toString()));
                    bodyPart = new MimeBodyPart();
                    bodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                    if (hasObjNames) {
                        bodyPart.setFileName(MimeUtility.encodeText((String)objNames[i]));
                    } else {
                        bodyPart.setFileName(MimeUtility.encodeText((String)list[i]));
                    }
                    bodyPart.setHeader("content-id", list[i]);
                    multipart.addBodyPart((BodyPart)bodyPart);
                }
                ++i;
            }
        }
    }

    private class BinDataSource
    implements DataSource {
        private byte[] byteData;

        public BinDataSource(InputStream stream) throws IOException {
            int ch;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((ch = stream.read()) != -1) {
                os.write(ch);
            }
            this.byteData = os.toByteArray();
        }

        public BinDataSource(byte[] data) {
            this.byteData = data;
        }

        public BinDataSource(String data) throws Exception {
            String charset = Var.getString("sys.locale.mailCharset");
            this.byteData = StringUtil.isEmpty(charset) ? data.getBytes() : data.getBytes(charset);
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.byteData);
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public String getName() {
            return "dummy";
        }
    }
}

