/*
 * Decompiled with CFR 0.152.
 */
package com.wb.tool;

import com.wb.common.Str;
import com.wb.common.Var;
import com.wb.tool.Console;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class Query {
    public HttpServletRequest request;
    public String sql;
    public String jndi;
    public String arrayName;
    public JSONArray arrayData;
    public boolean batchUpdate;
    public String type;
    public String transaction;
    public String isolation;
    public boolean uniqueUpdate;
    public String errorText;
    private String debugSql;
    private String formattedSql;
    private ArrayList<Object[]> paramList;
    private ArrayList<String> paramValList;
    private int paramCount;
    private PreparedStatement statement;

    public Object run() throws Exception {
        boolean isCall;
        this.checkProperties();
        boolean hasArray = this.arrayData != null || !StringUtil.isEmpty(this.arrayName);
        HashMap<String, Object> result = null;
        this.sql = this.sql.trim();
        this.replaceMacros();
        Connection connection = DbUtil.getConnection(this.request, this.jndi);
        boolean isCommit = "commit".equals(this.transaction);
        if (isCommit) {
            if (connection.getAutoCommit()) {
                this.transaction = "start";
            }
        } else if (StringUtil.isEmpty(this.transaction) && (this.uniqueUpdate || hasArray) && connection.getAutoCommit()) {
            this.transaction = "start";
        }
        if ("start".equals(this.transaction)) {
            DbUtil.startTransaction(connection, this.isolation);
        }
        if (StringUtil.isEmpty(this.type)) {
            this.type = this.sql.startsWith("{") ? "call" : "execute";
        }
        this.statement = (isCall = "call".equals(this.type)) ? connection.prepareCall(this.formattedSql) : connection.prepareStatement(this.formattedSql);
        WebUtil.setObject(this.request, SysUtil.getId(), this.statement);
        this.regParameters();
        if (hasArray) {
            this.executeBatch();
        } else {
            if (Var.debug) {
                this.printSql();
            }
            if ("query".equals(this.type)) {
                result = this.statement.executeQuery();
                WebUtil.setObject(this.request, SysUtil.getId(), result);
            } else if ("update".equals(this.type)) {
                int affectedRows = this.statement.executeUpdate();
                result = affectedRows;
                if (this.uniqueUpdate && affectedRows != 1) {
                    this.notUnique();
                }
            } else {
                HashMap<String, Object> map;
                if (this.statement.execute()) {
                    result = this.statement.getResultSet();
                    WebUtil.setObject(this.request, SysUtil.getId(), result);
                } else {
                    int affectedRows = this.statement.getUpdateCount();
                    result = affectedRows;
                    if (this.uniqueUpdate && affectedRows != 1) {
                        this.notUnique();
                    }
                }
                if (isCall && this.paramCount > 0 && (map = this.getOutParameter()).size() > 0) {
                    if (map.containsKey("return")) {
                        throw new IllegalArgumentException("Invalid output parameter name \"return\"");
                    }
                    map.put("return", result);
                    result = map;
                }
            }
        }
        if (isCommit) {
            connection.commit();
            connection.setAutoCommit(true);
        }
        this.checkError(result);
        return result;
    }

    private void checkProperties() {
        String[] isolations;
        String[] types;
        String[] trans;
        if (!StringUtil.isEmpty(this.transaction) && StringUtil.indexOf(trans = new String[]{"start", "commit", "none"}, this.transaction) == -1) {
            throw new IllegalArgumentException("Invalid transaction \"" + this.transaction + "\".");
        }
        if (!StringUtil.isEmpty(this.type) && StringUtil.indexOf(types = new String[]{"query", "update", "execute", "call"}, this.type) == -1) {
            throw new IllegalArgumentException("Invalid type \"" + this.type + "\".");
        }
        if (!StringUtil.isEmpty(this.isolation) && StringUtil.indexOf(isolations = new String[]{"readCommitted", "readUncommitted", "repeatableRead", "serializable"}, this.isolation) == -1) {
            throw new IllegalArgumentException("Invalid isolation \"" + this.isolation + "\".");
        }
    }

    private void executeBatch() throws Exception {
        JSONArray ja;
        if (this.arrayData == null) {
            Object obj = WebUtil.fetchObject(this.request, this.arrayName);
            if (obj instanceof JSONArray) {
                ja = (JSONArray)obj;
            } else {
                if (obj == null) {
                    return;
                }
                String val = obj.toString();
                if (val.isEmpty()) {
                    return;
                }
                ja = new JSONArray(val);
            }
        } else {
            ja = this.arrayData;
        }
        int j = ja.length();
        if (j == 0) {
            return;
        }
        int i = 0;
        while (i < j) {
            JSONObject jo = ja.getJSONObject(i);
            int k = 0;
            while (k < this.paramCount) {
                Object[] param = this.paramList.get(k);
                String name = (String)param[0];
                if (!((Boolean)param[2]).booleanValue() && jo.has(name)) {
                    Object valObj = JsonUtil.opt(jo, name);
                    DbUtil.setObject(this.statement, k + 1, (Integer)param[1], valObj);
                    if (Var.debug) {
                        this.paramValList.set(k, StringUtil.toString(valObj));
                    }
                }
                ++k;
            }
            if (Var.debug) {
                this.printSql();
            }
            if (this.batchUpdate) {
                this.statement.addBatch();
            } else {
                int affectedRows = this.statement.executeUpdate();
                if (this.uniqueUpdate && affectedRows != 1) {
                    this.notUnique();
                }
            }
            ++i;
        }
        if (this.batchUpdate) {
            this.statement.executeBatch();
        }
    }

    private void notUnique() {
        throw new RuntimeException(Str.format(this.request, "updateNotUnique", new Object[0]));
    }

    private void replaceMacros() {
        StringBuilder buf = new StringBuilder();
        int startPos = 0;
        int endPos = 0;
        int lastPos = 0;
        while ((startPos = this.sql.indexOf("{?", startPos)) > -1 && (endPos = this.sql.indexOf("?}", endPos)) > -1) {
            buf.append(this.sql.substring(lastPos, startPos));
            startPos += 2;
            buf.append("'{?");
            buf.append(this.sql.substring((endPos += 2) - 1, endPos));
            buf.append('\'');
            lastPos = endPos;
        }
        buf.append(this.sql.substring(lastPos));
        this.debugSql = buf.toString();
        this.formattedSql = StringUtil.replaceAll(this.debugSql, "'{?}'", "?");
    }

    private void regParameters() throws Exception {
        int index = 1;
        int startPos = 0;
        int endPos = 0;
        this.paramList = new ArrayList();
        if (Var.debug) {
            this.paramValList = new ArrayList();
        }
        CallableStatement callStatement = this.statement instanceof CallableStatement ? (CallableStatement)this.statement : null;
        boolean isCall = callStatement != null;
        while ((startPos = this.sql.indexOf("{?", startPos)) > -1 && (endPos = this.sql.indexOf("?}", endPos)) > -1) {
            int type;
            String paraName;
            int dotPos;
            boolean isOutParam;
            String param = this.sql.substring(startPos += 2, endPos);
            endPos += 2;
            String orgParam = param;
            boolean bl = isOutParam = isCall && param.startsWith("@");
            if (isOutParam) {
                boolean hasSub;
                String typeText;
                dotPos = (param = param.substring(1)).indexOf(46);
                if (dotPos == -1) {
                    typeText = "varchar";
                    paraName = param;
                } else {
                    typeText = param.substring(0, dotPos);
                    paraName = param.substring(dotPos + 1);
                }
                boolean bl2 = hasSub = typeText.indexOf(61) != -1;
                if (hasSub) {
                    type = DbUtil.getFieldType(StringUtil.getNamePart(typeText));
                    int subType = Integer.parseInt(StringUtil.getValuePart(typeText));
                    callStatement.registerOutParameter(index, type, subType);
                } else {
                    type = DbUtil.getFieldType(typeText);
                    callStatement.registerOutParameter(index, type);
                }
                if (Var.debug) {
                    this.paramValList.add(orgParam);
                }
            } else {
                dotPos = param.indexOf(46);
                if (dotPos == -1) {
                    type = 12;
                    paraName = param;
                } else {
                    Integer typeObj = DbUtil.getFieldType(param.substring(0, dotPos));
                    if (typeObj == null) {
                        type = 12;
                        paraName = param;
                    } else {
                        type = typeObj;
                        paraName = param.substring(dotPos + 1);
                    }
                }
                Object obj = WebUtil.fetchObject(this.request, paraName);
                DbUtil.setObject(this.statement, index, type, obj);
                if (Var.debug) {
                    this.paramValList.add(StringUtil.toString(obj));
                }
            }
            Object[] paramObjects = new Object[]{paraName, type, isOutParam};
            this.paramList.add(paramObjects);
            ++index;
        }
        this.paramCount = this.paramList.size();
    }

    private HashMap<String, Object> getOutParameter() throws Exception {
        CallableStatement st = (CallableStatement)this.statement;
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < this.paramCount) {
            Object[] param = this.paramList.get(i);
            if (((Boolean)param[2]).booleanValue()) {
                Object object = DbUtil.getObject(st, i + 1, (int)((Integer)param[1]));
                if (object instanceof ResultSet) {
                    WebUtil.setObject(this.request, SysUtil.getId(), object);
                }
                map.put((String)param[0], object);
            }
            ++i;
        }
        return map;
    }

    private void checkError(Object object) throws Exception {
        ResultSet rs;
        if (!StringUtil.isEmpty(this.errorText) && object instanceof ResultSet && (rs = (ResultSet)object).next()) {
            throw new RuntimeException(this.errorText);
        }
    }

    private void printSql() {
        String sql = this.debugSql;
        for (String s : this.paramValList) {
            sql = StringUtil.replaceFirst(sql, "{?}", s);
        }
        Console.log(this.request, sql);
    }
}

