/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.util.StringUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static String format(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static String format(Date date) {
        return DateUtil.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static Timestamp getTimestamp(long time) {
        return new Timestamp(time);
    }

    public static int daysInMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(5);
    }

    public static int dayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int yearOf(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int dayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(6);
    }

    public static int dayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public static String dateToStr(Date value) {
        if (value == null) {
            return null;
        }
        Timestamp t = new Timestamp(value.getTime());
        return t.toString();
    }

    public static Timestamp strToDate(String value) {
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        return Timestamp.valueOf(value);
    }

    public static Date incYear(Date date, int years) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, years);
        return cal.getTime();
    }

    public static Date incMonth(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, months);
        return cal.getTime();
    }

    public static int hourOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(11);
    }

    public static String format(long milliSecs) {
        long h = milliSecs / 3600000L;
        long hm = milliSecs % 3600000L;
        long m = hm / 60000L;
        long mm = hm % 60000L;
        long s = mm / 1000L;
        long sm = mm % 1000L;
        return StringUtil.concat(Long.toString(h), ":", Long.toString(m), ":", Long.toString(s), ".", Long.toString(sm));
    }

    public static Date incDay(Date date, long days) {
        return new Date(date.getTime() + 86400000L * days);
    }

    public static Date incSecond(Date date, long seconds) {
        return new Date(date.getTime() + 1000L * seconds);
    }

    public static int getElapsedDays(Date beginDate, Date endDate) {
        return (int)((endDate.getTime() - beginDate.getTime()) / 86400000L);
    }

    public static String fix(String string) {
        if (string.indexOf(47) != -1) {
            string = StringUtil.replaceAll(string, "/", "-");
        }
        if (string.length() == 10) {
            string = String.valueOf(string) + " 00:00:00.0";
        }
        return string;
    }
}

